'use strict';

const permissionsList = [
  "access.admin",
  "access.admin.profit",
  "access.affiliate",
  "access.affiliate.referral",
  "access.affiliate.reward",
  "access.affiliate.settings",
  "access.ai.binary-engine",
  "access.ai.investment",
  "access.ai.investment.duration",
  "access.ai.investment.plan",
  "access.ai.market.maker",
  "access.ai.market.maker.analytics",
  "access.ai.market.maker.settings",
  "access.ai.trading.market",
  "access.announcement",
  "access.api.key",
  "access.binary.ai.engine.ab.tests",
  "access.binary.ai.engine.ab.tests.apply",
  "access.binary.ai.engine.ab.tests.results",
  "access.binary.ai.engine.ab.tests.stop",
  "access.binary.ai.engine.cohort",
  "access.binary.ai.engine.cohort.analyze",
  "access.binary.ai.engine.cohort.compare",
  "access.binary.ai.engine.cohort.create",
  "access.binary.ai.engine.cohort.delete",
  "access.binary.ai.engine.cohort.templates",
  "access.binary.ai.engine.correlation",
  "access.binary.ai.engine.correlation.alerts",
  "access.binary.ai.engine.correlation.check",
  "access.binary.ai.engine.correlation.config",
  "access.binary.ai.engine.correlation.history",
  "access.binary.ai.engine.ml.optimize",
  "access.binary.ai.engine.ml.train",
  "access.binary.ai.engine.time.analytics",
  "access.binary.ai.engine.time.optimizations",
  "access.binary.market",
  "access.binary.order",
  "access.binary.settings",
  "access.blog",
  "access.blog.author",
  "access.blog.category",
  "access.blog.comment",
  "access.blog.post",
  "access.blog.settings",
  "access.blog.tag",
  "access.content.media",
  "access.content.slider",
  "access.copy_trading",
  "access.cron",
  "access.database",
  "access.deposit",
  "access.deposit.gateway",
  "access.deposit.method",
  "access.ecommerce.category",
  "access.ecommerce.dashboard",
  "access.ecommerce.discount",
  "access.ecommerce.order",
  "access.ecommerce.product",
  "access.ecommerce.review",
  "access.ecommerce.shipping",
  "access.ecommerce.wishlist",
  "access.ecosystem",
  "access.ecosystem.blockchain",
  "access.ecosystem.custodial.wallet",
  "access.ecosystem.market",
  "access.ecosystem.master.wallet",
  "access.ecosystem.order",
  "access.ecosystem.private.ledger",
  "access.ecosystem.token",
  "access.ecosystem.utxo",
  "access.exchange",
  "access.exchange.market",
  "access.exchange.order",
  "access.extension",
  "access.faq",
  "access.faq.feedback",
  "access.faq.question",
  "access.fiat.currency",
  "access.forex",
  "access.forex.account",
  "access.forex.deposit",
  "access.forex.duration",
  "access.forex.investment",
  "access.forex.plan",
  "access.forex.signal",
  "access.forex.withdraw",
  "access.futures.market",
  "access.futures.order",
  "access.futures.position",
  "access.gateway.merchant",
  "access.gateway.payment",
  "access.gateway.payout",
  "access.gateway.settings",
  "access.ico",
  "access.ico.offer",
  "access.ico.settings",
  "access.ico.stat",
  "access.ico.transaction",
  "access.investment",
  "access.investment.duration",
  "access.investment.history",
  "access.investment.plan",
  "access.kyc.application",
  "access.kyc.level",
  "access.mailwizard.campaign",
  "access.mailwizard.template",
  "access.nft",
  "access.nft.activity",
  "access.nft.admin",
  "access.nft.analytics",
  "access.nft.auction",
  "access.nft.category",
  "access.nft.collection",
  "access.nft.creator",
  "access.nft.dispute",
  "access.nft.listing",
  "access.nft.marketplace",
  "access.nft.offer",
  "access.nft.sale",
  "access.nft.settings",
  "access.nft.token",
  "access.notification.settings",
  "access.notification.template",
  "access.p2p",
  "access.p2p.activity",
  "access.p2p.dispute",
  "access.p2p.offer",
  "access.p2p.payment_method",
  "access.p2p.settings",
  "access.p2p.trade",
  "access.permission",
  "access.profit",
  "access.role",
  "access.settings",
  "access.slider",
  "access.spot.currency",
  "access.staking",
  "access.staking.earning",
  "access.staking.management",
  "access.staking.pool",
  "access.staking.position",
  "access.staking.settings",
  "access.support.ticket",
  "access.system",
  "access.system.announcement",
  "access.system.update",
  "access.trading.settings",
  "access.transaction",
  "access.transfer",
  "access.user",
  "access.wallet",
  "access.withdraw",
  "access.withdraw.method",
  "create.admin.profit",
  "create.affiliate.condition",
  "create.affiliate.referral",
  "create.affiliate.reward",
  "create.ai.binary-engine",
  "create.ai.investment",
  "create.ai.investment.duration",
  "create.ai.investment.plan",
  "create.ai.market-maker.market",
  "create.ai.market.maker",
  "create.ai.trading.market",
  "create.announcement",
  "create.api.key",
  "create.binary.ai.engine.ab.test",
  "create.binary.market",
  "create.binary.order",
  "create.blog.author",
  "create.blog.category",
  "create.blog.comment",
  "create.blog.post",
  "create.blog.tag",
  "create.copy_trading",
  "create.deposit",
  "create.deposit.gateway",
  "create.deposit.method",
  "create.ecommerce.category",
  "create.ecommerce.discount",
  "create.ecommerce.order",
  "create.ecommerce.product",
  "create.ecommerce.review",
  "create.ecommerce.shipping",
  "create.ecommerce.wishlist",
  "create.ecosystem.custodial.wallet",
  "create.ecosystem.market",
  "create.ecosystem.master.wallet",
  "create.ecosystem.order",
  "create.ecosystem.private.ledger",
  "create.ecosystem.token",
  "create.ecosystem.utxo",
  "create.exchange.market",
  "create.exchange.order",
  "create.faq",
  "create.faq.feedback",
  "create.fiat.currency",
  "create.forex.account",
  "create.forex.deposit",
  "create.forex.duration",
  "create.forex.investment",
  "create.forex.plan",
  "create.forex.signal",
  "create.forex.withdraw",
  "create.futures.market",
  "create.futures.order",
  "create.futures.position",
  "create.gateway.merchant",
  "create.gateway.payment",
  "create.gateway.payout",
  "create.ico.offer",
  "create.ico.transaction",
  "create.investment",
  "create.investment.duration",
  "create.investment.history",
  "create.investment.plan",
  "create.kyc.level",
  "create.license",
  "create.mailwizard.campaign",
  "create.mailwizard.template",
  "create.nft",
  "create.nft.auction",
  "create.nft.category",
  "create.nft.collection",
  "create.nft.creator",
  "create.nft.listing",
  "create.nft.offer",
  "create.nft.sale",
  "create.nft.token",
  "create.p2p.dispute",
  "create.p2p.offer",
  "create.p2p.payment_method",
  "create.p2p.trade",
  "create.page",
  "create.permission",
  "create.profit",
  "create.role",
  "create.slider",
  "create.spot.currency",
  "create.staking.earning",
  "create.staking.performance",
  "create.staking.pool",
  "create.staking.position",
  "create.support.ticket",
  "create.transaction",
  "create.transfer",
  "create.user",
  "create.wallet",
  "create.withdraw",
  "create.withdraw.method",
  "delete.admin.profit",
  "delete.affiliate.referral",
  "delete.affiliate.reward",
  "delete.ai.binary-engine",
  "delete.ai.investment",
  "delete.ai.investment.duration",
  "delete.ai.investment.plan",
  "delete.ai.market-maker.market",
  "delete.ai.trading.market",
  "delete.announcement",
  "delete.api.key",
  "delete.binary.market",
  "delete.binary.order",
  "delete.blog.author",
  "delete.blog.category",
  "delete.blog.comment",
  "delete.blog.post",
  "delete.blog.tag",
  "delete.content.media",
  "delete.copy_trading",
  "delete.deposit",
  "delete.deposit.gateway",
  "delete.deposit.method",
  "delete.ecommerce.category",
  "delete.ecommerce.discount",
  "delete.ecommerce.order",
  "delete.ecommerce.product",
  "delete.ecommerce.review",
  "delete.ecommerce.shipping",
  "delete.ecommerce.wishlist",
  "delete.ecosystem.custodial.wallet",
  "delete.ecosystem.market",
  "delete.ecosystem.master.wallet",
  "delete.ecosystem.order",
  "delete.ecosystem.private.ledger",
  "delete.ecosystem.token",
  "delete.ecosystem.utxo",
  "delete.exchange.market",
  "delete.exchange.order",
  "delete.faq",
  "delete.fiat.currency",
  "delete.forex.account",
  "delete.forex.deposit",
  "delete.forex.duration",
  "delete.forex.investment",
  "delete.forex.plan",
  "delete.forex.signal",
  "delete.forex.withdraw",
  "delete.futures.market",
  "delete.futures.order",
  "delete.futures.position",
  "delete.gateway.merchant",
  "delete.gateway.payment",
  "delete.gateway.payout",
  "delete.ico.offer",
  "delete.ico.transaction",
  "delete.investment",
  "delete.investment.duration",
  "delete.investment.history",
  "delete.investment.plan",
  "delete.kyc.application",
  "delete.kyc.level",
  "delete.mailwizard.campaign",
  "delete.mailwizard.template",
  "delete.nft",
  "delete.nft.auction",
  "delete.nft.backup",
  "delete.nft.category",
  "delete.nft.collection",
  "delete.nft.creator",
  "delete.nft.listing",
  "delete.nft.offer",
  "delete.nft.sale",
  "delete.nft.token",
  "delete.p2p.dispute",
  "delete.p2p.offer",
  "delete.p2p.payment_method",
  "delete.p2p.trade",
  "delete.page",
  "delete.permission",
  "delete.profit",
  "delete.role",
  "delete.slider",
  "delete.spot.currency",
  "delete.staking.pool",
  "delete.staking.position",
  "delete.support.ticket",
  "delete.transaction",
  "delete.transfer",
  "delete.user",
  "delete.wallet",
  "delete.withdraw",
  "delete.withdraw.method",
  "edit.admin.profit",
  "edit.affiliate.condition",
  "edit.affiliate.referral",
  "edit.affiliate.reward",
  "edit.ai.binary-engine",
  "edit.ai.investment",
  "edit.ai.investment.duration",
  "edit.ai.investment.plan",
  "edit.ai.market-maker.bot",
  "edit.ai.market-maker.emergency",
  "edit.ai.market-maker.market",
  "edit.ai.market-maker.pool",
  "edit.ai.trading.market",
  "edit.announcement",
  "edit.api.key",
  "edit.binary.market",
  "edit.binary.order",
  "edit.binary.settings",
  "edit.blog.author",
  "edit.blog.category",
  "edit.blog.comment",
  "edit.blog.post",
  "edit.blog.tag",
  "edit.copy_trading",
  "edit.deposit",
  "edit.deposit.gateway",
  "edit.deposit.method",
  "edit.ecommerce.category",
  "edit.ecommerce.discount",
  "edit.ecommerce.order",
  "edit.ecommerce.product",
  "edit.ecommerce.review",
  "edit.ecommerce.shipping",
  "edit.ecommerce.wishlist",
  "edit.ecosystem.blockchain",
  "edit.ecosystem.custodial.wallet",
  "edit.ecosystem.market",
  "edit.ecosystem.master.wallet",
  "edit.ecosystem.order",
  "edit.ecosystem.private.ledger",
  "edit.ecosystem.token",
  "edit.ecosystem.utxo",
  "edit.exchange",
  "edit.exchange.market",
  "edit.exchange.order",
  "edit.extension",
  "edit.faq",
  "edit.faq.question",
  "edit.fiat.currency",
  "edit.forex.account",
  "edit.forex.deposit",
  "edit.forex.duration",
  "edit.forex.investment",
  "edit.forex.plan",
  "edit.forex.signal",
  "edit.forex.withdraw",
  "edit.futures.market",
  "edit.futures.order",
  "edit.futures.position",
  "edit.gateway.merchant",
  "edit.gateway.payment",
  "edit.gateway.payout",
  "edit.gateway.settings",
  "edit.ico.offer",
  "edit.ico.settings",
  "edit.ico.transaction",
  "edit.investment",
  "edit.investment.duration",
  "edit.investment.history",
  "edit.investment.plan",
  "edit.kyc.application",
  "edit.kyc.level",
  "edit.kyc.verification",
  "edit.mailwizard.campaign",
  "edit.mailwizard.template",
  "edit.nft",
  "edit.nft.auction",
  "edit.nft.category",
  "edit.nft.collection",
  "edit.nft.creator",
  "edit.nft.listing",
  "edit.nft.marketplace",
  "edit.nft.offer",
  "edit.nft.sale",
  "edit.nft.token",
  "edit.notification.template",
  "edit.p2p.dispute",
  "edit.p2p.offer",
  "edit.p2p.payment_method",
  "edit.p2p.trade",
  "edit.page",
  "edit.permission",
  "edit.profit",
  "edit.role",
  "edit.settings",
  "edit.slider",
  "edit.spot.currency",
  "edit.staking.earning",
  "edit.staking.pool",
  "edit.staking.position",
  "edit.support.ticket",
  "edit.transaction",
  "edit.transfer",
  "edit.user",
  "edit.wallet",
  "edit.withdraw",
  "edit.withdraw.method",
  "export.user",
  "import.user",
  "manage.ai.binary-engine",
  "manage.cron",
  "manage.ecosystem.order",
  "manage.exchange.chart",
  "manage.gateway.payment",
  "manage.nft.backup",
  "manage.system",
  "update.binary.market",
  "view.admin.profit",
  "view.affiliate.condition",
  "view.affiliate.referral",
  "view.affiliate.reward",
  "view.ai.binary-engine",
  "view.ai.investment",
  "view.ai.investment.duration",
  "view.ai.investment.plan",
  "view.ai.market-maker.analytics",
  "view.ai.market-maker.bot",
  "view.ai.market-maker.market",
  "view.ai.market-maker.pool",
  "view.ai.market.maker",
  "view.ai.trading.market",
  "view.announcement",
  "view.api.key",
  "view.binary.market",
  "view.binary.order",
  "view.blog.author",
  "view.blog.category",
  "view.blog.comment",
  "view.blog.post",
  "view.blog.tag",
  "view.content.media",
  "view.copy_trading",
  "view.crm.role",
  "view.cron",
  "view.deposit",
  "view.deposit.gateway",
  "view.deposit.method",
  "view.ecommerce.category",
  "view.ecommerce.discount",
  "view.ecommerce.order",
  "view.ecommerce.product",
  "view.ecommerce.review",
  "view.ecommerce.shipping",
  "view.ecommerce.wishlist",
  "view.ecosystem.blockchain",
  "view.ecosystem.custodial.wallet",
  "view.ecosystem.market",
  "view.ecosystem.master.wallet",
  "view.ecosystem.order",
  "view.ecosystem.private.ledger",
  "view.ecosystem.token",
  "view.ecosystem.utxo",
  "view.exchange",
  "view.exchange.balance",
  "view.exchange.chart",
  "view.exchange.fee",
  "view.exchange.market",
  "view.exchange.order",
  "view.exchange.watchlist",
  "view.extension",
  "view.faq",
  "view.faq.category",
  "view.faq.feedback",
  "view.faq.question",
  "view.fiat.currency",
  "view.forex.account",
  "view.forex.deposit",
  "view.forex.duration",
  "view.forex.investment",
  "view.forex.plan",
  "view.forex.signal",
  "view.forex.withdraw",
  "view.futures.market",
  "view.futures.order",
  "view.futures.position",
  "view.gateway.merchant",
  "view.gateway.payment",
  "view.gateway.payout",
  "view.gateway.refund",
  "view.gateway.settings",
  "view.ico.offer",
  "view.ico.settings",
  "view.ico.transaction",
  "view.investment",
  "view.investment.duration",
  "view.investment.history",
  "view.investment.plan",
  "view.kyc.application",
  "view.kyc.level",
  "view.kyc.verification",
  "view.mailwizard.campaign",
  "view.mailwizard.template",
  "view.nft",
  "view.nft.auction",
  "view.nft.backup",
  "view.nft.category",
  "view.nft.collection",
  "view.nft.creator",
  "view.nft.listing",
  "view.nft.offer",
  "view.nft.sale",
  "view.nft.token",
  "view.notification.template",
  "view.p2p.activity",
  "view.p2p.dispute",
  "view.p2p.offer",
  "view.p2p.payment_method",
  "view.p2p.trade",
  "view.page",
  "view.permission",
  "view.profit",
  "view.role",
  "view.settings",
  "view.slider",
  "view.spot.currency",
  "view.staking.activity",
  "view.staking.earning",
  "view.staking.performance",
  "view.staking.pool",
  "view.staking.position",
  "view.support.ticket",
  "view.transaction",
  "view.transfer",
  "view.user",
  "view.wallet",
  "view.withdraw",
  "view.withdraw.method",
];

/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    const existingPermissions = await queryInterface.sequelize.query(
      "SELECT name FROM permission",
      { type: queryInterface.sequelize.QueryTypes.SELECT }
    );

    const existingPermissionNames = existingPermissions.map((p) => p.name);

    const newPermissions = permissionsList
      .filter((permission) => !existingPermissionNames.includes(permission))
      .map((permission) => ({
        name: permission,
      }));

    if (newPermissions.length > 0) {
      await queryInterface.bulkInsert("permission", newPermissions);
    }
  },

  async down(queryInterface, Sequelize) {
    await queryInterface.bulkDelete("permission", {
      name: permissionsList,
    });
  },
};
