"use strict";function sanitizePath(e){return path_1.default.normalize(e)}function sanitizeUserPath(e){if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Invalid path provided"});if(e.includes("\0")||e.includes("%00"))throw(0,error_1.createError)({statusCode:400,message:"Path contains null bytes"});const r=[/\.\./g,/\.\\/g,/\.\\+/g,/\/\.+\//g,/^\.+/,/\.+$/,/\/{2,}/g,/\\{2,}/g,/[<>:"|?*]/g,/[\x00-\x1F]/g];let t=e;for(const e of r)t=t.replace(e,"");t=t.replace(/\\/g,"/");t=t.replace(/^\/+|\/+$/g,"");t&&"."!==t&&"/"!==t||(t="default");const a=["etc","bin","usr","var","proc","sys","dev","boot","root","home"],o=t.toLowerCase().split("/");for(const e of o)if(a.includes(e))throw(0,error_1.createError)({statusCode:403,message:`Access to system directory ${e} is not allowed`});if(t.length>200)throw(0,error_1.createError)({statusCode:400,message:"Path too long"});if(!/^[a-zA-Z0-9_\-/.]+$/.test(t))throw(0,error_1.createError)({statusCode:400,message:"Path contains invalid characters"});return t}function validatePathSecurity(e,r){try{const t=path_1.default.resolve(e),a=path_1.default.resolve(r);return t.startsWith(a+path_1.default.sep)||t===a}catch(e){console_1.logger.error("VALIDATION","Path validation error",e);return!1}}function convertBooleanStrings(e){if("string"==typeof e){if("true"===e.toLowerCase())return!0;if("false"===e.toLowerCase())return!1}else if("object"==typeof e&&null!==e)for(const r in e)e[r]=convertBooleanStrings(e[r]);return e}function getFieldSchema(e,r){return e.split(".").reduce((e,r)=>e&&e.properties&&e.properties[r]?e.properties[r]:{},r)}function toFriendlyName(e){return(e.split(".").pop()||e).replace(/([A-Z])/g," $1").replace(/^./,e=>e.toUpperCase()).trim()}function formatErrorMessage(e,r,t){const a=toFriendlyName(e),o=getFieldSchema(e,t)["x-expectedFormat"];let s=r.message||"";switch(r.keyword){case"required":s=`${a} is required.`;break;case"minLength":s=`${a} must be at least ${r.params.limit} characters long.`;break;case"maxLength":s=`${a} must be no more than ${r.params.limit} characters long.`;break;case"minimum":s=`${a} must be at least ${r.params.limit}.`;break;case"maximum":s=`${a} must not exceed ${r.params.limit}.`;break;case"enum":s=`${a} must be one of the following: ${r.params.allowedValues.join(", ")}.`;break;case"pattern":s=`${a} is incorrectly formatted. Expected format: ${o||r.params.pattern}.`;break;case"type":s=`${a} must be a ${r.params.type}.`;break;default:s=`${a} ${r.message}.`}return s}function formatAjvErrors(e){const r={};for(const t in e)r[t]=[e[t]];return r}function validateSchema(e,r){const t=new ajv_1.default({allErrors:!0,coerceTypes:!0,strict:!1});(0,ajv_formats_1.default)(t);t.addKeyword({keyword:"x-expectedFormat",metaSchema:{type:"string"}});let a;try{a=t.compile(r)}catch(e){console_1.logger.error("VALIDATION","Schema compilation failed",e);throw(0,error_1.createError)({statusCode:400,message:"Schema compilation failed: "+e.message})}const o=convertBooleanStrings(e);if(!a(o)){const e=(a.errors||[]).map(e=>{let t=e.instancePath.replace(/^\//,"").replace(/\//g,".");!t&&e.params&&e.params.missingProperty&&(t=e.params.missingProperty);return{path:t,message:formatErrorMessage(t,e,r)}});console_1.logger.debug("VALIDATION",`Schema validation failed: ${JSON.stringify(e)}`);const t=e.map(e=>e.message),o=1===t.length?t[0]:t.join("; "),s=new Error(o);s.details=e;s.isValidationError=!0;throw s}return o}function validateUploadFilePath(e){if(!e||"string"!=typeof e)return{isValid:!1,exists:!1,error:"Invalid file path"};if(!e.startsWith("/uploads/"))return{isValid:!1,exists:!1,error:"File path must start with /uploads/"};try{const r=require("fs"),t=require("path"),a="production"===process.env.NODE_ENV?t.join(process.cwd(),"frontend","public"):t.join(process.cwd(),"..","frontend","public"),o=t.join(a,e),s=r.existsSync(o);return{isValid:!0,exists:s,fullPath:o,error:s?void 0:"File does not exist"}}catch(e){return{isValid:!1,exists:!1,error:`Error validating file: ${e.message}`}}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.sanitizePath=sanitizePath;exports.sanitizeUserPath=sanitizeUserPath;exports.validatePathSecurity=validatePathSecurity;exports.validateSchema=validateSchema;exports.validateUploadFilePath=validateUploadFilePath;const ajv_1=__importDefault(require("ajv")),ajv_formats_1=__importDefault(require("ajv-formats")),path_1=__importDefault(require("path")),console_1=require("./console"),error_1=require("./error");