"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.baseModelSchema=exports.commonFields=exports.singleItemResponse=exports.paginatedResponse=exports.paginationSchema=exports.statusUpdateResponses=exports.bulkDeleteResponses=exports.createResponses=exports.updateResponses=exports.deleteResponses=exports.successMessageResponse=exports.serviceUnavailableResponse=exports.badGatewayResponse=exports.serverErrorResponse=exports.rateLimitResponse=exports.unprocessableEntityResponse=exports.conflictResponse=exports.notFoundResponse=exports.forbiddenResponse=exports.adminUnauthorizedResponse=exports.unauthorizedResponse=exports.validationErrorResponse=exports.badRequestResponse=void 0;const baseErrorSchema={type:"object",properties:{message:{type:"string",description:"Error message describing what went wrong"}},required:["message"]},extendedErrorSchema={type:"object",properties:{message:{type:"string",description:"Error message describing what went wrong"},code:{type:"string",description:"Error code for programmatic handling"},details:{type:"object",description:"Additional error details",additionalProperties:!0}},required:["message"]},validationErrorSchema={type:"object",properties:{message:{type:"string",description:"Validation error message"},errors:{type:"array",description:"List of validation errors",items:{type:"object",properties:{field:{type:"string",description:"Field that failed validation"},message:{type:"string",description:"Validation error message for this field"},code:{type:"string",description:"Validation error code"}},required:["field","message"]}}},required:["message"]};exports.badRequestResponse={description:"Bad request - Invalid or missing parameters",content:{"application/json":{schema:baseErrorSchema}}};exports.validationErrorResponse={description:"Validation error - One or more fields failed validation",content:{"application/json":{schema:validationErrorSchema}}};exports.unauthorizedResponse={description:"Unauthorized - Authentication required or invalid credentials",content:{"application/json":{schema:baseErrorSchema}}};exports.adminUnauthorizedResponse={description:"Unauthorized - Admin permission required",content:{"application/json":{schema:baseErrorSchema}}};exports.forbiddenResponse={description:"Forbidden - Insufficient permissions to perform this action",content:{"application/json":{schema:baseErrorSchema}}};const notFoundResponse=(e="Resource")=>({description:`${e} not found`,content:{"application/json":{schema:baseErrorSchema}}});exports.notFoundResponse=notFoundResponse;const conflictResponse=(e="Resource")=>({description:`Conflict - ${e} already exists or is in a conflicting state`,content:{"application/json":{schema:baseErrorSchema}}});exports.conflictResponse=conflictResponse;exports.unprocessableEntityResponse={description:"Unprocessable entity - Request understood but cannot be processed",content:{"application/json":{schema:extendedErrorSchema}}};exports.rateLimitResponse={description:"Too many requests - Rate limit exceeded",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Rate limit error message"},retryAfter:{type:"integer",description:"Seconds until rate limit resets"}},required:["message"]}}}};exports.serverErrorResponse={description:"Internal server error - An unexpected error occurred",content:{"application/json":{schema:baseErrorSchema}}};exports.badGatewayResponse={description:"Bad gateway - Error communicating with upstream service",content:{"application/json":{schema:baseErrorSchema}}};exports.serviceUnavailableResponse={description:"Service unavailable - Service is temporarily unavailable",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Service unavailable message"},retryAfter:{type:"integer",description:"Estimated seconds until service is available"}},required:["message"]}}}};const successMessageResponse=e=>({description:e,content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}},required:["message"]}}}});exports.successMessageResponse=successMessageResponse;const deleteResponses=e=>({200:(0,exports.successMessageResponse)(`${e} deleted successfully`),401:exports.unauthorizedResponse,404:(0,exports.notFoundResponse)(e),500:exports.serverErrorResponse});exports.deleteResponses=deleteResponses;const updateResponses=e=>({200:(0,exports.successMessageResponse)(`${e} updated successfully`),400:exports.badRequestResponse,401:exports.unauthorizedResponse,404:(0,exports.notFoundResponse)(e),500:exports.serverErrorResponse});exports.updateResponses=updateResponses;const createResponses=e=>({200:(0,exports.successMessageResponse)(`${e} created successfully`),400:exports.badRequestResponse,401:exports.unauthorizedResponse,409:(0,exports.conflictResponse)(e),500:exports.serverErrorResponse});exports.createResponses=createResponses;const bulkDeleteResponses=e=>({200:(0,exports.successMessageResponse)(`${e} records deleted successfully`),400:exports.badRequestResponse,401:exports.unauthorizedResponse,404:(0,exports.notFoundResponse)(e),500:exports.serverErrorResponse});exports.bulkDeleteResponses=bulkDeleteResponses;const statusUpdateResponses=e=>({200:(0,exports.successMessageResponse)(`${e} status updated successfully`),400:exports.badRequestResponse,401:exports.unauthorizedResponse,404:(0,exports.notFoundResponse)(e),500:exports.serverErrorResponse});exports.statusUpdateResponses=statusUpdateResponses;exports.paginationSchema={type:"object",properties:{totalItems:{type:"integer",description:"Total number of items across all pages"},currentPage:{type:"integer",description:"Current page number (1-indexed)"},perPage:{type:"integer",description:"Number of items per page"},totalPages:{type:"integer",description:"Total number of pages"}},required:["totalItems","currentPage","perPage","totalPages"]};const paginatedResponse=(e,s="List retrieved successfully")=>({description:s,content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:e},pagination:exports.paginationSchema},required:["data","pagination"]}}}});exports.paginatedResponse=paginatedResponse;const singleItemResponse=(e,s="Item retrieved successfully")=>({description:s,content:{"application/json":{schema:e}}});exports.singleItemResponse=singleItemResponse;exports.commonFields={id:{type:"string",format:"uuid",description:"Unique identifier"},createdAt:{type:"string",format:"date-time",description:"Timestamp when the record was created"},updatedAt:{type:"string",format:"date-time",description:"Timestamp when the record was last updated"},deletedAt:{type:"string",format:"date-time",nullable:!0,description:"Timestamp when the record was soft deleted"},status:{type:"boolean",description:"Whether the record is active"}};const baseModelSchema=e=>({type:"object",properties:{...exports.commonFields,...e}});exports.baseModelSchema=baseModelSchema;