"use strict";async function sendEmailWithProvider(e,t){try{switch(e){case"local":const e=process.env.APP_EMAIL_SENDER_NAME||constants_1.NEXT_PUBLIC_SITE_NAME||"Support",r=process.env.NEXT_PUBLIC_APP_EMAIL||"no-reply@localhost";t.from=`"${e}" <${r}>`;await emailWithLocalSMTP(t);break;case"nodemailer-service":const o=process.env.APP_EMAIL_SENDER_NAME||constants_1.NEXT_PUBLIC_SITE_NAME||"Support";t.from=`"${o}" <${constants_1.APP_NODEMAILER_SERVICE_SENDER}>`;await emailWithNodemailerService(constants_1.APP_NODEMAILER_SERVICE_SENDER,constants_1.APP_NODEMAILER_SERVICE_PASSWORD,constants_1.APP_NODEMAILER_SERVICE,t);break;case"nodemailer-smtp":const a=process.env.NEXT_PUBLIC_APP_EMAIL&&""!==process.env.NEXT_PUBLIC_APP_EMAIL?process.env.NEXT_PUBLIC_APP_EMAIL:constants_1.APP_NODEMAILER_SMTP_SENDER,i=process.env.APP_EMAIL_SENDER_NAME||constants_1.NEXT_PUBLIC_SITE_NAME||"Support";t.from=`"${i}" <${a}>`;const n="465"===constants_1.APP_NODEMAILER_SMTP_PORT||"ssl"===constants_1.APP_NODEMAILER_SMTP_ENCRYPTION;await emailWithNodemailerSmtp(constants_1.APP_NODEMAILER_SMTP_SENDER,constants_1.APP_NODEMAILER_SMTP_PASSWORD,constants_1.APP_NODEMAILER_SMTP_HOST,constants_1.APP_NODEMAILER_SMTP_PORT,n,t);break;case"nodemailer-sendgrid":const s=process.env.APP_EMAIL_SENDER_NAME||constants_1.NEXT_PUBLIC_SITE_NAME||"Support";t.from=`"${s}" <${constants_1.APP_SENDGRID_SENDER}>`;await emailWithSendgrid(t);break;default:throw(0,error_1.createError)({statusCode:500,message:"Unsupported email provider"})}}catch(e){console_1.logger.error("EMAIL","Failed to send email with provider",e);throw e}}async function emailWithLocalSMTP(e){try{const t={sendmail:!0,newline:"unix",path:constants_1.APP_SENDMAIL_PATH},r=process.env.APP_NODEMAILER_DKIM_PRIVATE_KEY||"",o=process.env.APP_NODEMAILER_DKIM_DOMAIN||"",a=process.env.APP_NODEMAILER_DKIM_SELECTOR||"default";r&&o&&a&&(t.dkim={privateKey:fs_1.default.readFileSync(r,"utf8"),domainName:o,keySelector:a});const i=nodemailer_1.default.createTransport(t),n={from:e.from,to:e.to,subject:e.subject,html:e.html,text:e.text};await i.sendMail(n)}catch(e){console_1.logger.error("EMAIL","Failed to send email with local SMTP",e);throw e}}async function emailWithSendgrid(e){const t=constants_1.APP_SENDGRID_API_KEY;if(!t)throw(0,error_1.createError)({statusCode:500,message:"Sendgrid Api key not found. Cannot send email. Aborting."});try{mail_1.default.setApiKey(t);const r={to:e.to,from:e.from,subject:e.subject,html:e.html?e.html:e.text};await mail_1.default.send(r)}catch(e){console_1.logger.error("EMAIL","Failed to send email with Sendgrid",e);throw e}}async function emailWithNodemailerService(e,t,r,o){const a={from:o.from,to:o.to,subject:o.subject,html:o.html};if(!r)throw(0,error_1.createError)({statusCode:500,message:"Email service not specified. Aborting email send."});if(!e)throw(0,error_1.createError)({statusCode:500,message:"Email user not specified. Aborting email send."});if(!t)throw(0,error_1.createError)({statusCode:500,message:"Email password not specified. Aborting email send."});try{const o=await nodemailer_1.default.createTransport({service:r,auth:{user:e,pass:t},tls:{rejectUnauthorized:!1}});await o.verify();await o.sendMail(a)}catch(e){console_1.logger.error("EMAIL","Failed to send email with nodemailer service",e);throw e}}async function emailWithNodemailerSmtp(e,t,r,o,a,i){const n={from:i.from,to:i.to,subject:i.subject,html:i.html};if(!r)throw(0,error_1.createError)({statusCode:500,message:"Email host not specified. Aborting email send."});if(!e)throw(0,error_1.createError)({statusCode:500,message:"Email user not specified. Aborting email send."});if(!t)throw(0,error_1.createError)({statusCode:500,message:"Email password not specified. Aborting email send."});try{const i=parseInt(o),s=465===i||a,l={host:r,port:i,pool:!0,secure:s,auth:{user:e,pass:t},tls:{rejectUnauthorized:!1,minVersion:"TLSv1.2"}};console_1.logger.debug("SMTP",`Connecting to ${r}:${i}, secure: ${s}`);const c=await nodemailer_1.default.createTransport(l);await c.verify();await c.sendMail(n)}catch(e){console_1.logger.error("SMTP","Error sending email",e);throw e}}function convertToInlineStyles(e){const t={"transaction-card":"background-color: #f9fafb; border: 1px solid #e5e7eb; border-radius: 12px; padding: 20px; margin: 24px 0;","transaction-row":"display: table; width: 100%; table-layout: fixed; padding: 12px 0; border-bottom: 1px solid #e5e7eb;","transaction-row-last":"display: table; width: 100%; table-layout: fixed; padding: 12px 0; border-bottom: none;","transaction-label":"display: table-cell; width: 40%; color: #6b7280; font-size: 14px; vertical-align: middle;","transaction-value":"display: table-cell; width: 60%; color: #111827; font-size: 14px; font-weight: 600; text-align: right; vertical-align: middle;","transaction-value positive":"display: table-cell; width: 60%; color: #059669; font-size: 14px; font-weight: 600; text-align: right; vertical-align: middle;","transaction-value negative":"display: table-cell; width: 60%; color: #dc2626; font-size: 14px; font-weight: 600; text-align: right; vertical-align: middle;","info-card":"background-color: #f9fafb; border: 1px solid #e5e7eb; border-radius: 12px; padding: 20px; margin: 24px 0;","info-card-title":"font-size: 16px; font-weight: 600; color: #111827; margin-bottom: 12px;","info-card-content":"color: #6b7280; font-size: 14px; line-height: 1.6;","highlight-box":"background: linear-gradient(135deg, #ede9fe 0%, #dbeafe 100%); border: 1px solid #c7d2fe; border-radius: 12px; padding: 24px; margin: 24px 0; text-align: center;","highlight-value":"font-size: 32px; font-weight: 700; color: #111827; margin-bottom: 4px; font-family: monospace; letter-spacing: 0.05em;","highlight-label":"color: #6b7280; font-size: 14px; font-weight: 500;",btn:"display: inline-block; padding: 14px 32px; background: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%); color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: 600; font-size: 15px; text-align: center;","btn-secondary":"display: inline-block; padding: 14px 32px; background-color: #f3f4f6; color: #374151; text-decoration: none; border-radius: 8px; font-weight: 600; font-size: 15px; text-align: center; border: 1px solid #e5e7eb;","btn-success":"display: inline-block; padding: 14px 32px; background: linear-gradient(135deg, #059669 0%, #10b981 100%); color: #ffffff; text-decoration: none; border-radius: 8px; font-weight: 600; font-size: 15px; text-align: center;",alert:"padding: 16px 20px; border-radius: 8px; margin: 20px 0; font-size: 14px; line-height: 1.6;","alert alert-info":"padding: 16px 20px; border-radius: 8px; margin: 20px 0; font-size: 14px; line-height: 1.6; background-color: #eff6ff; border: 1px solid #bfdbfe; color: #1e40af;","alert alert-success":"padding: 16px 20px; border-radius: 8px; margin: 20px 0; font-size: 14px; line-height: 1.6; background-color: #ecfdf5; border: 1px solid #a7f3d0; color: #047857;","alert alert-warning":"padding: 16px 20px; border-radius: 8px; margin: 20px 0; font-size: 14px; line-height: 1.6; background-color: #fffbeb; border: 1px solid #fde68a; color: #b45309;","alert alert-error":"padding: 16px 20px; border-radius: 8px; margin: 20px 0; font-size: 14px; line-height: 1.6; background-color: #fef2f2; border: 1px solid #fecaca; color: #dc2626;","code-block":"background-color: #1f2937; border-radius: 8px; padding: 16px 20px; font-family: monospace; font-size: 13px; color: #e5e7eb; margin: 16px 0; overflow-x: auto;","stats-grid":"display: table; width: 100%; margin: 24px 0; border-spacing: 12px 0; border-collapse: separate;","stat-card":"display: table-cell; background-color: #f9fafb; border: 1px solid #e5e7eb; border-radius: 8px; padding: 16px; text-align: center; width: 50%; vertical-align: top;","stat-value":"font-size: 24px; font-weight: 700; color: #6366f1; margin-bottom: 4px;","stat-label":"font-size: 12px; color: #6b7280; text-transform: uppercase; letter-spacing: 0.05em;",divider:"height: 1px; background-color: #e5e7eb; margin: 24px 0;","security-badge":"display: inline-block; padding: 8px 16px; background-color: #ecfdf5; border: 1px solid #a7f3d0; border-radius: 50px; color: #059669; font-size: 13px; font-weight: 500;"};let r=e;const o=Object.keys(t).sort((e,t)=>t.length-e.length);for(const e of o){const o=t[e],a=new RegExp(`class=["']${e.replace(/\s+/g,"\\s+")}["']`,"gi");r=r.replace(a,`style="${o}"`)}r=r.replace(/<h1(?![^>]*style)/gi,'<h1 style="color: #111827; font-size: 24px; font-weight: 700; margin: 0 0 16px 0; line-height: 1.3;"');r=r.replace(/<h2(?![^>]*style)/gi,'<h2 style="color: #111827; font-size: 20px; font-weight: 600; margin: 24px 0 12px 0; line-height: 1.3;"');r=r.replace(/<h3(?![^>]*style)/gi,'<h3 style="color: #374151; font-size: 16px; font-weight: 600; margin: 20px 0 8px 0; line-height: 1.3;"');r=r.replace(/<p(?![^>]*style)/gi,'<p style="color: #4b5563; font-size: 15px; line-height: 1.7; margin: 0 0 16px 0;"');r=r.replace(/(<div[^>]*style="[^"]*display:\s*table[^"]*border-bottom:\s*1px\s+solid\s+#e5e7eb[^"]*"[^>]*>[\s\S]*?<\/div>)\s*(<\/div>\s*(?:<div class="alert|<p|<\/td|$))/gi,(e,t,r)=>t.replace(/border-bottom:\s*1px\s+solid\s+#e5e7eb;?/gi,"border-bottom: none;")+r);return r}async function prepareEmailTemplate(e,t,r){const o=(0,emailTemplates_1.loadEmailTemplate)("generalTemplate");if(!o)throw(0,error_1.createError)({statusCode:500,message:"General email template not found"});const a=`${constants_1.NEXT_PUBLIC_SITE_URL}/img/logo/logo-text.webp`,i=constants_1.NEXT_PUBLIC_SITE_NAME||"Bicrypto",n=(null==r?void 0:r.locale)||"en",s=(null==r?void 0:r.unsubscribeToken)||"",l=s?`${constants_1.NEXT_PUBLIC_SITE_URL}/${n}/unsubscribe?token=${encodeURIComponent(s)}`:`${constants_1.NEXT_PUBLIC_SITE_URL}/${n}/unsubscribe`,c=convertToInlineStyles(e),d={"%SITE_URL%":constants_1.NEXT_PUBLIC_SITE_URL,"%SITE_NAME%":i,"%LOGO_URL%":a,"%HEADER%":t,"%MESSAGE%":c,"%SUBJECT%":t,"%FOOTER%":i,"%UNSUBSCRIBE_URL%":l};return Object.entries(d).reduce((e,[t,r])=>replaceAllOccurrences(e,t,r),o)}async function fetchAndProcessEmailTemplate(e,t){try{const r=await db_1.models.notificationTemplate.findOne({where:{name:t}});if(!r||!r.email||!r.emailBody)throw(0,error_1.createError)({statusCode:404,message:"Email template not found or email not enabled"});const o={...{URL:constants_1.NEXT_PUBLIC_SITE_URL},...e},a=replaceTemplateVariables(r.emailBody,o);return{processedTemplate:a,processedSubject:replaceTemplateVariables(r.subject,o),templateRecord:r}}catch(e){console_1.logger.error("EMAIL","Failed to fetch and process email template",e);throw e}}function replaceTemplateVariables(e,t){if("string"!=typeof e){console_1.logger.error("MAILER","Template is not a string");return""}return Object.entries(t).reduce((e,[t,r])=>{if(void 0===r){console_1.logger.debug("MAILER",`Variable ${t} is undefined`);return e}return e.replace(new RegExp(`%${t}%`,"g"),String(r))},e)}function replaceAllOccurrences(e,t,r){if(null==e){console_1.logger.error("MAILER","Input string is null or undefined");return""}const o=new RegExp(t,"g");return e.replace(o,r)}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.sendEmailWithProvider=sendEmailWithProvider;exports.emailWithSendgrid=emailWithSendgrid;exports.emailWithNodemailerService=emailWithNodemailerService;exports.emailWithNodemailerSmtp=emailWithNodemailerSmtp;exports.prepareEmailTemplate=prepareEmailTemplate;exports.fetchAndProcessEmailTemplate=fetchAndProcessEmailTemplate;exports.replaceTemplateVariables=replaceTemplateVariables;const mail_1=__importDefault(require("@sendgrid/mail")),fs_1=__importDefault(require("fs")),nodemailer_1=__importDefault(require("nodemailer")),constants_1=require("./constants"),error_1=require("./error"),db_1=require("@b/db"),emailTemplates_1=require("./emailTemplates"),console_1=require("@b/utils/console");