"use strict";function setupDefaultRoutes(e){["/","/api"].forEach(t=>{e.get(t,e=>e.writeHeader("Content-Type","text/html").end(exports.apiResponse))})}function setupProcessEventHandlers(){process.on("uncaughtException",e=>{const t=e.stack||`Uncaught Exception: ${e.message}`;console_1.logger.error("SYSTEM",t,e);process.exit(1)});process.on("unhandledRejection",(e,t)=>{const o=e instanceof Error?e.stack||e.message:JSON.stringify(e),n=e instanceof Error?e:new Error(o);console_1.logger.error("SYSTEM",`Unhandled Rejection at: ${t}, reason: ${o}`,n)});process.on("SIGINT",async()=>{console_1.logger.info("SYSTEM","Server is shutting down...");process.exit()});process.on("SIGTERM",async()=>{console_1.logger.info("SYSTEM","Server received stop signal, shutting down gracefully");process.exit()})}function compressResponse(e,t,o){const n=t.getHeader("accept-encoding")||"";let r="identity",s=Buffer.isBuffer(o)?o:Buffer.from(JSON.stringify(o));if(n.includes("gzip")){s=Buffer.from(zlib_1.default.gzipSync(s));r="gzip"}else if(n.includes("br")&&zlib_1.default.brotliCompressSync){s=Buffer.from(zlib_1.default.brotliCompressSync(s));r="br"}else if(n.includes("deflate")){s=Buffer.from(zlib_1.default.deflateSync(s));r="deflate"}"identity"!==r&&e.writeHeader("Content-Encoding",r);return s}function convertAndSortCounts(e){return Object.keys(e).sort().map(t=>({date:t,count:e[t]}))}async function delay(e){return new Promise(t=>setTimeout(t,e))}function slugify(e){return e.replace(/^\s+|\s+$/g,"").toLowerCase().replace(/[^a-z0-9 -]/g,"").replace(/\s+/g,"-").replace(/-+/g,"-")}function serveStaticFile(e,t,o,n){let r=!1;e.onAborted(()=>{r=!0;console_1.logger.debug("STATIC","Request was aborted")});try{const s="true"===process.env.DEBUG_STATIC_FILES;if(s){console_1.logger.debug("STATIC",`Static file request: ${o}`);console_1.logger.debug("STATIC",`Current working directory: ${process.cwd()}`);console_1.logger.debug("STATIC",`NODE_ENV: ${process.env.NODE_ENV}`)}let a,l;try{a=(0,validation_1.sanitizeUserPath)(o);s&&console_1.logger.debug("STATIC",`Sanitized path: ${a}`)}catch(t){console_1.logger.error("STATIC",`Path sanitization failed for ${o}: ${t.message}`);if(!r){e.writeStatus("403 Forbidden").end();n()}return!0}if(-1!==a.indexOf("..")||a.includes("\0")||a.includes("%00")){if(!r){e.writeStatus("403 Forbidden").end();n()}return!0}if(o.startsWith("/uploads/")){const e=process.cwd();if(e.endsWith("backend")||e.endsWith("backend/")){const t=a.startsWith("/")?a.substring(1):a;l=path_1.default.join(e,"..","frontend","public",t)}else{const t=path_1.default.join(e,"frontend","public"),o=path_1.default.join(e,"..","frontend","public"),n=path_1.default.join(e,"public");let r;r=fs_1.default.existsSync(t)?t:fs_1.default.existsSync(o)?o:fs_1.default.existsSync(n)?n:t;const s=a.startsWith("/")?a.substring(1):a;l=path_1.default.join(r,s)}}if(s){console_1.logger.debug("STATIC",`Resolved full path: ${l}`);console_1.logger.debug("STATIC",`File exists: ${fs_1.default.existsSync(l)}`);fs_1.default.existsSync(l)&&console_1.logger.debug("STATIC",`Is file: ${fs_1.default.lstatSync(l).isFile()}`)}if(!l){if(!r){e.writeStatus("404 Not Found").end();n()}return!0}if(fs_1.default.existsSync(l)&&fs_1.default.lstatSync(l).isFile()){if(o.startsWith("/uploads/")){const t=[".jpg",".jpeg",".png",".webp",".gif",".svg",".mp4",".webm",".mov",".pdf",".txt"],o=path_1.default.extname(l).toLowerCase();if(!t.includes(o)){if(!r){e.writeStatus("403 Forbidden").end();n()}return!0}}let s=fs_1.default.readFileSync(l);const a=(0,mime_1.getMime)(l),i=path_1.default.extname(l).toLowerCase();s=compressResponse(e,t,s);const c=`public, max-age=${31536e3}, immutable`;if(!r){e.writeHeader("Content-Type",a);e.writeHeader("Cache-Control",c);e.writeHeader("Connection","keep-alive");e.writeHeader("X-Content-Type-Options","nosniff");e.writeHeader("X-Frame-Options","DENY");if("development"===process.env.NODE_ENV)e.writeHeader("Access-Control-Allow-Origin","*");else{const t=process.env.NEXT_PUBLIC_SITE_URL;t&&e.writeHeader("Access-Control-Allow-Origin",t)}".svg"===i&&e.writeHeader("Content-Security-Policy","default-src 'none'; style-src 'unsafe-inline'");e.end(s);n()}return!0}s&&console_1.logger.debug("STATIC",`File not found: ${l}`);if(!r){e.writeStatus("404 Not Found").end();n()}return!0}catch(t){console_1.logger.error("STATIC","Error serving static file",t);if(!r){e.writeStatus("500 Internal Server Error").end();n()}return!0}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.statusOptions=exports.transactionTypeOptions=exports.cronLastRunTimes=exports.validAddonFolders=exports.getCommonExpiration=exports.getStatusMessage=exports.setCORSHeaders=exports.voidFunction=exports.handleArrayBuffer=exports.handleError=exports.errHandlerFn=exports.notFoundFn=exports.apiResponse=exports.notFoundResponse=exports.logCORSConfiguration=exports.allowedOrigins=exports.appSupport=exports.appName=void 0;exports.setupDefaultRoutes=setupDefaultRoutes;exports.setupProcessEventHandlers=setupProcessEventHandlers;exports.convertAndSortCounts=convertAndSortCounts;exports.delay=delay;exports.slugify=slugify;exports.serveStaticFile=serveStaticFile;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),zlib_1=__importDefault(require("zlib")),mime_1=require("./mime"),validation_1=require("./validation"),console_1=require("./console");exports.appName=process.env.NEXT_PUBLIC_SITE_NAME||"Platform";exports.appSupport=process.env.NEXT_PUBLIC_APP_EMAIL||"support@mashdiv.com";const getDevOrigins=()=>{const e=process.env.NEXT_PUBLIC_FRONTEND_PORT||3e3,t=process.env.NEXT_PUBLIC_BACKEND_PORT||4e3;return[`http://localhost:${e}`,`https://localhost:${e}`,`http://localhost:${t}`,`https://localhost:${t}`,"http://localhost:80","https://localhost:443","http://localhost:3000","https://localhost:3000","localhost:80","localhost:443","localhost:3000"]},getProdOrigins=()=>{const e=process.env.NEXT_PUBLIC_SITE_URL;if(!e)return[];const t=[e,e.replace("http://","https://"),e.replace("https://","http://")],o=e.replace("://www.","://"),n=e.replace("://","://www.");o!==e&&t.push(o,o.replace("http://","https://"),o.replace("https://","http://"));n===e||n.includes("://www.www.")||t.push(n,n.replace("http://","https://"),n.replace("https://","http://"));return[...new Set(t)]},isDev="development"===process.env.NODE_ENV;exports.allowedOrigins=[...isDev?getDevOrigins():[],...getProdOrigins()];const logCORSConfiguration=()=>{const e="development"===process.env.NODE_ENV;console_1.logger.debug("CORS",`${e?"Dev":"Prod"} mode, ${exports.allowedOrigins.length} origins configured`)};exports.logCORSConfiguration=logCORSConfiguration;exports.notFoundResponse='<!DOCTYPE html>\n<html lang="en">\n<head>\n  <meta charset="UTF-8">\n  <title>404 Not Found</title>\n  <style>\n    body {\n      font-family: Arial, sans-serif;\n      margin: 40px;\n    }\n  </style>\n</head>\n<body>\n  <h1>404 Not Found</h1>\n  <p>The resource you are looking for is not available.</p>\n</body>\n</html>';exports.apiResponse=`\n<!DOCTYPE html>\n<html lang="en">\n<head>\n  <meta charset="UTF-8">\n  <meta name="viewport" content="width=device-width, initial-scale=1.0">\n  <title>${exports.appName} - Backend Service</title>\n  <style>\n    body {\n      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;\n      margin: 20px;\n      background-color: #f4f4f4;\n      color: #333;\n    }\n    .container {\n      max-width: 800px;\n      margin: auto;\n      background: white;\n      padding: 20px;\n      border-radius: 8px;\n      box-shadow: 0 0 10px rgba(0,0,0,0.1);\n    }\n    h1 {\n      color: #005A9C;\n    }\n    a {\n      color: #007BFF;\n      text-decoration: none;\n    }\n    a:hover {\n      text-decoration: underline;\n    }\n    .status {\n      color: #28A745;\n    }\n    .footer {\n      margin-top: 20px;\n      text-align: center;\n      font-size: 0.9em;\n      color: #666;\n    }\n    @media (max-width: 600px) {\n      body {\n        margin: 10px;\n      }\n      .container {\n        margin: 10px;\n        padding: 15px;\n      }\n    }\n  </style>\n</head>\n<body>\n  <div class="container">\n    <h1>${exports.appName} Backend Service</h1>\n    <p>Status: <strong class="status">Live</strong></p>\n    <p>This is the backend service for <strong>${exports.appName}</strong>. All systems operational.</p>\n    <p>API Documentation: <a href="${process.env.NEXT_PUBLIC_SITE_URL||""}/api-docs">View Documentation</a></p>\n    <p>Raw OpenAPI Spec: <a href="/api/docs/swagger.json">swagger.json</a></p>\n    \x3c!-- Additional UI elements could be added here --\x3e\n    <div class="footer">\n      <p>Need help? <a href="mailto:${exports.appSupport}">Contact Support</a></p>\n    </div>\n  </div>\n</body>\n</html>\n`;const notFoundFn=e=>{e.status(404).end("Not Found")};exports.notFoundFn=notFoundFn;const errHandlerFn=(e,t)=>{t.status(500).end("Error")};exports.errHandlerFn=errHandlerFn;const handleError=(e,t,o)=>{e.status(t).end(o)};exports.handleError=handleError;const handleArrayBuffer=e=>e instanceof ArrayBuffer?(new TextDecoder).decode(e):e;exports.handleArrayBuffer=handleArrayBuffer;const voidFunction=()=>{};exports.voidFunction=voidFunction;const setCORSHeaders=(e,t)=>{if("development"===process.env.NODE_ENV){const o=t||"http://localhost:3000";e.writeHeader("Access-Control-Allow-Origin",o)}else t&&e.writeHeader("Access-Control-Allow-Origin",t);e.writeHeader("Access-Control-Allow-Methods","GET, POST, PUT, DELETE, PATCH, OPTIONS");e.writeHeader("Access-Control-Allow-Headers","Content-Type, Authorization, X-Requested-With, accessToken, refreshToken, sessionId, csrfToken, x-api-key, Cache-Control, Pragma, Accept, Accept-Language, Accept-Encoding, idempotency-key");e.writeHeader("Access-Control-Allow-Credentials","true");e.writeHeader("Access-Control-Max-Age","86400")};exports.setCORSHeaders=setCORSHeaders;const getStatusMessage=e=>({200:"OK",201:"Created",202:"Accepted",204:"No Content",206:"Partial Content",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",408:"Request Timeout",409:"Conflict",410:"Gone",411:"Length Required",413:"Payload Too Large",414:"URI Too Long",415:"Unsupported Media Type",416:"Range Not Satisfiable",417:"Expectation Failed",418:"I'm a teapot",422:"Unprocessable Entity",429:"Too Many Requests",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Gateway Timeout",505:"HTTP Version Not Supported"}[e]||"Unknown Status");exports.getStatusMessage=getStatusMessage;const getCommonExpiration=e=>{const t={accessToken:9e5,refreshToken:12096e5,sessionId:12096e5,csrfToken:864e5}[e];return t?new Date(Date.now()+t).toUTCString():void 0};exports.getCommonExpiration=getCommonExpiration;exports.validAddonFolders=[];exports.cronLastRunTimes={aiInvestments:0,forexInvestments:0,icoPhases:0,mailwizardCampaigns:0,staking:0,currencies:0,binaryOrders:0,spotCurrencies:0,investments:0,spotWalletsDeposit:0,spotWalletsWithdraw:0};exports.transactionTypeOptions=[{value:"DEPOSIT",label:"Deposit",color:"success"},{value:"WITHDRAW",label:"Withdraw",color:"danger"},{value:"OUTGOING_TRANSFER",label:"Outgoing Transfer",color:"warning"},{value:"INCOMING_TRANSFER",label:"Incoming Transfer",color:"info"},{value:"PAYMENT",label:"Payment",color:"primary"},{value:"REFUND",label:"Refund",color:"muted"},{value:"BINARY_ORDER",label:"Binary Order",color:"success"},{value:"EXCHANGE_ORDER",label:"Exchange Order",color:"warning"},{value:"INVESTMENT",label:"Investment",color:"info"},{value:"INVESTMENT_ROI",label:"Investment ROI",color:"primary"},{value:"AI_INVESTMENT",label:"AI Investment",color:"muted"},{value:"AI_INVESTMENT_ROI",label:"AI Investment ROI",color:"success"},{value:"INVOICE",label:"Invoice",color:"danger"},{value:"FOREX_DEPOSIT",label:"Forex Deposit",color:"warning"},{value:"FOREX_WITHDRAW",label:"Forex Withdraw",color:"info"},{value:"FOREX_INVESTMENT",label:"Forex Investment",color:"primary"},{value:"FOREX_INVESTMENT_ROI",label:"Forex Investment ROI",color:"muted"},{value:"ICO_CONTRIBUTION",label:"ICO Contribution",color:"success"},{value:"REFERRAL_REWARD",label:"Referral Reward",color:"warning"},{value:"STAKING",label:"Staking",color:"info"},{value:"STAKING_REWARD",label:"Staking Reward",color:"primary"},{value:"P2P_OFFER_TRANSFER",label:"P2P Offer Transfer",color:"muted"},{value:"P2P_TRADE",label:"P2P Trade",color:"danger"}];exports.statusOptions=[{value:"PENDING",label:"Pending",color:"warning"},{value:"COMPLETED",label:"Completed",color:"success"},{value:"FAILED",label:"Failed",color:"danger"},{value:"CANCELLED",label:"Cancelled",color:"muted"},{value:"REJECTED",label:"Rejected",color:"danger"},{value:"REFUNDED",label:"Refunded",color:"info"},{value:"FROZEN",label:"Frozen",color:"danger"},{value:"PROCESSING",label:"Processing",color:"warning"},{value:"EXPIRED",label:"Expired",color:"muted"}];