"use strict";function normalizeAmount(e){const t=parseFloat(e);return Number.isFinite(t)?Math.round(1e8*t)/1e8:0}function parseBalance(e){return null==e?0:normalizeAmount(e.toString())}function amountsEqual(e,t,a=1e-8){return Math.abs(normalizeAmount(e)-normalizeAmount(t))<a}function amountGte(e,t,a=1e-8){return normalizeAmount(e)>=normalizeAmount(t)-a}function generateRandomString(e){let t="";const a=CHARSET.length;for(let r=0;r<e;r++)t+=CHARSET.charAt(Math.floor(Math.random()*a));return t}function generateApiKey(e){return`${e}${generateRandomString(48)}`}function generatePaymentIntentId(){return`pi_${generateRandomString(24)}`}function generateRefundId(){return`re_${generateRandomString(24)}`}function generatePayoutId(){return`po_${generateRandomString(24)}`}function hashApiKey(e){return crypto_1.default.createHash("sha256").update(e).digest("hex")}function getLastFourChars(e){return e.slice(-4)}function signWebhookPayload(e,t){const a=Math.floor(Date.now()/1e3),r=`${a}.${JSON.stringify(e)}`;return{signature:`sha256=${crypto_1.default.createHmac("sha256",t).update(r).digest("hex")}`,timestamp:a}}function verifyWebhookSignature(e,t,a,r){const n=Math.floor(Date.now()/1e3),o=parseInt(e,10);if(Math.abs(n-o)>300)return!1;const s="sha256="+crypto_1.default.createHmac("sha256",r).update(`${e}.${t}`).digest("hex");try{return crypto_1.default.timingSafeEqual(Buffer.from(s),Buffer.from(a))}catch(e){return!1}}function calculateFees(e,t,a,r){let n=0;switch(t){case"PERCENTAGE":n=e*a/100;break;case"FIXED":n=r;break;case"BOTH":n=e*a/100+r}n=Math.round(1e8*n)/1e8;return{feeAmount:n,netAmount:Math.round(1e8*(e-n))/1e8}}async function authenticateGatewayApi(e,t){if(!e)throw(0,error_1.createError)({statusCode:401,message:"API key required"});const a=e.startsWith("sk_live_")||e.startsWith("sk_test_"),r=e.startsWith("pk_live_")||e.startsWith("pk_test_"),n=e.startsWith("sk_test_")||e.startsWith("pk_test_");if(!a&&!r)throw(0,error_1.createError)({statusCode:401,message:"Invalid API key format"});const o=hashApiKey(e),s=await db_1.models.gatewayApiKey.findOne({where:{keyHash:o,status:!0},include:[{model:db_1.models.gatewayMerchant,as:"merchant"}]});if(!s)throw(0,error_1.createError)({statusCode:401,message:"Invalid API key"});if(s.expiresAt&&new Date(s.expiresAt)<new Date)throw(0,error_1.createError)({statusCode:401,message:"API key expired"});if("ACTIVE"!==s.merchant.status)throw(0,error_1.createError)({statusCode:403,message:"Merchant account is not active"});if(a&&s.ipWhitelist&&Array.isArray(s.ipWhitelist)&&s.ipWhitelist.length>0){const e=(null==t?void 0:t.replace(/^::ffff:/,""))||"";if(!s.ipWhitelist.some(t=>{const a=t.replace(/^::ffff:/,"");return a===e||"*"===a||a.includes("/")&&isIpInCidr(e,a)}))throw(0,error_1.createError)({statusCode:403,message:"IP address not whitelisted for this API key"})}await s.update({lastUsedAt:new Date,lastUsedIp:t||null});return{merchant:s.merchant,apiKey:s,isTestMode:n,isSecretKey:a}}function isIpInCidr(e,t){try{const[a,r]=t.split("/"),n=~(2**(32-parseInt(r))-1),o=e=>{const t=e.split(".").map(Number);return t[0]<<24|t[1]<<16|t[2]<<8|t[3]};return(o(e)&n)===(o(a)&n)}catch(e){return!1}}function checkApiPermission(e,t){const a=e.permissions||[];if(!a.includes(t)&&!a.includes("*"))throw(0,error_1.createError)({statusCode:403,message:`Missing required permission: ${t}`})}async function getOrCreateMerchantBalance(e,t,a,r){const n=r?{transaction:r}:{};let o=await db_1.models.gatewayMerchantBalance.findOne({where:{merchantId:e,currency:t,walletType:a},...n});o||(o=await db_1.models.gatewayMerchantBalance.create({merchantId:e,currency:t,walletType:a,available:0,pending:0,reserved:0,totalReceived:0,totalRefunded:0,totalFees:0,totalPaidOut:0},n));return o}async function processMultiWalletRefund(e){var t,a;const{userId:r,merchantId:n,allocations:o,refundAmount:s,totalPaymentAmount:i,feeAmount:l,refundId:c,paymentId:u,description:d,transaction:y}=e,p=s/i,m=l/i,w=[];for(let e=0;e<o.length;e++){const s=o[e],i=s.amount*p,l=s.amount*m,g=i-l,f=await db_1.models.gatewayMerchantBalance.findOne({where:{merchantId:n,currency:s.currency,walletType:s.walletType},transaction:y,lock:y.LOCK.UPDATE});if(!f)throw(0,error_1.createError)({statusCode:400,message:`Merchant gateway balance not found for ${s.currency} (${s.walletType})`});const h=parseFloat((null===(t=f.pending)||void 0===t?void 0:t.toString())||"0");if(h<g)throw(0,error_1.createError)({statusCode:400,message:`Insufficient merchant gateway balance for refund in ${s.currency}. Available: ${h}, Required: ${g}`});await f.update({pending:h-g,totalRefunded:parseFloat((null===(a=f.totalRefunded)||void 0===a?void 0:a.toString())||"0")+i},{transaction:y});const A=(await wallet_1.walletCreationService.getOrCreateWallet(r,s.walletType,s.currency,y)).wallet,_=`gateway_refund_${c}_${s.currency}_${e}`,I=await wallet_1.walletService.credit({idempotencyKey:_,userId:r,walletId:A.id,walletType:s.walletType,currency:s.currency,amount:i,operationType:"REFUND",referenceId:`${c}_user_${s.currency}_${e}`,description:d||`Refund for payment ${u}`,metadata:{paymentId:u,refundId:c,refundAmount:i,feeReturned:l,equivalentInPaymentCurrency:s.equivalentInPaymentCurrency*p,isPartialRefund:o.length>1,allocationIndex:e},transaction:y}),b=await db_1.models.transaction.findByPk(I.transactionId,{transaction:y});w.push(b);l>0&&await returnGatewayFee({currency:s.currency,walletType:s.walletType,feeAmount:l,merchantId:n,refundId:c,transaction:y})}return{userTransaction:w[0]}}async function returnGatewayFee(e){const{currency:t,walletType:a,feeAmount:r,merchantId:n,refundId:o,transaction:s}=e,i=await db_1.models.role.findOne({where:{name:"Super Admin"}});if(!i)return;const l=await db_1.models.user.findOne({where:{roleId:i.id},order:[["createdAt","ASC"]]});if(!l)return;const c=(await wallet_1.walletCreationService.getOrCreateWallet(l.id,a,t,s)).wallet;if(parseFloat(String(c.balance))>=r){const e=`gateway_fee_return_${o}_${t}`;await wallet_1.walletService.debit({idempotencyKey:e,userId:l.id,walletId:c.id,walletType:a,currency:t,amount:r,operationType:"OUTGOING_TRANSFER",referenceId:`${o}_fee_return_${t}`,description:"Gateway fee returned for refund",metadata:{refundId:o,merchantId:n,type:"GATEWAY_FEE_RETURN"},transaction:s})}}async function processGatewayPayout(e){var t,a,r;const{merchantUserId:n,merchantId:o,currency:s,walletType:i,amount:l,payoutId:c,transaction:u}=e,d=await db_1.models.gatewayMerchantBalance.findOne({where:{merchantId:o,currency:s,walletType:i},transaction:u,lock:u.LOCK.UPDATE});if(!d)throw(0,error_1.createError)({statusCode:400,message:`Merchant gateway balance not found for ${s} (${i})`});const y=parseFloat((null===(t=d.pending)||void 0===t?void 0:t.toString())||"0");if(y<l)throw(0,error_1.createError)({statusCode:400,message:`Insufficient gateway balance for payout. Available: ${y}, Requested: ${l}`});const p=parseFloat((null===(a=d.available)||void 0===a?void 0:a.toString())||"0");await d.update({pending:y-l,available:p+l,totalPaidOut:parseFloat((null===(r=d.totalPaidOut)||void 0===r?void 0:r.toString())||"0")+l},{transaction:u});const m=(await wallet_1.walletCreationService.getOrCreateWallet(n,i,s,u)).wallet,w=`gateway_payout_${c}`;await wallet_1.walletService.credit({idempotencyKey:w,userId:n,walletId:m.id,walletType:i,currency:s,amount:l,operationType:"INCOMING_TRANSFER",referenceId:c,description:"Gateway payout released",metadata:{payoutId:c,merchantId:o,source:"GATEWAY_PAYOUT"},transaction:u})}async function collectGatewayFee(e){const{currency:t,walletType:a,feeAmount:r,merchantId:n,paymentId:o,transaction:s}=e,i=await db_1.models.role.findOne({where:{name:"Super Admin"}});if(!i){console_1.logger.warn("GATEWAY","No super admin role found for fee collection");return}const l=await db_1.models.user.findOne({where:{roleId:i.id},order:[["createdAt","ASC"]]});if(!l){console_1.logger.warn("GATEWAY","No super admin found for fee collection");return}const c=(await wallet_1.walletCreationService.getOrCreateWallet(l.id,a,t,s)).wallet,u=`gateway_fee_${o}`,d=await wallet_1.walletService.credit({idempotencyKey:u,userId:l.id,walletId:c.id,walletType:a,currency:t,amount:r,operationType:"FEE",referenceId:`${o}_fee`,description:"Gateway payment fee",metadata:{paymentId:o,merchantId:n,type:"GATEWAY_FEE"},transaction:s});await db_1.models.adminProfit.create({transactionId:d.transactionId,type:"GATEWAY_PAYMENT",amount:r,currency:t,description:`Gateway payment fee from merchant ${n}`},{transaction:s})}async function updateMerchantBalanceForPayment(e){return updateMerchantBalanceTracking({...e,type:"PAYMENT"})}async function updateMerchantBalanceTracking(e){const{merchantId:t,currency:a,walletType:r,amount:n,feeAmount:o,type:s,transaction:i}=e;let l=await db_1.models.gatewayMerchantBalance.findOne({where:{merchantId:t,currency:a,walletType:r},transaction:i});l||(l=await db_1.models.gatewayMerchantBalance.create({merchantId:t,currency:a,walletType:r,available:0,pending:0,reserved:0,totalReceived:0,totalRefunded:0,totalFees:0,totalPaidOut:0},{transaction:i}));const c=n-o;if("PAYMENT"===s)await l.update({pending:parseFloat(l.pending.toString())+c,totalReceived:parseFloat(l.totalReceived.toString())+n,totalFees:parseFloat(l.totalFees.toString())+o},{transaction:i});else if("REFUND"===s){const e=parseFloat(l.pending.toString()),t=parseFloat(l.available.toString());let a=Math.min(e,c),r=c-a;await l.update({pending:e-a,available:t-r,totalRefunded:parseFloat(l.totalRefunded.toString())+n},{transaction:i})}}async function sendWebhook(e,t,a,r,n,o,s){const{signature:i}=signWebhookPayload(o,s),l=await db_1.models.gatewayWebhook.create({merchantId:e,paymentId:t,refundId:a,eventType:r,url:n,payload:o,signature:i,status:"PENDING",attempts:0,maxAttempts:5});await attemptWebhookDelivery(l)}async function attemptWebhookDelivery(e){var t;const a=Date.now();try{const{signature:r,timestamp:n}=signWebhookPayload(e.payload,(null===(t=e.merchant)||void 0===t?void 0:t.webhookSecret)||""),o=await fetch(e.url,{method:"POST",headers:{"Content-Type":"application/json","X-Gateway-Signature":r,"X-Gateway-Timestamp":n.toString(),"X-Gateway-Event":e.eventType,"User-Agent":"PaymentGateway-Webhook/1.0"},body:JSON.stringify(e.payload),signal:AbortSignal.timeout(3e4)}),s=Date.now()-a,i=await o.text().catch(()=>"");await e.update({attempts:e.attempts+1,lastAttemptAt:new Date,responseStatus:o.status,responseBody:i.substring(0,1e3),responseTime:s,status:o.ok?"SENT":"RETRYING",nextRetryAt:o.ok?null:new Date(Date.now()+getRetryDelay(e.attempts+1))});!o.ok&&e.attempts+1>=e.maxAttempts&&await e.update({status:"FAILED"})}catch(t){const r=Date.now()-a;await e.update({attempts:e.attempts+1,lastAttemptAt:new Date,responseTime:r,errorMessage:t.message,status:e.attempts+1>=e.maxAttempts?"FAILED":"RETRYING",nextRetryAt:e.attempts+1>=e.maxAttempts?null:new Date(Date.now()+getRetryDelay(e.attempts+1))})}}function getRetryDelay(e){const t=[6e4,3e5,18e5,72e5,864e5];return t[Math.min(e-1,t.length-1)]}function generateCheckoutUrl(e){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}/${process.env.APP_DEFAULT_LOCALE||"en"}/gateway/checkout/${e}`}function validateAmount(e){const t=parseFloat(e);if(isNaN(t)||t<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be a positive number"});return t}function validateCurrency(e,t){if(!t.includes(e.toUpperCase()))throw(0,error_1.createError)({statusCode:400,message:`Currency ${e} is not supported by this merchant`})}function validateWalletType(e,t){if(!t.includes(e))throw(0,error_1.createError)({statusCode:400,message:`Wallet type ${e} is not supported by this merchant`})}function validateUrl(e,t){try{new URL(e)}catch(e){throw(0,error_1.createError)({statusCode:400,message:`${t} must be a valid URL`})}}async function getGatewaySettings(){const e=await db_1.models.settings.findAll({where:{key:GATEWAY_SETTINGS_KEYS}}),t={};for(const a of e){let e=a.value;if(a.value)try{e=JSON.parse(a.value)}catch(e){}"true"===e&&(e=!0);"false"===e&&(e=!1);"string"!=typeof e||isNaN(Number(e))||(e=Number(e));t[a.key]=e}return{...defaultGatewaySettings,...t}}async function validatePaymentAgainstSettings(e,t,a){const r=await getGatewaySettings();if(!r.gatewayEnabled)throw(0,error_1.createError)({statusCode:400,message:"Payment gateway is currently disabled"});if(e<r.gatewayMinPaymentAmount)throw(0,error_1.createError)({statusCode:400,message:`Minimum payment amount is $${r.gatewayMinPaymentAmount} USD`});if(e>r.gatewayMaxPaymentAmount)throw(0,error_1.createError)({statusCode:400,message:`Maximum payment amount is $${r.gatewayMaxPaymentAmount} USD`});const n=(r.gatewayAllowedWalletTypes||{})[a];if(!n||!n.enabled)throw(0,error_1.createError)({statusCode:400,message:`Wallet type ${a} is not enabled for payments`});if(!n.currencies||!n.currencies.includes(t))throw(0,error_1.createError)({statusCode:400,message:`Currency ${t} is not enabled for ${a} wallet payments`})}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.normalizeAmount=normalizeAmount;exports.parseBalance=parseBalance;exports.amountsEqual=amountsEqual;exports.amountGte=amountGte;exports.generateRandomString=generateRandomString;exports.generateApiKey=generateApiKey;exports.generatePaymentIntentId=generatePaymentIntentId;exports.generateRefundId=generateRefundId;exports.generatePayoutId=generatePayoutId;exports.hashApiKey=hashApiKey;exports.getLastFourChars=getLastFourChars;exports.signWebhookPayload=signWebhookPayload;exports.verifyWebhookSignature=verifyWebhookSignature;exports.calculateFees=calculateFees;exports.authenticateGatewayApi=authenticateGatewayApi;exports.checkApiPermission=checkApiPermission;exports.getOrCreateMerchantBalance=getOrCreateMerchantBalance;exports.processMultiWalletRefund=processMultiWalletRefund;exports.processGatewayPayout=processGatewayPayout;exports.collectGatewayFee=collectGatewayFee;exports.updateMerchantBalanceForPayment=updateMerchantBalanceForPayment;exports.sendWebhook=sendWebhook;exports.attemptWebhookDelivery=attemptWebhookDelivery;exports.generateCheckoutUrl=generateCheckoutUrl;exports.validateAmount=validateAmount;exports.validateCurrency=validateCurrency;exports.validateWalletType=validateWalletType;exports.validateUrl=validateUrl;exports.getGatewaySettings=getGatewaySettings;exports.validatePaymentAgainstSettings=validatePaymentAgainstSettings;const crypto_1=__importDefault(require("crypto")),db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet"),CHARSET="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",GATEWAY_SETTINGS_KEYS=["gatewayEnabled","gatewayTestMode","gatewayFeePercentage","gatewayFeeFixed","gatewayMinPaymentAmount","gatewayMaxPaymentAmount","gatewayDailyLimit","gatewayMonthlyLimit","gatewayMinPayoutAmount","gatewayPayoutSchedule","gatewayAllowedWalletTypes","gatewayRequireKyc","gatewayAutoApproveVerified","gatewayPaymentExpirationMinutes","gatewayWebhookRetryAttempts","gatewayWebhookRetryDelaySeconds"],defaultGatewaySettings={gatewayEnabled:!0,gatewayTestMode:!1,gatewayFeePercentage:2.9,gatewayFeeFixed:.3,gatewayMinPaymentAmount:1,gatewayMaxPaymentAmount:1e4,gatewayDailyLimit:5e4,gatewayMonthlyLimit:5e5,gatewayMinPayoutAmount:50,gatewayPayoutSchedule:"DAILY",gatewayAllowedWalletTypes:{},gatewayRequireKyc:!1,gatewayAutoApproveVerified:!1,gatewayPaymentExpirationMinutes:30,gatewayWebhookRetryAttempts:3,gatewayWebhookRetryDelaySeconds:60};