"use strict";function createProxyAgent(e){try{const t=new URL(e).protocol.toLowerCase();if("socks4:"===t||"socks5:"===t||"socks:"===t)return new socks_proxy_agent_1.SocksProxyAgent(e);if("http:"===t||"https:"===t)return new https_proxy_agent_1.HttpsProxyAgent(e);console_1.logger.warn("EXCHANGE",`Unknown proxy protocol: ${t}, using HTTPS proxy agent`);return new https_proxy_agent_1.HttpsProxyAgent(e)}catch(t){console_1.logger.error("EXCHANGE",`Invalid proxy URL: ${e}`,t);return null}}function mapChainNameToChainId(e){return{BEP20:"bsc",BEP2:"bnb",ERC20:"eth",TRC20:"trx","KAVA EVM CO-CHAIN":"kavaevm","LIGHTNING NETWORK":"lightning","BTC-SEGWIT":"btc","ASSET HUB(POLKADOT)":"polkadot"}[e]||e}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,i,n){void 0===n&&(n=i);var a=Object.getOwnPropertyDescriptor(t,i);a&&!("get"in a?!t.__esModule:a.writable||a.configurable)||(a={enumerable:!0,get:function(){return t[i]}});Object.defineProperty(e,n,a)}:function(e,t,i,n){void 0===n&&(n=i);e[n]=t[i]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var i={};if(null!=t)for(var n=e(t),a=0;a<n.length;a++)"default"!==n[a]&&__createBinding(i,t,n[a]);__setModuleDefault(i,t);return i}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.mapChainNameToChainId=mapChainNameToChainId;const ccxt=__importStar(require("ccxt")),https_1=require("https"),https_proxy_agent_1=require("https-proxy-agent"),socks_proxy_agent_1=require("socks-proxy-agent"),system_1=require("./system"),db_1=require("@b/db"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),utils_1=require("@b/api/exchange/utils"),httpsAgentIPv4=new https_1.Agent({family:4,keepAlive:!0,timeout:3e4});class ExchangeManager{constructor(){this.exchangeCache=new Map;this.initializationPromises=new Map;this.provider=null;this.exchange=null;this.exchangeProvider=null;this.lastAttemptTime=null;this.attemptCount=0;this.isInitializing=!1;this.initializationQueue=[]}async fetchActiveProvider(){try{const e=await db_1.models.exchange.findOne({where:{status:!0}});return e?{name:e.name,proxyUrl:e.proxyUrl||void 0}:null}catch(e){console_1.logger.error("EXCHANGE","Failed to fetch active provider",e);return null}}async fetchProviderProxyUrl(e){try{const t=await db_1.models.exchange.findOne({where:{name:e}});return(null==t?void 0:t.proxyUrl)||null}catch(e){console_1.logger.error("EXCHANGE","Failed to fetch provider proxy URL",e);return null}}async initializeExchange(e,t=3,i){var n,a,r,l,s,o,c,u,d,h,g,v,p,m,f,x;null===(n=null==i?void 0:i.step)||void 0===n||n.call(i,`Checking ban status for ${e}`);if(await(0,utils_1.handleBanStatus)(await(0,utils_1.loadBanStatus)()))return null;if(this.exchangeCache.has(e)){null===(a=null==i?void 0:i.step)||void 0===a||a.call(i,`Using cached exchange instance for ${e}`);return this.exchangeCache.get(e)}const y=Date.now();if(this.attemptCount>=3&&this.lastAttemptTime&&y-this.lastAttemptTime<18e5){null===(r=null==i?void 0:i.step)||void 0===r||r.call(i,`Rate limit reached for ${e}, waiting...`);return null}null===(l=null==i?void 0:i.step)||void 0===l||l.call(i,`Loading API credentials for ${e}`);const w=process.env[`APP_${e.toUpperCase()}_API_KEY`],_=process.env[`APP_${e.toUpperCase()}_API_SECRET`],E=process.env[`APP_${e.toUpperCase()}_API_PASSPHRASE`];if(!w||!_||""===w||""===_){console_1.logger.error("EXCHANGE",`API credentials for ${e} are missing.`,new Error(`API credentials for ${e} are missing.`));this.attemptCount+=1;this.lastAttemptTime=y;return null}const P=await this.fetchProviderProxyUrl(e),A=P?createProxyAgent(P):httpsAgentIPv4;if(P){null===(s=null==i?void 0:i.step)||void 0===s||s.call(i,`Using proxy for ${e}: ${P.replace(/\/\/.*@/,"//***@")}`);console_1.logger.info("EXCHANGE",`Using proxy for ${e}`)}try{null===(o=null==i?void 0:i.step)||void 0===o||o.call(i,`Creating exchange instance for ${e}`);let n=new ccxt.pro[e]({apiKey:w,secret:_,password:E,agent:A,timeout:3e4,enableRateLimit:!0,options:{adjustForTimeDifference:!0,recvWindow:6e4}});null===(c=null==i?void 0:i.step)||void 0===c||c.call(i,`Validating credentials for ${e}`);if(!await n.checkRequiredCredentials()){console_1.logger.error("EXCHANGE",`API credentials for ${e} are invalid.`,new Error(`API credentials for ${e} are invalid.`));await n.close();n=new ccxt.pro[e]({agent:A,timeout:3e4,enableRateLimit:!0})}await this.syncExchangeTime(n,i);try{null===(u=null==i?void 0:i.step)||void 0===u||u.call(i,`Loading markets for ${e}`);await n.loadMarkets()}catch(a){if(this.isRateLimitError(a)){null===(d=null==i?void 0:i.step)||void 0===d||d.call(i,`Rate limit error detected for ${e}, retrying...`);await this.handleRateLimitError(e,i);return this.initializeExchange(e,t,i)}if(this.isTimestampError(a)&&t>0){null===(h=null==i?void 0:i.step)||void 0===h||h.call(i,`Timestamp error detected for ${e}, creating fresh instance with time sync...`);console_1.logger.info("EXCHANGE",`Timestamp error for ${e}, recreating exchange with fresh time sync (this is expected and being handled)`);try{await n.close()}catch(e){}await(0,system_1.sleep)(1e3);const a=new ccxt.pro[e]({apiKey:w,secret:_,password:E,agent:A,timeout:3e4,enableRateLimit:!0,options:{adjustForTimeDifference:!0,recvWindow:6e4}});if(!await this.syncExchangeTime(a,i)){null===(g=null==i?void 0:i.step)||void 0===g||g.call(i,"Time sync failed, trying manual offset adjustment...");a.timeDifference=-1e3}try{null===(v=null==i?void 0:i.step)||void 0===v||v.call(i,"Retrying loadMarkets with fresh exchange instance...");await a.loadMarkets();this.exchangeCache.set(e,a);this.attemptCount=0;this.lastAttemptTime=null;null===(p=null==i?void 0:i.step)||void 0===p||p.call(i,`Exchange ${e} initialized successfully after time sync retry`);return a}catch(n){try{await a.close()}catch(e){}if(t>1){null===(m=null==i?void 0:i.step)||void 0===m||m.call(i,`Retry failed, attempting again (${t-1} retries left)...`);await(0,system_1.sleep)(2e3);return this.initializeExchange(e,t-1,i)}throw n}}else{console_1.logger.error("EXCHANGE",`Failed to load markets: ${a.message}`,new Error(`Failed to load markets: ${a.message}`));await n.close();n=new ccxt.pro[e]({agent:A,timeout:3e4,enableRateLimit:!0})}}this.exchangeCache.set(e,n);this.attemptCount=0;this.lastAttemptTime=null;null===(f=null==i?void 0:i.step)||void 0===f||f.call(i,`Exchange ${e} initialized successfully`);return n}catch(n){console_1.logger.error("EXCHANGE","Failed to initialize exchange",n);this.attemptCount+=1;this.lastAttemptTime=y;if(t>0&&(this.attemptCount<3||y-this.lastAttemptTime>=18e5)){null===(x=null==i?void 0:i.step)||void 0===x||x.call(i,`Retrying exchange initialization for ${e} (${t} retries left)`);await(0,system_1.sleep)(5e3);return this.initializeExchange(e,t-1,i)}return null}}isRateLimitError(e){return e instanceof ccxt.RateLimitExceeded||-1003===e.code}isTimestampError(e){var t;const i=e.code,n=(null===(t=e.message)||void 0===t?void 0:t.toLowerCase())||"";return-1021===i||"-1021"===i||e instanceof ccxt.InvalidNonce||"InvalidNonce"===e.name||n.includes("timestamp")||n.includes("recvwindow")||n.includes("ahead of the server")||n.includes("behind the server")}async syncExchangeTime(e,t){var i,n,a,r;try{null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,"Synchronizing exchange server time...");const r=await e.fetchTime(),l=r-Date.now();e.options=e.options||{};e.options.adjustForTimeDifference=!0;e.options.recvWindow=6e4;e.options.timeDifference=l;e.timeDifference=l;if(Math.abs(l)>5e3){null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,`Significant time offset detected: ${l}ms, adjusting...`);console_1.logger.warn("EXCHANGE",`Significant time offset with server: ${l}ms. Consider syncing your system clock.`)}null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Time synchronized. Offset: ${l}ms`);console_1.logger.debug("EXCHANGE",`Time synchronized with server. Offset: ${l}ms`);return!0}catch(e){null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,"Failed to sync time, continuing anyway");console_1.logger.warn("EXCHANGE","Failed to sync exchange time",e);return!1}}async handleRateLimitError(e,t){var i;null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,`Rate limit exceeded for ${e}, applying 1-minute ban`);const n=Date.now()+6e4;await(0,utils_1.saveBanStatus)(n);await(0,system_1.sleep)(6e4)}async startExchange(e){var t,i,n,a,r,l,s,o,c;null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Starting exchange initialization");if(await(0,utils_1.handleBanStatus)(await(0,utils_1.loadBanStatus)())){null===(i=null==e?void 0:e.step)||void 0===i||i.call(e,"Exchange is currently banned");return null}if(this.exchange){null===(n=null==e?void 0:e.step)||void 0===n||n.call(e,"Using existing exchange instance");return this.exchange}if(this.isInitializing){null===(a=null==e?void 0:e.step)||void 0===a||a.call(e,"Exchange initialization already in progress, queuing request");return new Promise((e,t)=>{this.initializationQueue.push({resolve:e,reject:t})})}this.isInitializing=!0;try{null===(r=null==e?void 0:e.step)||void 0===r||r.call(e,"Fetching active exchange provider");if(!this.provider){const e=await this.fetchActiveProvider();this.provider=(null==e?void 0:e.name)||null}if(!this.provider){null===(l=null==e?void 0:e.step)||void 0===l||l.call(e,"No active exchange provider found");this.resolveQueue(null);return null}null===(s=null==e?void 0:e.step)||void 0===s||s.call(e,`Active provider: ${this.provider}`);if(this.exchangeCache.has(this.provider)){null===(o=null==e?void 0:e.step)||void 0===o||o.call(e,`Using cached exchange for ${this.provider}`);this.exchange=this.exchangeCache.get(this.provider);this.resolveQueue(this.exchange);return this.exchange}null===(c=null==e?void 0:e.step)||void 0===c||c.call(e,`Initializing exchange: ${this.provider}`);this.exchange=await this.initializeExchange(this.provider,3,e);this.resolveQueue(this.exchange);return this.exchange}catch(e){this.rejectQueue(e);throw e}finally{this.isInitializing=!1}}resolveQueue(e){for(;this.initializationQueue.length>0;){const{resolve:t}=this.initializationQueue.shift();t(e)}}rejectQueue(e){for(;this.initializationQueue.length>0;){const{reject:t}=this.initializationQueue.shift();t(e)}}async startExchangeProvider(e,t){var i,n,a,r;null===(i=null==t?void 0:t.step)||void 0===i||i.call(t,`Starting exchange provider: ${e}`);if(await(0,utils_1.handleBanStatus)(await(0,utils_1.loadBanStatus)())){null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,"Exchange is currently banned");return null}if(!e)throw(0,error_1.createError)({statusCode:400,message:"Provider is required to start exchange provider."});this.exchangeCache.has(e)?null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,`Using cached exchange provider: ${e}`):null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,`Initializing exchange provider: ${e}`);this.exchangeProvider=this.exchangeCache.get(e)||await this.initializeExchange(e,3,t);return this.exchangeProvider}removeExchange(e){if(!e)throw(0,error_1.createError)({statusCode:400,message:"Provider is required to remove exchange."});this.exchangeCache.delete(e);if(this.provider===e){this.exchange=null;this.provider=null}}async getProvider(){if(!this.provider){const e=await this.fetchActiveProvider();this.provider=(null==e?void 0:e.name)||null}return this.provider}async testExchangeCredentials(e,t,i=0){var n,a,r,l,s,o,c,u,d,h,g,v,p,m,f,x,y,w,_;null===(n=null==t?void 0:t.step)||void 0===n||n.call(t,`Testing exchange credentials for ${e}`);if(await(0,utils_1.handleBanStatus)(await(0,utils_1.loadBanStatus)())){null===(a=null==t?void 0:t.step)||void 0===a||a.call(t,"Exchange is currently banned");return{status:!1,message:"Service temporarily unavailable. Please try again later."}}let E=null;try{null===(r=null==t?void 0:t.step)||void 0===r||r.call(t,`Loading API credentials for ${e}`);const i=process.env[`APP_${e.toUpperCase()}_API_KEY`],n=process.env[`APP_${e.toUpperCase()}_API_SECRET`],a=process.env[`APP_${e.toUpperCase()}_API_PASSPHRASE`];if(!i||!n||""===i||""===n){null===(l=null==t?void 0:t.step)||void 0===l||l.call(t,"API credentials are missing");return{status:!1,message:"API credentials are missing from environment variables"}}const v=await this.fetchProviderProxyUrl(e),p=v?createProxyAgent(v):httpsAgentIPv4;v&&(null===(s=null==t?void 0:t.step)||void 0===s||s.call(t,`Using proxy for ${e}: ${v.replace(/\/\/.*@/,"//***@")}`));null===(o=null==t?void 0:t.step)||void 0===o||o.call(t,`Creating test exchange instance for ${e}`);E=new ccxt.pro[e]({apiKey:i,secret:n,password:a,agent:p,timeout:3e4,enableRateLimit:!0,options:{adjustForTimeDifference:!0,recvWindow:6e4}});await this.syncExchangeTime(E,t);null===(c=null==t?void 0:t.step)||void 0===c||c.call(t,`Loading markets for ${e}`);await E.loadMarkets();null===(u=null==t?void 0:t.step)||void 0===u||u.call(t,`Fetching balance to verify credentials for ${e}`);const m=await E.fetchBalance();null===(d=null==t?void 0:t.step)||void 0===d||d.call(t,`Closing test connection for ${e}`);await E.close();if(m&&"object"==typeof m){null===(h=null==t?void 0:t.step)||void 0===h||h.call(t,`Credentials verified successfully for ${e}`);return{status:!0,message:"API credentials are valid and connection successful"}}null===(g=null==t?void 0:t.step)||void 0===g||g.call(t,`Failed to verify credentials for ${e}`);return{status:!1,message:"Failed to fetch balance with the provided credentials"}}catch(n){if(E)try{await E.close()}catch(e){}if(this.isTimestampError(n)&&i<2){null===(v=null==t?void 0:t.step)||void 0===v||v.call(t,`Timestamp error detected, retrying with time sync (attempt ${i+1}/2)...`);console_1.logger.info("EXCHANGE",`Timestamp error for ${e}, retrying with time sync (attempt ${i+1}/2)`);await(0,system_1.sleep)(1e3);return this.testExchangeCredentials(e,t,i+1)}console_1.logger.error("EXCHANGE","Failed to test exchange credentials",n);if("AuthenticationError"===n.name){null===(p=null==t?void 0:t.step)||void 0===p||p.call(t,`Authentication error for ${e}`);return{status:!1,message:"Invalid API credentials. Please check your API key and secret."}}if("NetworkError"===n.name||"ENOTFOUND"===n.code||"EAI_AGAIN"===n.code){null===(m=null==t?void 0:t.step)||void 0===m||m.call(t,`Network error for ${e}`);return{status:!1,message:"Network error. Please check your internet connection and try again."}}if("ExchangeNotAvailable"===n.name){null===(f=null==t?void 0:t.step)||void 0===f||f.call(t,`Exchange not available: ${e}`);const i=n.message||"";return i.includes("451")||i.includes("restricted location")||i.includes("Eligibility")?{status:!1,message:"Access denied: Your server's location is blocked by this exchange. Please configure a proxy in the Settings tab to connect through an allowed region."}:{status:!1,message:"Exchange service is temporarily unavailable. Please try again later."}}if("RateLimitExceeded"===n.name){null===(x=null==t?void 0:t.step)||void 0===x||x.call(t,`Rate limit exceeded for ${e}`);return{status:!1,message:"Rate limit exceeded. Please wait a moment and try again."}}if("PermissionDenied"===n.name){null===(y=null==t?void 0:t.step)||void 0===y||y.call(t,`Permission denied for ${e}`);return{status:!1,message:"Insufficient API permissions. Please check your API key permissions."}}if(this.isTimestampError(n)){null===(w=null==t?void 0:t.step)||void 0===w||w.call(t,`Timestamp synchronization failed for ${e}`);return{status:!1,message:"Server time synchronization failed. Please ensure your system clock is accurate and try again."}}null===(_=null==t?void 0:t.step)||void 0===_||_.call(t,`Connection failed for ${e}: ${n.message}`);return{status:!1,message:`Connection failed: ${n.message||"Unknown error occurred"}`}}}async stopExchange(){if(this.exchange){await this.exchange.close();this.exchange=null}}}ExchangeManager.instance=new ExchangeManager;exports.default=ExchangeManager.instance;