"use strict";var __importDefault=this&&this.__importDefault||function(s){return s&&s.__esModule?s:{default:s}};Object.defineProperty(exports,"__esModule",{value:!0});exports.liveConsole=void 0;const cli_spinners_1=__importDefault(require("cli-spinners")),colors_1=require("./colors"),log_queue_1=require("./log-queue"),SPINNERS={dots:cli_spinners_1.default.dots,dots2:cli_spinners_1.default.dots2,dots3:cli_spinners_1.default.dots3,dots12:cli_spinners_1.default.dots12,line:cli_spinners_1.default.line,arc:cli_spinners_1.default.arc,bouncingBar:cli_spinners_1.default.bouncingBar,bouncingBall:cli_spinners_1.default.bouncingBall,pulse:cli_spinners_1.default.moon,aesthetic:cli_spinners_1.default.aesthetic},PROGRESS_CHARS={filled:"█",empty:"░",head:"▓"};class LiveConsole{constructor(){this.tasks=new Map;this.renderInterval=null;this.spinner=SPINNERS.dots12;this.frameCount=0;this.moduleAliases=new Map;this.activeModuleTasks=new Map;this.isEnabled=!0===process.stdout.isTTY}get enabled(){return this.isEnabled}registerAlias(s,o){this.moduleAliases.set(s.toUpperCase(),o.toUpperCase())}unregisterAlias(s){this.moduleAliases.delete(s.toUpperCase())}hasActiveTask(s){const o=s.toUpperCase();if(this.activeModuleTasks.has(o))return!0;const e=this.moduleAliases.get(o);return!(!e||!this.activeModuleTasks.has(e))}addStepToTask(s,o,e="info"){const r=s.toUpperCase();let t=this.activeModuleTasks.get(r);if(!t){const s=this.moduleAliases.get(r);s&&(t=this.activeModuleTasks.get(s))}if(!t)return!1;const l=this.tasks.get(t);if(!l)return!1;l.steps.push({message:o,status:e,time:Date.now()});l.message=o;return!0}startTask(s,o){const e=`${s}-${Date.now()}`,r=s.toUpperCase(),t={id:e,module:r,title:o,status:"running",message:o,startTime:Date.now(),steps:[],spinnerFrame:0};this.tasks.set(e,t);this.activeModuleTasks.set(r,e);log_queue_1.logQueue.liveStart();this.startRendering();return{update:(s,o)=>{this.updateTask(e,s,o)},step:(s,o="info")=>{this.addStep(e,s,o)},succeed:s=>{this.completeTask(e,"success",s)},fail:s=>{this.completeTask(e,"error",s)},warn:s=>{this.completeTask(e,"warn",s)},setRequest:(s,o)=>{const r=this.tasks.get(e);r&&(r.request={method:s,url:o})}}}updateTask(s,o,e){const r=this.tasks.get(s);if(r){r.message=o;void 0!==(null==e?void 0:e.progress)&&(r.progress=Math.min(100,Math.max(0,e.progress)))}}addStep(s,o,e){const r=this.tasks.get(s);if(r){r.steps.push({message:o,status:e,time:Date.now()});r.message=o}}completeTask(s,o,e){const r=this.tasks.get(s);if(!r)return;r.status=o;e&&(r.message=e);const t=this.buildFinalTaskOutput(r);this.tasks.delete(s);this.activeModuleTasks.delete(r.module);0===this.tasks.size&&this.stopRendering();log_queue_1.logQueue.liveDone(t)}buildFinalTaskOutput(s){const o=this.getTimestamp(),e=parseInt(s.message,10),r=isNaN(e)?this.formatDuration(Date.now()-s.startTime):this.formatDuration(e);if(0===s.steps.length){return`${o} ${this.getStatusIcon(s.status)} ${this.getStatusColor(s.status)}${s.title.replace(/\.\.\.?$/,"")}${colors_1.colors.reset} ${colors_1.colors.gray}(${r})${colors_1.colors.reset}`}const t=[],l=" ".repeat(s.module.length+12);if(s.request){const e=s.request.method.toUpperCase(),r="GET"===e?colors_1.colors.green:"POST"===e?colors_1.colors.yellow:"PUT"===e?colors_1.colors.blue:"DELETE"===e?colors_1.colors.red:colors_1.colors.cyan;t.push(`${o} ${colors_1.colors.cyan}[${s.module}]${colors_1.colors.reset} ${colors_1.colors.cyan}▶${colors_1.colors.reset}  ${r}${e}${colors_1.colors.reset} ${colors_1.colors.white}${s.request.url}${colors_1.colors.reset}`);t.push(`${l}├─ ${colors_1.colors.dim}${s.title}${colors_1.colors.reset}`)}else t.push(`${o} ${colors_1.colors.cyan}[${s.module}]${colors_1.colors.reset} ${colors_1.colors.cyan}▶${colors_1.colors.reset}  ${s.title}`);const c=s.steps[s.steps.length-1],n=c&&("success"===c.status||"error"===c.status||"warn"===c.status),a=n?s.steps.slice(0,-1):s.steps;for(const s of a){let o="",e=colors_1.colors.dim;switch(s.status){case"success":o=`${colors_1.colors.green}${colors_1.icons.success}${colors_1.colors.reset} `;break;case"warn":o=`${colors_1.colors.yellow}${colors_1.icons.warning}${colors_1.colors.reset} `;e=colors_1.colors.yellow;break;case"error":o=`${colors_1.colors.red}${colors_1.icons.error}${colors_1.colors.reset} `;e=colors_1.colors.red}t.push(`${l}├─ ${o}${e}${s.message}${colors_1.colors.reset}`)}const i=this.getStatusIcon(s.status),u="success"===s.status?colors_1.colors.green:"error"===s.status?colors_1.colors.red:colors_1.colors.yellow;let _;_=n?c.message:"success"===s.status?"Completed":"Failed";t.push(`${l}└─ ${i} ${u}${_}${colors_1.colors.reset} ${colors_1.colors.gray}(${r})${colors_1.colors.reset}`);return t.join("\n")}startRendering(){!this.renderInterval&&this.isEnabled&&(this.renderInterval=setInterval(()=>{this.frameCount++;this.render()},this.spinner.interval))}stopRendering(){if(this.renderInterval){clearInterval(this.renderInterval);this.renderInterval=null}}render(){if(0===this.tasks.size)return;const s=[];for(const o of this.tasks.values())s.push(...this.renderTask(o));log_queue_1.logQueue.liveUpdate(s.join("\n"))}renderTask(s){const o=this.getTimestamp(),e=this.formatDuration(Date.now()-s.startTime),r=" ".repeat(s.module.length+12),t=this.spinner.frames[this.frameCount%this.spinner.frames.length],l=[];l.push(`${o} ${colors_1.colors.cyan}[${s.module}]${colors_1.colors.reset} ${colors_1.colors.cyan}▶${colors_1.colors.reset}  ${s.title}`);const c=s.steps.slice(0,-1);for(const s of c){let o="",e=colors_1.colors.dim;switch(s.status){case"success":o=`${colors_1.colors.green}${colors_1.icons.success}${colors_1.colors.reset} `;break;case"warn":o=`${colors_1.colors.yellow}${colors_1.icons.warning}${colors_1.colors.reset} `;e=colors_1.colors.yellow;break;case"error":o=`${colors_1.colors.red}${colors_1.icons.error}${colors_1.colors.reset} `;e=colors_1.colors.red}l.push(`${r}├─ ${o}${e}${s.message}${colors_1.colors.reset}`)}if(s.steps.length>0){const o=s.steps[s.steps.length-1],c=`${colors_1.colors.cyan}${t}${colors_1.colors.reset}`;l.push(`${r}├─ ${c} ${colors_1.colors.dim}${o.message}${colors_1.colors.reset} ${colors_1.colors.gray}${e}${colors_1.colors.reset}`)}else{const s=`${colors_1.colors.cyan}${t}${colors_1.colors.reset}`;l.push(`${r}└─ ${s} ${colors_1.colors.dim}Initializing...${colors_1.colors.reset} ${colors_1.colors.gray}${e}${colors_1.colors.reset}`)}return l}renderProgressBar(s,o){const e=Math.round(s/100*o),r=o-e,t=PROGRESS_CHARS.filled.repeat(Math.max(0,e-1)),l=e>0?PROGRESS_CHARS.head:"",c=PROGRESS_CHARS.empty.repeat(r);return`${colors_1.colors.green}${t}${l}${colors_1.colors.gray}${c}${colors_1.colors.reset}`}getStatusIcon(s){switch(s){case"success":return`${colors_1.colors.green}${colors_1.icons.success}${colors_1.colors.reset}`;case"error":return`${colors_1.colors.red}${colors_1.icons.error}${colors_1.colors.reset}`;case"warn":return`${colors_1.colors.yellow}${colors_1.icons.warning}${colors_1.colors.reset}`;default:return`${colors_1.colors.cyan}●${colors_1.colors.reset}`}}getStepIcon(s){switch(s){case"success":return`${colors_1.colors.green}${colors_1.icons.success}${colors_1.colors.reset}`;case"error":return`${colors_1.colors.red}${colors_1.icons.error}${colors_1.colors.reset}`;case"warn":return`${colors_1.colors.yellow}${colors_1.icons.warning}${colors_1.colors.reset}`;default:return`${colors_1.colors.dim}${colors_1.icons.bullet}${colors_1.colors.reset}`}}getStatusColor(s){switch(s){case"success":return colors_1.colors.green;case"error":return colors_1.colors.red;case"warn":return colors_1.colors.yellow;case"running":return colors_1.colors.cyan;default:return colors_1.colors.dim}}getTimestamp(){const s=new Date;return`${colors_1.colors.gray}${s.toISOString().split("T")[1].slice(0,8)}${colors_1.colors.reset}`}formatModule(s){return`${colors_1.colors.cyan}[${s}]${colors_1.colors.reset}`}formatDuration(s){if(s<1e3)return`${s}ms`;if(s<6e4)return`${(s/1e3).toFixed(1)}s`;return`${Math.floor(s/6e4)}m ${(s%6e4/1e3).toFixed(0)}s`}}exports.liveConsole=new LiveConsole;exports.default=exports.liveConsole;