"use strict";async function processRewards(e,r,l,a,n){var i,t,o,s,d,c,f;null===(i=null==n?void 0:n.step)||void 0===i||i.call(n,"Checking MLM extension status");const u=cache_1.CacheManager.getInstance();if(!(await u.getExtensions()).has("mlm"))return;null===(t=null==n?void 0:n.step)||void 0===t||t.call(n,"Loading MLM settings");const v=await u.getSettings(),g=v.get("affiliateMlmSystem")||v.get("mlmSystem")||"DIRECT",w={};if("BINARY"===g){const e=parseInt(v.get("affiliateBinaryLevels")||"0");if(e>=2&&e<=7){const r=[];for(let l=1;l<=e;l++){const e=parseFloat(v.get(`affiliateBinaryLevel${l}`)||"0");r.push({level:l,value:e})}w.binary={levels:e,levelsPercentage:r}}}else if("UNILEVEL"===g){const e=parseInt(v.get("affiliateUnilevelLevels")||"0");if(e>=2&&e<=7){const r=[];for(let l=1;l<=e;l++){const e=parseFloat(v.get(`affiliateUnilevelLevel${l}`)||"0");r.push({level:l,value:e})}w.unilevel={levels:e,levelsPercentage:r}}}if("BINARY"===g&&!w.binary)return;if("UNILEVEL"===g&&!w.unilevel)return;const{mlmReferralCondition:m}=db_1.models;try{null===(o=null==n?void 0:n.step)||void 0===o||o.call(n,"Looking up referral condition");const i=await m.findOne({where:{name:l,status:!0}});if(!i){console_1.logger.warn("MLM",`Referral condition not found or inactive: ${l}`);return}null===(s=null==n?void 0:n.step)||void 0===s||s.call(n,"Validating transaction against condition requirements");if(!isValidTransaction(l,r,a,i.minAmount)){console_1.logger.warn("MLM",`Transaction validation failed: ${l}, amount=${r}, currency=${a}, minAmount=${i.minAmount}`);return}let t=!1;null===(d=null==n?void 0:n.step)||void 0===d||d.call(n,`Processing ${g} rewards`);switch(g){case"DIRECT":t=await processDirectRewards(i,e,r,n);break;case"BINARY":t=await processBinaryRewards(i,e,r,w,n);break;case"UNILEVEL":t=await processUnilevelRewards(i,e,r,w,n);break;default:console_1.logger.error("MLM","Invalid MLM system type",new Error("Invalid MLM system type"))}if(t){null===(c=null==n?void 0:n.step)||void 0===c||c.call(n,"Sending reward notifications");await(0,notifications_1.createNotification)({userId:e,relatedId:i.id?i.id.toString():void 0,title:"Reward Processed",message:`Your reward for ${l} of ${r} ${a} has been successfully processed.`,type:"system",link:"/mlm/rewards",actions:[{label:"View Rewards",link:"/mlm/rewards",primary:!0}]},n);await(0,notifications_1.createAdminNotification)("View MLM Rewards","MLM Reward Processed",`A reward for ${l} of ${r} ${a} was processed for user ${e}.`,"system","/admin/mlm/rewards",void 0,void 0,n)}}catch(e){null===(f=null==n?void 0:n.fail)||void 0===f||f.call(n,e.message||"Failed to process rewards");console_1.logger.error("MLM","Failed to process rewards",e)}}function isValidTransaction(e,r,l,a){if(!e||"string"!=typeof e)return!1;if("number"!=typeof r||r<=0||!isFinite(r))return!1;if(!l||"string"!=typeof l)return!1;if(r<a)return!1;switch(e){case"WELCOME_BONUS":case"MONTHLY_TRADE_VOLUME":case"BINARY_TRADE_VOLUME":return"USDT"===l;case"FIRST_DEPOSIT_BONUS":case"DEPOSIT":case"SPOT_TRADE":case"SPOT_TRADE_VOLUME":case"TRADE":case"TRADE_COMMISSION":case"BINARY_WIN":case"BINARY_WIN_COMMISSION":case"INVESTMENT":case"GENERAL_INVESTMENT":case"AI_INVESTMENT":case"AI_INVESTMENT_PROFIT":case"FOREX_INVESTMENT":case"FOREX_PROFIT":case"FOREX_TRADE":case"ICO_CONTRIBUTION":case"ICO_PURCHASE":case"STAKING":case"STAKING_LOYALTY":case"ECOMMERCE_PURCHASE":case"ECOMMERCE_ORDER":case"P2P_TRADE":case"P2P_TRADE_COMPLETION":case"NFT_PURCHASE":case"NFT_SALE":case"NFT_TRADE":case"COPY_TRADING":case"COPY_TRADING_PROFIT":case"FUTURES_TRADE":case"FUTURES_PROFIT":case"FUTURES_VOLUME":case"TOKEN_PURCHASE":case"TOKEN_SALE":return!0;default:console_1.logger.warn("MLM",`Unknown condition name attempted: ${e}`);return!1}}async function processDirectRewards(e,r,l,a){var n,i,t,o;try{null===(n=null==a?void 0:a.step)||void 0===n||n.call(a,"Finding referral record");const s=await db_1.models.mlmReferral.findOne({where:{referredId:r}});if(!s)return!1;null===(i=null==a?void 0:a.step)||void 0===i||i.call(a,"Checking for duplicate rewards");if(await db_1.models.mlmReferralReward.findOne({where:{referrerId:s.referrerId,conditionId:e.id}})){console_1.logger.error("MLM",`Duplicate reward prevented for referrer ${s.referrerId}, condition ${e.id}`,new Error(`Duplicate reward prevented for referrer ${s.referrerId}, condition ${e.id}`));return!1}null===(t=null==a?void 0:a.step)||void 0===t||t.call(a,"Calculating reward amount");const d="PERCENTAGE"===e.rewardType?l*(e.reward/100):e.reward;if(d<=0){console_1.logger.error("MLM",`Invalid reward amount calculated: ${d}`,new Error(`Invalid reward amount calculated: ${d}`));return!1}null===(o=null==a?void 0:a.step)||void 0===o||o.call(a,"Creating reward record");await db_1.models.mlmReferralReward.create({referrerId:s.referrerId,conditionId:e.id,reward:d});return!0}catch(e){console_1.logger.error("MLM","Failed to process direct rewards",e);return!1}}async function findUplines(e,r,l){const a=[];let n=e;const i="BINARY"===r?db_1.models.mlmBinaryNode:db_1.models.mlmUnilevelNode;for(let e=0;e<l;e++)try{const l=await db_1.models.mlmReferral.findOne({where:{referredId:n},include:[{model:i,as:"BINARY"===r?"node":"unilevelNode",required:!0}]});if(!l||!l.referrerId)break;a.push({level:e+1,referrerId:l.referrerId});n=l.referrerId}catch(e){console_1.logger.error("MLM","Failed to find uplines",e);break}return a}async function createRewardRecord(e,r,l){try{if(!e||!l)throw(0,error_1.createError)({statusCode:400,message:"referrerId and conditionId are required"});if("number"!=typeof r||r<=0||!isFinite(r))throw(0,error_1.createError)({statusCode:400,message:`Invalid reward amount: ${r}`});if(await db_1.models.mlmReferralReward.findOne({where:{referrerId:e,conditionId:l,createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-6e4)}}})){console_1.logger.error("MLM",`Duplicate reward prevented for referrer ${e}, condition ${l}`,new Error(`Duplicate reward prevented for referrer ${e}, condition ${l}`));return!1}await db_1.models.mlmReferralReward.create({referrerId:e,reward:r,conditionId:l});return!0}catch(e){console_1.logger.error("MLM","Failed to create reward record",e);return!1}}async function processBinaryRewards(e,r,l,a,n){var i,t,o,s;try{null===(i=null==n?void 0:n.step)||void 0===i||i.call(n,"Validating binary MLM settings");if(!a.binary||!a.binary.levels)return!1;if(a.binary.levelsPercentage&&Array.isArray(a.binary.levelsPercentage)){const e=a.binary.levelsPercentage.reduce((e,r)=>e+("number"==typeof r.value?r.value:0),0);if(e>100){console_1.logger.error("MLM",`Total binary commission percentages (${e}%) cannot exceed 100%`,new Error(`Total binary commission percentages (${e}%) cannot exceed 100%`));return!1}}null===(t=null==n?void 0:n.step)||void 0===t||t.call(n,"Finding binary uplines");const d=a.binary.levels,c=await findUplines(r,"BINARY",d);if(!c.length)return!1;null===(o=null==n?void 0:n.step)||void 0===o||o.call(n,`Processing rewards for ${c.length} uplines`);for(let r=c.length-1;r>=0;r--){const n=c[r],i=d-r,t=null===(s=a.binary.levelsPercentage.find(e=>e.level===i))||void 0===s?void 0:s.value;if(void 0===t)continue;let o;if("PERCENTAGE"===e.rewardType){o=l*(e.reward/100)*(t/100)}else o=e.reward*(t/100);await createRewardRecord(n.referrerId,o,e.id)}return!0}catch(e){console_1.logger.error("MLM","Failed to process binary rewards",e);return!1}}async function processUnilevelRewards(e,r,l,a,n){var i,t,o,s;try{null===(i=null==n?void 0:n.step)||void 0===i||i.call(n,"Validating unilevel MLM settings");if(!a.unilevel||!a.unilevel.levels)return!1;if(a.unilevel.levelsPercentage&&Array.isArray(a.unilevel.levelsPercentage)){const e=a.unilevel.levelsPercentage.reduce((e,r)=>e+("number"==typeof r.value?r.value:0),0);if(e>100){console_1.logger.error("MLM",`Total unilevel commission percentages (${e}%) cannot exceed 100%`,new Error(`Total unilevel commission percentages (${e}%) cannot exceed 100%`));return!1}}null===(t=null==n?void 0:n.step)||void 0===t||t.call(n,"Finding unilevel uplines");const d=a.unilevel.levels,c=await findUplines(r,"UNILEVEL",d);if(!c.length)return!1;null===(o=null==n?void 0:n.step)||void 0===o||o.call(n,`Processing rewards for ${c.length} uplines`);for(let r=c.length-1;r>=0;r--){const n=c[r],i=d-r,t=null===(s=a.unilevel.levelsPercentage.find(e=>e.level===i))||void 0===s?void 0:s.value;if(void 0===t)continue;let o;if("PERCENTAGE"===e.rewardType){o=l*(e.reward/100)*(t/100)}else o=e.reward*(t/100);await createRewardRecord(n.referrerId,o,e.id)}return!0}catch(e){console_1.logger.error("MLM","Failed to process unilevel rewards",e);return!1}}Object.defineProperty(exports,"__esModule",{value:!0});exports.handleUnilevelMlmReferralRegister=exports.handleBinaryMlmReferralRegister=exports.handleReferralRegister=void 0;exports.processRewards=processRewards;const db_1=require("@b/db"),notifications_1=require("./notifications"),console_1=require("@b/utils/console"),cache_1=require("@b/utils/cache"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),handleReferralRegister=async(e,r,l)=>{var a,n,i,t,o,s;try{null===(a=null==l?void 0:l.step)||void 0===a||a.call(l,"Finding referrer user");const s=await db_1.models.user.findByPk(e);if(s){null===(n=null==l?void 0:l.step)||void 0===n||n.call(l,"Loading referral settings");const e=cache_1.CacheManager.getInstance(),a=await e.getSettings(),d=!!a.has("referralApprovalRequired")&&"true"===a.get("referralApprovalRequired");null===(i=null==l?void 0:l.step)||void 0===i||i.call(l,"Creating referral record");const c=await db_1.models.mlmReferral.create({referrerId:s.id,referredId:r,status:d?"PENDING":"ACTIVE"}),f=a.get("affiliateMlmSystem")||a.get("mlmSystem")||null;if("DIRECT"===f)return;if("BINARY"===f){null===(t=null==l?void 0:l.step)||void 0===t||t.call(l,"Registering binary MLM node");await(0,exports.handleBinaryMlmReferralRegister)(s.id,c,db_1.models.mlmBinaryNode,l)}else if("UNILEVEL"===f){null===(o=null==l?void 0:l.step)||void 0===o||o.call(l,"Registering unilevel MLM node");await(0,exports.handleUnilevelMlmReferralRegister)(s.id,c,db_1.models.mlmUnilevelNode,l)}}}catch(e){null===(s=null==l?void 0:l.fail)||void 0===s||s.call(l,e.message||"Failed to handle referral register");console_1.logger.error("MLM","Failed to handle referral register",e);throw e}};exports.handleReferralRegister=handleReferralRegister;const checkCycleForBinary=async(e,r,l)=>{let a=e;for(;a;){const e=await db_1.models.mlmReferral.findOne({where:{id:a.referralId}});if(e&&e.referredId===r)return!0;if(!a.parentId)break;a=await l.findByPk(a.parentId)}return!1},checkCycleForUnilevel=async(e,r,l)=>{let a=e;for(;a;){const e=await db_1.models.mlmReferral.findOne({where:{id:a.referralId}});if(e&&e.referredId===r)return!0;if(!a.parentId)break;a=await l.findByPk(a.parentId)}return!1},handleBinaryMlmReferralRegister=async(e,r,l,a)=>await db_1.sequelize.transaction(async n=>{var i,t,o,s;try{null===(i=null==a?void 0:a.step)||void 0===i||i.call(a,"Finding or creating referrer referral record");let d=await db_1.models.mlmReferral.findOne({where:{referrerId:e,referredId:e},transaction:n});d||(d=await db_1.models.mlmReferral.create({referrerId:e,referredId:e,status:"ACTIVE"},{transaction:n}));null===(t=null==a?void 0:a.step)||void 0===t||t.call(a,"Finding or creating binary node for referrer");let c=await l.findOne({where:{referralId:d.id},transaction:n,lock:n.LOCK.UPDATE});c||(c=await l.create({referralId:d.id,parentId:null},{transaction:n}));null===(o=null==a?void 0:a.step)||void 0===o||o.call(a,"Checking for referral cycles");if(await checkCycleForBinary(c,r.referredId,l))throw(0,error_1.createError)({statusCode:409,message:"Referral loop detected: the referred user is already an ancestor."});null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,"Creating binary node for new referral");const f=c.leftChildId?"rightChildId":"leftChildId",u=await l.create({referralId:r.id,parentId:c.id},{transaction:n});c[f]=u.id;await c.save({transaction:n});return u}catch(e){console_1.logger.error("MLM","Failed to handle binary MLM referral register",e);throw e}});exports.handleBinaryMlmReferralRegister=handleBinaryMlmReferralRegister;const handleUnilevelMlmReferralRegister=async(e,r,l,a)=>await db_1.sequelize.transaction(async n=>{var i,t,o,s;try{null===(i=null==a?void 0:a.step)||void 0===i||i.call(a,"Finding or creating referrer referral record");let d=await db_1.models.mlmReferral.findOne({where:{referrerId:e,referredId:e},transaction:n});d||(d=await db_1.models.mlmReferral.create({referrerId:e,referredId:e,status:"ACTIVE"},{transaction:n}));null===(t=null==a?void 0:a.step)||void 0===t||t.call(a,"Finding or creating unilevel node for referrer");let c=await l.findOne({where:{referralId:d.id},transaction:n,lock:n.LOCK.UPDATE});c||(c=await l.create({referralId:d.id,parentId:null},{transaction:n}));null===(o=null==a?void 0:a.step)||void 0===o||o.call(a,"Checking for referral cycles");if(await checkCycleForUnilevel(c,r.referredId,l))throw(0,error_1.createError)({statusCode:409,message:"Referral loop detected: the referred user is already an ancestor."});null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,"Creating unilevel node for new referral");return await l.create({referralId:r.id,parentId:c.id},{transaction:n})}catch(e){console_1.logger.error("MLM","Failed to handle unilevel MLM referral register",e);throw e}});exports.handleUnilevelMlmReferralRegister=handleUnilevelMlmReferralRegister;