"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.walletService=exports.WalletService=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("./errors"),precision_1=require("./utils/precision"),AuditLogger_1=require("./audit/AuditLogger"),PrecisionCacheService_1=require("./PrecisionCacheService");class WalletService{constructor(){this.auditLogger=new AuditLogger_1.AuditLogger}static getInstance(){WalletService.instance||(WalletService.instance=new WalletService);return WalletService.instance}async getWallet(e,a,t,r){const{transaction:n,lock:i=!1,createIfMissing:s=!1}=r||{},o={where:{userId:e,type:a,currency:t}};if(n){o.transaction=n;i&&(o.lock=sequelize_1.Transaction.LOCK.UPDATE)}let c=await db_1.models.wallet.findOne(o);!c&&s&&(c=await this.createBasicWallet(e,a,t,n));if(!c)throw new errors_1.WalletNotFoundError(`${e}/${a}/${t}`);return this.toWalletAttributes(c)}async getWalletById(e,a){const{transaction:t,lock:r=!1}=a||{},n={where:{id:e}};if(t){n.transaction=t;r&&(n.lock=sequelize_1.Transaction.LOCK.UPDATE)}const i=await db_1.models.wallet.findOne(n);if(!i)throw new errors_1.WalletNotFoundError(e);return this.toWalletAttributes(i)}async getWalletSafe(e,a,t,r){try{return await this.getWallet(e,a,t,r)}catch(e){if(e instanceof errors_1.WalletNotFoundError)return null;throw e}}async createBasicWallet(e,a,t,r){return await db_1.models.wallet.create({userId:e,type:a,currency:t,balance:0,inOrder:0,status:!0},r?{transaction:r}:void 0)}toWalletAttributes(e){var a,t;const r=e.get?e.get({plain:!0}):e;return{...r,balance:parseFloat((null===(a=r.balance)||void 0===a?void 0:a.toString())||"0"),inOrder:parseFloat((null===(t=r.inOrder)||void 0===t?void 0:t.toString())||"0")}}async checkIdempotency(e,a){const t=await db_1.models.transaction.findOne({where:{[sequelize_1.Op.or]:[{id:e},{metadata:{[sequelize_1.Op.like]:`%"idempotencyKey":"${e}"%`}}]},attributes:["id"],...a&&{transaction:a}});return t?{isDuplicate:!0,existingTransactionId:t.id}:{isDuplicate:!1}}validateAmount(e,a){if(e<=0)throw new errors_1.InvalidAmountError(e,`${a} amount must be positive`);if(!isFinite(e))throw new errors_1.InvalidAmountError(e,"Amount must be a finite number")}validateWalletStatus(e){if(!e.status)throw new errors_1.WalletDisabledError(e.id)}mapOperationTypeToTransactionType(e){return{DEPOSIT:"DEPOSIT",WITHDRAW:"WITHDRAW",INCOMING_TRANSFER:"INCOMING_TRANSFER",OUTGOING_TRANSFER:"OUTGOING_TRANSFER",PAYMENT:"PAYMENT",REFUND:"REFUND",BINARY_ORDER:"BINARY_ORDER",EXCHANGE_ORDER:"EXCHANGE_ORDER",INVESTMENT:"INVESTMENT",INVESTMENT_ROI:"INVESTMENT_ROI",AI_INVESTMENT:"AI_INVESTMENT",AI_INVESTMENT_ROI:"AI_INVESTMENT_ROI",INVOICE:"INVOICE",FOREX_DEPOSIT:"FOREX_DEPOSIT",FOREX_WITHDRAW:"FOREX_WITHDRAW",FOREX_INVESTMENT:"FOREX_INVESTMENT",FOREX_INVESTMENT_ROI:"FOREX_INVESTMENT_ROI",ICO_CONTRIBUTION:"ICO_CONTRIBUTION",REFERRAL_REWARD:"REFERRAL_REWARD",STAKING:"STAKING",STAKING_REWARD:"STAKING_REWARD",P2P_OFFER_TRANSFER:"P2P_OFFER_TRANSFER",P2P_TRADE:"P2P_TRADE",NFT_PURCHASE:"NFT_PURCHASE",NFT_SALE:"NFT_SALE",NFT_MINT:"NFT_MINT",NFT_BURN:"NFT_BURN",NFT_TRANSFER:"NFT_TRANSFER",NFT_AUCTION_BID:"NFT_AUCTION_BID",NFT_AUCTION_SETTLE:"NFT_AUCTION_SETTLE",NFT_OFFER:"NFT_OFFER",BINARY_ORDER_WIN:"BINARY_ORDER",BINARY_ORDER_LOSS:"BINARY_ORDER",HOLD:"EXCHANGE_ORDER",RELEASE:"EXCHANGE_ORDER",TRADE_DEBIT:"EXCHANGE_ORDER",TRADE_CREDIT:"EXCHANGE_ORDER",FEE:"PAYMENT",REFUND_WITHDRAWAL:"REFUND",ADJUSTMENT:"DEPOSIT",STAKING_DEPOSIT:"STAKING",STAKING_WITHDRAW:"STAKING",ECO_DEPOSIT:"DEPOSIT",ECO_WITHDRAW:"WITHDRAW",ECO_REFUND:"REFUND",COPY_TRADING_REVERSAL:"REFUND",P2P_DISPUTE_RESOLVE:"P2P_TRADE",P2P_DISPUTE_RECEIVE:"P2P_TRADE",P2P_TRADE_RESOLVE:"P2P_TRADE",P2P_TRADE_RECEIVE:"P2P_TRADE",P2P_TRADE_RELEASE:"P2P_TRADE",P2P_TRADE_LOCK:"P2P_TRADE",P2P_TRADE_CANCEL:"P2P_TRADE",P2P_TRADE_EXPIRED:"P2P_TRADE",P2P_OFFER_LOCK:"P2P_OFFER_TRANSFER",P2P_OFFER_DELETE:"P2P_OFFER_TRANSFER",P2P_ADMIN_OFFER_DISABLE:"P2P_OFFER_TRANSFER",P2P_ADMIN_OFFER_REJECT:"P2P_OFFER_TRANSFER"}[e]||"PAYMENT"}async credit(e){this.validateAmount(e.amount,"Credit");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=e.walletId?await this.getWalletById(e.walletId,{transaction:a,lock:!0}):await this.getWallet(e.userId,e.walletType,e.currency,{transaction:a,lock:!0,createIfMissing:!0});this.validateWalletStatus(n);const i=(0,precision_1.roundToPrecision)(e.amount,e.currency),s=n.balance,o=(0,precision_1.safeAdd)(s,i,e.currency);await db_1.models.wallet.update({balance:o},{where:{id:n.id},transaction:a});const c=await db_1.models.transaction.create({userId:e.userId,walletId:n.id,type:this.mapOperationTypeToTransactionType(e.operationType),status:"COMPLETED",amount:i,fee:e.fee||0,description:e.description,referenceId:e.referenceId,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,operationType:e.operationType,previousBalance:s,newBalance:o,...e.metadata})},{transaction:a});await this.auditLogger.logCredit(n.id,e.userId,i,s,o,c.id,e.idempotencyKey,e.metadata);return{success:!0,walletId:n.id,transactionId:c.id,previousBalance:s,newBalance:o,previousInOrder:n.inOrder,newInOrder:n.inOrder,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async debit(e){this.validateAmount(e.amount,"Debit");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=e.walletId?await this.getWalletById(e.walletId,{transaction:a,lock:!0}):await this.getWallet(e.userId,e.walletType,e.currency,{transaction:a,lock:!0});this.validateWalletStatus(n);const i=(0,precision_1.roundToPrecision)(e.amount,e.currency),s=(0,precision_1.roundToPrecision)(e.fee||0,e.currency),o=(0,precision_1.safeAdd)(i,s,e.currency),c=n.balance;if(c<o)throw new errors_1.InsufficientFundsError(c,o,e.currency);const d=(0,precision_1.safeSubtract)(c,o,e.currency);if(d<0)throw new errors_1.NegativeBalanceError(n.id,d);await db_1.models.wallet.update({balance:d},{where:{id:n.id},transaction:a});const l=await db_1.models.transaction.create({userId:e.userId,walletId:n.id,type:this.mapOperationTypeToTransactionType(e.operationType),status:"COMPLETED",amount:i,fee:s,description:e.description,referenceId:e.referenceId,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,operationType:e.operationType,previousBalance:c,newBalance:d,totalDebit:o,...e.metadata})},{transaction:a});await this.auditLogger.logDebit(n.id,e.userId,o,c,d,l.id,e.idempotencyKey,e.metadata);return{success:!0,walletId:n.id,transactionId:l.id,previousBalance:c,newBalance:d,previousInOrder:n.inOrder,newInOrder:n.inOrder,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async hold(e){this.validateAmount(e.amount,"Hold");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=e.walletId?await this.getWalletById(e.walletId,{transaction:a,lock:!0}):await this.getWallet(e.userId,e.walletType,e.currency,{transaction:a,lock:!0});this.validateWalletStatus(n);const i=(0,precision_1.roundToPrecision)(e.amount,e.currency),s=n.balance,o=n.inOrder;if(s<i)throw new errors_1.InsufficientFundsError(s,i,e.currency);const c=(0,precision_1.safeSubtract)(s,i,e.currency),d=(0,precision_1.safeAdd)(o,i,e.currency);if(c<0)throw new errors_1.NegativeBalanceError(n.id,c);await db_1.models.wallet.update({balance:c,inOrder:d},{where:{id:n.id},transaction:a});const l=await db_1.models.transaction.create({userId:e.userId,walletId:n.id,type:this.mapOperationTypeToTransactionType(e.operationType||"HOLD"),status:"COMPLETED",amount:i,fee:0,description:e.reason,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,operationType:e.operationType||"HOLD",previousBalance:s,newBalance:c,previousInOrder:o,newInOrder:d,expiresAt:e.expiresAt,...e.metadata})},{transaction:a});await this.auditLogger.logHold(n.id,e.userId,i,s,c,o,d,l.id,e.idempotencyKey,e.metadata);return{success:!0,walletId:n.id,transactionId:l.id,previousBalance:s,newBalance:c,previousInOrder:o,newInOrder:d,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async release(e){this.validateAmount(e.amount,"Release");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=e.walletId?await this.getWalletById(e.walletId,{transaction:a,lock:!0}):await this.getWallet(e.userId,e.walletType,e.currency,{transaction:a,lock:!0});this.validateWalletStatus(n);const i=(0,precision_1.roundToPrecision)(e.amount,e.currency),s=n.balance,o=n.inOrder;if(o<i)throw new errors_1.InsufficientHeldFundsError(o,i,e.currency);const c=(0,precision_1.safeAdd)(s,i,e.currency),d=(0,precision_1.safeSubtract)(o,i,e.currency);if(d<0)throw new errors_1.NegativeInOrderError(n.id,d);await db_1.models.wallet.update({balance:c,inOrder:d},{where:{id:n.id},transaction:a});const l=await db_1.models.transaction.create({userId:e.userId,walletId:n.id,type:this.mapOperationTypeToTransactionType(e.operationType||"RELEASE"),status:"COMPLETED",amount:i,fee:0,description:e.reason,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,operationType:e.operationType||"RELEASE",previousBalance:s,newBalance:c,previousInOrder:o,newInOrder:d,...e.metadata})},{transaction:a});await this.auditLogger.logRelease(n.id,e.userId,i,s,c,o,d,l.id,e.idempotencyKey,e.metadata);return{success:!0,walletId:n.id,transactionId:l.id,previousBalance:s,newBalance:c,previousInOrder:o,newInOrder:d,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async executeFromHold(e){this.validateAmount(e.amount,"Execute");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=e.walletId?await this.getWalletById(e.walletId,{transaction:a,lock:!0}):await this.getWallet(e.userId,e.walletType,e.currency,{transaction:a,lock:!0});this.validateWalletStatus(n);const i=(0,precision_1.roundToPrecision)(e.amount,e.currency),s=(0,precision_1.roundToPrecision)(e.fee||0,e.currency),o=(0,precision_1.safeAdd)(i,s,e.currency),c=n.inOrder,d=n.balance;if(c<o)throw new errors_1.InsufficientHeldFundsError(c,o,e.currency);const l=(0,precision_1.safeSubtract)(c,o,e.currency);if(l<0)throw new errors_1.NegativeInOrderError(n.id,l);await db_1.models.wallet.update({inOrder:l},{where:{id:n.id},transaction:a});const u=await db_1.models.transaction.create({userId:e.userId,walletId:n.id,type:this.mapOperationTypeToTransactionType(e.operationType),status:"COMPLETED",amount:i,fee:s,description:e.description,referenceId:e.referenceId,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,operationType:e.operationType,previousInOrder:c,newInOrder:l,...e.metadata})},{transaction:a});await this.auditLogger.logExecuteFromHold(n.id,e.userId,o,c,l,u.id,e.idempotencyKey,e.metadata);return{success:!0,walletId:n.id,transactionId:u.id,previousBalance:d,newBalance:d,previousInOrder:c,newInOrder:l,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async transfer(e){this.validateAmount(e.amount,"Transfer");if(e.fromUserId===e.toUserId&&e.fromWalletType===e.toWalletType&&e.fromCurrency===e.toCurrency)throw new errors_1.TransferError("Cannot transfer to the same wallet");const a=async a=>{const{isDuplicate:t,existingTransactionId:r}=await this.checkIdempotency(e.idempotencyKey,a);if(t)throw new errors_1.DuplicateOperationError(e.idempotencyKey,r);const n=await this.getWallet(e.fromUserId,e.fromWalletType,e.fromCurrency,{transaction:a,lock:!0}),i=await this.getWallet(e.toUserId,e.toWalletType,e.toCurrency,{transaction:a,lock:!0,createIfMissing:!0});this.validateWalletStatus(n);this.validateWalletStatus(i);const s=(0,precision_1.roundToPrecision)(e.amount,e.fromCurrency),o=e.feePercentage||0,c=(0,precision_1.roundToPrecision)(s*o/100,e.fromCurrency),d=(0,precision_1.safeAdd)(s,c,e.fromCurrency),l=e.exchangeRate||1,u=(0,precision_1.roundToPrecision)(s*l,e.toCurrency),p=n.balance;if(p<d)throw new errors_1.InsufficientFundsError(p,d,e.fromCurrency);const w=(0,precision_1.safeSubtract)(p,d,e.fromCurrency),I=i.balance,E=(0,precision_1.safeAdd)(I,u,e.toCurrency);if(w<0)throw new errors_1.NegativeBalanceError(n.id,w);await db_1.models.wallet.update({balance:w},{where:{id:n.id},transaction:a});await db_1.models.wallet.update({balance:E},{where:{id:i.id},transaction:a});const y=await db_1.models.transaction.create({userId:e.fromUserId,walletId:n.id,type:"OUTGOING_TRANSFER",status:"COMPLETED",amount:s,fee:c,description:e.description,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,previousBalance:p,newBalance:w,toWalletId:i.id,toUserId:e.toUserId,exchangeRate:l,...e.metadata})},{transaction:a}),_=await db_1.models.transaction.create({userId:e.toUserId,walletId:i.id,type:"INCOMING_TRANSFER",status:"COMPLETED",amount:u,fee:0,description:e.description,metadata:JSON.stringify({idempotencyKey:`${e.idempotencyKey}_receive`,previousBalance:I,newBalance:E,fromWalletId:n.id,fromUserId:e.fromUserId,exchangeRate:l,...e.metadata})},{transaction:a});c>0&&db_1.models.adminProfit&&await db_1.models.adminProfit.create({amount:c,currency:e.fromCurrency,type:"TRANSFER",transactionId:y.id,description:`Transfer fee from user ${e.fromUserId}`},{transaction:a});await this.auditLogger.logTransferOut(n.id,e.fromUserId,d,p,w,y.id,e.idempotencyKey,i.id,c,e.metadata);await this.auditLogger.logTransferIn(i.id,e.toUserId,u,I,E,_.id,`${e.idempotencyKey}_receive`,n.id,e.metadata);return{fromResult:{success:!0,walletId:n.id,transactionId:y.id,previousBalance:p,newBalance:w,previousInOrder:n.inOrder,newInOrder:n.inOrder,timestamp:new Date},toResult:{success:!0,walletId:i.id,transactionId:_.id,previousBalance:I,newBalance:E,previousInOrder:i.inOrder,newInOrder:i.inOrder,timestamp:new Date},fee:c}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async getTotalValue(e,a,t){const r=await this.getWallet(e,a,t);return(0,precision_1.safeAdd)(r.balance,r.inOrder,t)}async getAvailableBalance(e,a,t){return(await this.getWallet(e,a,t)).balance}async getUserWallets(e,a){const t={userId:e};a&&(t.type=a);return(await db_1.models.wallet.findAll({where:t})).map(e=>{var a,t;const r=e.get({plain:!0}),n=parseFloat((null===(a=r.balance)||void 0===a?void 0:a.toString())||"0"),i=parseFloat((null===(t=r.inOrder)||void 0===t?void 0:t.toString())||"0");return{walletId:r.id,userId:r.userId,type:r.type,currency:r.currency,balance:n,inOrder:i,totalValue:n+i,timestamp:new Date}})}async verifyWalletIntegrity(e){var a,t;const r=await this.getWalletById(e),n=await db_1.models.transaction.findAll({where:{walletId:e,status:"COMPLETED"}});let i=0;for(const e of n){const r=parseFloat((null===(a=e.amount)||void 0===a?void 0:a.toString())||"0"),n=parseFloat((null===(t=e.fee)||void 0===t?void 0:t.toString())||"0"),s=("string"==typeof e.metadata?JSON.parse(e.metadata):e.metadata||{}).operationType||e.type;switch(e.type){case"DEPOSIT":case"INCOMING_TRANSFER":case"REFUND":case"REFUND_WITHDRAWAL":case"TRADE_CREDIT":case"BINARY_ORDER_WIN":case"AI_INVESTMENT_ROI":case"STAKING_REWARD":i+=r;break;case"WITHDRAW":case"OUTGOING_TRANSFER":case"FEE":case"TRADE_DEBIT":case"BINARY_ORDER":case"BINARY_ORDER_LOSS":case"AI_INVESTMENT":case"ICO_CONTRIBUTION":case"STAKING_DEPOSIT":i-=r+n;break;case"EXCHANGE_ORDER":"HOLD"===s?i-=r:"RELEASE"===s&&(i+=r)}}const s=r.balance,o=Math.abs(i-s);return{isValid:o<1e-8,expectedBalance:(0,precision_1.roundToPrecision)(i,r.currency),actualBalance:s,discrepancy:o}}async hasSufficientBalance(e,a,t,r){try{return(await this.getWallet(e,a,t)).balance>=r}catch(e){if(e instanceof errors_1.WalletNotFoundError)return!1;throw e}}async getChainPrecision(e,a){return await PrecisionCacheService_1.precisionCacheService.getPrecision("ECO",e,a)}async updateBalancePrecision(e,a,t){const r=await this.getChainPrecision(a,t);return parseFloat(e.toFixed(r))}parseAddressJson(e){if("object"==typeof e&&null!==e)return e;try{return JSON.parse(e||"{}")}catch(e){return{}}}async ecoCredit(e){this.validateAmount(e.amount,"Eco Credit");const a=async a=>{var t,r;const{isDuplicate:n,existingTransactionId:i}=await this.checkIdempotency(e.idempotencyKey,a);if(n)throw new errors_1.DuplicateOperationError(e.idempotencyKey,i);const s=await db_1.models.wallet.findOne({where:{id:e.walletId},lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:a});if(!s)throw new errors_1.WalletNotFoundError(e.walletId);const o=this.toWalletAttributes(s);this.validateWalletStatus(o);const c=this.parseAddressJson(o.address),d=e.chain,l=e.currency,u=await this.updateBalancePrecision(e.amount,l,d);let p=0,w=0;if(c[d]){p=await this.updateBalancePrecision(parseFloat((null===(t=c[d].balance)||void 0===t?void 0:t.toString())||"0"),l,d);w=await this.updateBalancePrecision(p+u,l,d);c[d].balance=w}const I=o.balance,E=await this.updateBalancePrecision(I+u,l,d);await db_1.models.wallet.update({balance:E,address:JSON.stringify(c)},{where:{id:o.id},transaction:a});const y=await db_1.models.walletData.findOne({where:{walletId:o.id,chain:d},transaction:a});if(y){const e=parseFloat((null===(r=y.balance)||void 0===r?void 0:r.toString())||"0"),t=await this.updateBalancePrecision(e+u,l,d);await db_1.models.walletData.update({balance:t},{where:{walletId:o.id,chain:d},transaction:a})}const _=Array.isArray(e.fromAddress)?e.fromAddress[0]||"Unknown":e.fromAddress||"Unknown",T=await db_1.models.transaction.create({userId:e.userId,walletId:o.id,type:"DEPOSIT",status:"COMPLETED",amount:u,fee:e.fee||0,description:e.description||`Deposit of ${u} ${e.currency} from ${_}`,trxId:e.txHash,referenceId:e.referenceId,metadata:JSON.stringify({idempotencyKey:e.idempotencyKey,chain:d,currency:e.currency,previousBalance:I,newBalance:E,previousChainBalance:p,newChainBalance:w,from:e.fromAddress,to:e.toAddress,...e.metadata})},{transaction:a});await this.auditLogger.logCredit(o.id,e.userId,u,I,E,T.id,e.idempotencyKey,{chain:d,previousChainBalance:p,newChainBalance:w,...e.metadata});return{success:!0,walletId:o.id,transactionId:T.id,previousBalance:I,newBalance:E,previousChainBalance:p,newChainBalance:w,chain:d,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async ecoDebit(e){this.validateAmount(e.amount,"Eco Debit");const a=async a=>{var t,r;const{isDuplicate:n,existingTransactionId:i}=await this.checkIdempotency(e.idempotencyKey,a);if(n)throw new errors_1.DuplicateOperationError(e.idempotencyKey,i);const s=await db_1.models.wallet.findOne({where:{id:e.walletId},lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:a});if(!s)throw new errors_1.WalletNotFoundError(e.walletId);const o=this.toWalletAttributes(s);this.validateWalletStatus(o);const c=this.parseAddressJson(o.address),d=e.chain,l=e.currency,u=await this.updateBalancePrecision(e.amount,l,d);let p=0,w=0;if(!c[d])throw(0,error_1.createError)({statusCode:404,message:`Chain ${d} not found in wallet addresses`});p=await this.updateBalancePrecision(parseFloat((null===(t=c[d].balance)||void 0===t?void 0:t.toString())||"0"),l,d);w=await this.updateBalancePrecision(p-u,l,d);if(w<0)throw new errors_1.InsufficientFundsError(p,u,l);c[d].balance=w;const I=o.balance,E=await this.updateBalancePrecision(I-u,l,d);if(E<0)throw new errors_1.NegativeBalanceError(o.id,E);await db_1.models.wallet.update({balance:E,address:JSON.stringify(c)},{where:{id:o.id},transaction:a});const y=await db_1.models.walletData.findOne({where:{walletId:o.id,chain:d},transaction:a});if(y){const e=parseFloat((null===(r=y.balance)||void 0===r?void 0:r.toString())||"0"),t=await this.updateBalancePrecision(e-u,l,d);await db_1.models.walletData.update({balance:t},{where:{walletId:o.id,chain:d},transaction:a})}await this.auditLogger.logDebit(o.id,e.userId,u,I,E,e.idempotencyKey,e.idempotencyKey,{chain:d,previousChainBalance:p,newChainBalance:w,...e.metadata});return{success:!0,walletId:o.id,transactionId:e.idempotencyKey,previousBalance:I,newBalance:E,previousChainBalance:p,newChainBalance:w,chain:d,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}async ecoRefund(e){this.validateAmount(e.amount,"Eco Refund");const a=async a=>{var t,r;const{isDuplicate:n,existingTransactionId:i}=await this.checkIdempotency(e.idempotencyKey,a);if(n)throw new errors_1.DuplicateOperationError(e.idempotencyKey,i);const s=await db_1.models.wallet.findOne({where:{id:e.walletId},lock:sequelize_1.Transaction.LOCK.UPDATE,transaction:a});if(!s)throw new errors_1.WalletNotFoundError(e.walletId);const o=this.toWalletAttributes(s),c=this.parseAddressJson(o.address),d=e.chain,l=e.currency,u=await this.updateBalancePrecision(e.amount,l,d);let p=0,w=0;if(d&&c[d]){p=await this.updateBalancePrecision(parseFloat((null===(t=c[d].balance)||void 0===t?void 0:t.toString())||"0"),l,d);w=await this.updateBalancePrecision(p+u,l,d);c[d].balance=w}const I=o.balance,E=await this.updateBalancePrecision(I+u,l,d);await db_1.models.wallet.update({balance:E,address:JSON.stringify(c)},{where:{id:o.id},transaction:a});if(d){const e=await db_1.models.walletData.findOne({where:{walletId:o.id,chain:d},transaction:a});if(e){const t=parseFloat((null===(r=e.balance)||void 0===r?void 0:r.toString())||"0"),n=await this.updateBalancePrecision(t+u,l,d);await db_1.models.walletData.update({balance:n},{where:{walletId:o.id,chain:d},transaction:a})}}await this.auditLogger.logCredit(o.id,e.userId,u,I,E,e.idempotencyKey,e.idempotencyKey,{chain:d,previousChainBalance:p,newChainBalance:w,refund:!0,...e.metadata});return{success:!0,walletId:o.id,transactionId:e.idempotencyKey,previousBalance:I,newBalance:E,previousChainBalance:p,newChainBalance:w,chain:d,timestamp:new Date}};return e.transaction?a(e.transaction):await db_1.sequelize.transaction(a)}}exports.WalletService=WalletService;exports.walletService=WalletService.getInstance();