"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.utxoService=exports.UtxoService=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),errors_1=require("./errors"),precision_1=require("./utils/precision"),constants_1=require("./constants");class UtxoService{constructor(){}static getInstance(){UtxoService.instance||(UtxoService.instance=new UtxoService);return UtxoService.instance}async saveUtxos(t,e,s,o,n){if(!db_1.models.ecosystemUtxo){console_1.logger.warn("UTXO","EcosystemUtxo model not available");return[]}const r=[];for(let a=0;a<s.length;a++){const i=s[a];if(i.addresses&&i.addresses.includes(o))try{if(await db_1.models.ecosystemUtxo.findOne({where:{transactionId:e,index:a},...n&&{transaction:n}})){console_1.logger.debug("UTXO",`UTXO ${e}:${a} already exists, skipping`);continue}const s=await db_1.models.ecosystemUtxo.create({walletId:t,transactionId:e,index:a,amount:parseFloat(i.value.toString()),script:i.script||"",status:!1},n?{transaction:n}:void 0);r.push(this.toAttributes(s));console_1.logger.debug("UTXO",`Saved UTXO: ${e}:${a} amount=${i.value}`)}catch(t){console_1.logger.error("UTXO",`Failed to save UTXO ${e}:${a}: ${t.message}`)}}return r}async createUtxo(t,e,s,o,n,r){if(!db_1.models.ecosystemUtxo)throw new errors_1.UtxoError("EcosystemUtxo model not available");const a=await db_1.models.ecosystemUtxo.create({walletId:t,transactionId:e,index:s,amount:o,script:n,status:!1},r?{transaction:r}:void 0);return this.toAttributes(a)}async selectUtxos(t,e,s,o=10){if(!db_1.models.ecosystemUtxo)throw new errors_1.UtxoError("EcosystemUtxo model not available");const n=await db_1.models.ecosystemUtxo.findAll({where:{walletId:t,status:!1},order:[["amount","DESC"]]});if(0===n.length)throw new errors_1.InsufficientFundsError(0,e,s);const r=(0,constants_1.getDustLimit)(s),a=[];let i=0,d=0;for(const t of n){const n=parseFloat(t.amount.toString());if(n<r)continue;a.push(this.toAttributes(t));i=(0,precision_1.safeAdd)(i,n,s);d=(constants_1.UTXO_TX_SIZE.BASE_TX+a.length*constants_1.UTXO_TX_SIZE.INPUT_SIZE+2*constants_1.UTXO_TX_SIZE.OUTPUT_SIZE)*o/1e8;if(i>=e+d)break}if(i<e+d)throw new errors_1.InsufficientFundsError(i,e+d,s);const l=(0,precision_1.safeSubtract)(i,e+d,s);return{utxos:a,totalAmount:i,fee:(0,precision_1.roundToPrecision)(d,s),change:l>r?l:0}}async selectAllUtxos(t){if(!db_1.models.ecosystemUtxo)return[];return(await db_1.models.ecosystemUtxo.findAll({where:{walletId:t,status:!1},order:[["amount","DESC"]]})).map(t=>this.toAttributes(t))}async markAsSpent(t,e){if(db_1.models.ecosystemUtxo&&0!==t.length){await db_1.models.ecosystemUtxo.update({status:!0},{where:{id:{[sequelize_1.Op.in]:t}},...e&&{transaction:e}});console_1.logger.debug("UTXO",`Marked ${t.length} UTXOs as spent`)}}async markAsUnspent(t,e){if(db_1.models.ecosystemUtxo&&0!==t.length){await db_1.models.ecosystemUtxo.update({status:!1},{where:{id:{[sequelize_1.Op.in]:t}},...e&&{transaction:e}});console_1.logger.debug("UTXO",`Marked ${t.length} UTXOs as unspent`)}}async markByTxHashAsSpent(t,e){db_1.models.ecosystemUtxo&&await db_1.models.ecosystemUtxo.update({status:!0},{where:{transactionId:t},...e&&{transaction:e}})}async needsConsolidation(t,e){if(!db_1.models.ecosystemUtxo)return!1;const s=await db_1.models.ecosystemUtxo.findAll({where:{walletId:t,status:!1}});if(s.length<5)return!1;return s.reduce((t,e)=>t+parseFloat(e.amount.toString()),0)/s.length<3*(10*constants_1.UTXO_TX_SIZE.INPUT_SIZE/1e8)}async getUtxosForConsolidation(t,e=100){if(!db_1.models.ecosystemUtxo)return[];return(await db_1.models.ecosystemUtxo.findAll({where:{walletId:t,status:!1},order:[["amount","ASC"]],limit:e})).map(t=>this.toAttributes(t))}async getConsolidationRecommendation(t,e){if(!db_1.models.ecosystemUtxo)return{shouldConsolidate:!1,utxoCount:0,totalAmount:0,estimatedFee:0,estimatedSavings:0};const s=await db_1.models.ecosystemUtxo.findAll({where:{walletId:t,status:!1}}),o=s.length,n=s.reduce((t,e)=>t+parseFloat(e.amount.toString()),0),r=10*(constants_1.UTXO_TX_SIZE.BASE_TX+o*constants_1.UTXO_TX_SIZE.INPUT_SIZE+constants_1.UTXO_TX_SIZE.OUTPUT_SIZE)/1e8,a=(o-1)*constants_1.UTXO_TX_SIZE.INPUT_SIZE*10/1e8;return{shouldConsolidate:o>=10&&a>r,utxoCount:o,totalAmount:n,estimatedFee:r,estimatedSavings:a-r}}async getUnspentBalance(t){if(!db_1.models.ecosystemUtxo)return 0;return await db_1.models.ecosystemUtxo.sum("amount",{where:{walletId:t,status:!1}})||0}async getUtxoCount(t){if(!db_1.models.ecosystemUtxo)return{unspent:0,spent:0};return{unspent:await db_1.models.ecosystemUtxo.count({where:{walletId:t,status:!1}}),spent:await db_1.models.ecosystemUtxo.count({where:{walletId:t,status:!0}})}}async getById(t){if(!db_1.models.ecosystemUtxo)return null;const e=await db_1.models.ecosystemUtxo.findByPk(t);return e?this.toAttributes(e):null}async getByTxIdAndIndex(t,e){if(!db_1.models.ecosystemUtxo)return null;const s=await db_1.models.ecosystemUtxo.findOne({where:{transactionId:t,index:e}});return s?this.toAttributes(s):null}async getAllForWallet(t){if(!db_1.models.ecosystemUtxo)return[];return(await db_1.models.ecosystemUtxo.findAll({where:{walletId:t},order:[["createdAt","DESC"]]})).map(t=>this.toAttributes(t))}async cleanupOldSpentUtxos(t=30){if(!db_1.models.ecosystemUtxo)return 0;const e=new Date;e.setDate(e.getDate()-t);const s=await db_1.models.ecosystemUtxo.destroy({where:{status:!0,updatedAt:{[sequelize_1.Op.lt]:e}}});s>0&&console_1.logger.info("UTXO",`Cleaned up ${s} old spent UTXOs`);return s}toAttributes(t){var e;const s=t.get?t.get({plain:!0}):t;return{...s,amount:parseFloat((null===(e=s.amount)||void 0===e?void 0:e.toString())||"0")}}}exports.UtxoService=UtxoService;exports.utxoService=UtxoService.getInstance();