"use strict";function isValidPhoneNumber(e){if(!e)return!1;return/^\+[1-9]\d{1,14}$/.test(e)}function formatPhoneNumber(e,r="+1"){if(!e)return"";let n=e.replace(/[^\d+]/g,"");if(n.startsWith("+")&&isValidPhoneNumber(n))return n;n=n.replace(/^(\+|00)/,"");n.startsWith(r.replace("+",""))||(n=r.replace("+","")+n);n.startsWith("+")||(n="+"+n);return n}function getCountryCode(e){if(!isValidPhoneNumber(e))return null;const r=e.match(/^\+(\d{1,3})/);return r?r[1]:null}function formatPhoneForDisplay(e){if(!isValidPhoneNumber(e))return e;const r=getCountryCode(e);if(!r)return e;const n=e.substring(r.length+1);return"1"===r&&10===n.length?`+1 (${n.substring(0,3)}) ${n.substring(3,6)}-${n.substring(6)}`:`+${r} ${n}`}function validatePhoneNumbers(e){const r=[],n=[];for(const o of e)isValidPhoneNumber(o)?r.push(o):n.push(o);return{valid:r,invalid:n}}function normalizePhoneNumber(e,r="+1"){try{const n=formatPhoneNumber(e,r);if(isValidPhoneNumber(n))return n;console_1.logger.warn("PhoneValidation",`Invalid phone number after formatting: original="${e}", formatted="${n}"`);return null}catch(r){console_1.logger.error("PhoneValidation",`Phone number normalization failed for: ${e}`,r instanceof Error?r:new Error(String(r)));return null}}function isMobilePhone(e){if(!isValidPhoneNumber(e))return!1;if("1"===getCountryCode(e)){const r=e.substring(2).substring(0,3);return/^[2-9]/.test(r)}return!0}function getPhoneMetadata(e){const r=isValidPhoneNumber(e);return{valid:r,formatted:r?e:null,countryCode:r?getCountryCode(e):null,displayFormat:r?formatPhoneForDisplay(e):null,isMobile:!!r&&isMobilePhone(e)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.isValidPhoneNumber=isValidPhoneNumber;exports.formatPhoneNumber=formatPhoneNumber;exports.getCountryCode=getCountryCode;exports.formatPhoneForDisplay=formatPhoneForDisplay;exports.validatePhoneNumbers=validatePhoneNumbers;exports.normalizePhoneNumber=normalizePhoneNumber;exports.isMobilePhone=isMobilePhone;exports.getPhoneMetadata=getPhoneMetadata;const console_1=require("@b/utils/console");