"use strict";async function addDeviceToken(e,t,n,o){try{const s=await db_1.models.user.findByPk(e);if(!s){console_1.logger.error("DeviceToken",`User not found for device token: ${e}`);return!1}const r=s.settings||{};r.pushTokens||(r.pushTokens={});const i=n||`device-${Date.now()}`;r.pushTokens[i]={token:t,platform:o,createdAt:(new Date).toISOString(),lastUsed:(new Date).toISOString()};await s.update({settings:r});console_1.logger.info("DeviceToken",`Device token added: ${i}`,{userId:e,deviceId:i,platform:o});return!0}catch(t){console_1.logger.error("DeviceToken",`Failed to add device token for user ${e}`,t instanceof Error?t:new Error(String(t)));return!1}}async function removeDeviceToken(e,t){try{const n=await db_1.models.user.findByPk(e);if(!n||!n.settings||!n.settings.pushTokens)return!1;const o=n.settings;let s=!1;if(o.pushTokens[t]){delete o.pushTokens[t];s=!0}else for(const[e,n]of Object.entries(o.pushTokens)){if("object"==typeof n&&null!==n&&n.token===t){delete o.pushTokens[e];s=!0;break}if(n===t){delete o.pushTokens[e];s=!0;break}}if(s){await n.update({settings:o});console_1.logger.info("DeviceToken",`Device token removed for user ${e}`);return!0}return!1}catch(t){console_1.logger.error("DeviceToken",`Failed to remove device token for user ${e}`,t instanceof Error?t:new Error(String(t)));return!1}}async function getDeviceTokens(e){try{const t=await db_1.models.user.findByPk(e);if(!t||!t.settings||!t.settings.pushTokens)return[];const n=[];for(const[e,o]of Object.entries(t.settings.pushTokens))if("object"==typeof o&&null!==o&&o.token){const t=o;n.push({deviceId:e,token:t.token,platform:t.platform,createdAt:t.createdAt?new Date(t.createdAt):void 0,lastUsed:t.lastUsed?new Date(t.lastUsed):void 0})}else"string"==typeof o&&n.push({deviceId:e,token:o});return n}catch(t){console_1.logger.error("DeviceToken",`Failed to get device tokens for user ${e}`,t instanceof Error?t:new Error(String(t)));return[]}}async function getTokenStrings(e){return(await getDeviceTokens(e)).map(e=>e.token)}async function updateTokenLastUsed(e,t){try{const n=await db_1.models.user.findByPk(e);if(!n||!n.settings||!n.settings.pushTokens)return!1;const o=n.settings.pushTokens[t];if(o&&"object"==typeof o){o.lastUsed=(new Date).toISOString();await n.update({settings:n.settings});return!0}return!1}catch(n){console_1.logger.error("DeviceToken",`Failed to update token last used for user ${e}, device ${t}`,n instanceof Error?n:new Error(String(n)));return!1}}async function removeInactiveTokens(e,t=90){try{const n=await db_1.models.user.findByPk(e);if(!n||!n.settings||!n.settings.pushTokens)return 0;const o=new Date;o.setDate(o.getDate()-t);let s=0;for(const[e,t]of Object.entries(n.settings.pushTokens))if("object"==typeof t&&null!==t&&t.lastUsed){if(new Date(t.lastUsed)<o){delete n.settings.pushTokens[e];s++}}if(s>0){await n.update({settings:n.settings});console_1.logger.info("DeviceToken",`Removed ${s} inactive device tokens for user ${e}`)}return s}catch(t){console_1.logger.error("DeviceToken",`Failed to remove inactive tokens for user ${e}`,t instanceof Error?t:new Error(String(t)));return 0}}function isValidFCMToken(e){if(!e||e.length<100||e.length>200)return!1;return/^[a-zA-Z0-9_-]+$/.test(e)}async function getTokenCount(e){return(await getDeviceTokens(e)).length}async function hasDeviceTokens(e){return await getTokenCount(e)>0}Object.defineProperty(exports,"__esModule",{value:!0});exports.addDeviceToken=addDeviceToken;exports.removeDeviceToken=removeDeviceToken;exports.getDeviceTokens=getDeviceTokens;exports.getTokenStrings=getTokenStrings;exports.updateTokenLastUsed=updateTokenLastUsed;exports.removeInactiveTokens=removeInactiveTokens;exports.isValidFCMToken=isValidFCMToken;exports.getTokenCount=getTokenCount;exports.hasDeviceTokens=hasDeviceTokens;const db_1=require("@b/db"),console_1=require("@b/utils/console");