"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.TwilioProvider=void 0;const twilio_1=require("twilio"),BaseSMSProvider_1=require("./BaseSMSProvider");class TwilioProvider extends BaseSMSProvider_1.BaseSMSProvider{constructor(i){super("Twilio",i);if(this.validateConfig())try{this.initializeClient()}catch(i){this.logError("Failed to initialize Twilio client",i)}}loadConfigFromEnv(){return{accountSid:process.env.APP_TWILIO_ACCOUNT_SID,authToken:process.env.APP_TWILIO_AUTH_TOKEN,fromNumber:process.env.APP_TWILIO_PHONE_NUMBER,messagingServiceSid:process.env.APP_TWILIO_MESSAGING_SERVICE_SID}}validateConfig(){if(!this.config.accountSid){this.logError("Missing APP_TWILIO_ACCOUNT_SID",{});return!1}if(!this.config.accountSid.startsWith("AC")){this.logError("Invalid APP_TWILIO_ACCOUNT_SID - must start with 'AC'",{});return!1}if(!this.config.authToken){this.logError("Missing APP_TWILIO_AUTH_TOKEN",{});return!1}if(!this.config.fromNumber&&!this.config.messagingServiceSid){this.logError("Missing APP_TWILIO_PHONE_NUMBER or APP_TWILIO_MESSAGING_SERVICE_SID",{});return!1}return!0}initializeClient(){try{this.client=new twilio_1.Twilio(this.config.accountSid,this.config.authToken)}catch(i){this.logError("Failed to initialize Twilio client",i);throw i}}async send(i){try{if(!this.validateConfig()||!this.client)throw new Error("Twilio configuration is invalid or client not initialized");const e=this.formatPhoneNumber(i.to);if(!this.validatePhoneNumber(e))return{success:!1,error:`Invalid phone number format: ${i.to}`};const t=this.truncateMessage(i.message,160),r=this.calculateSMSParts(t);r>1&&this.log(`Message will be sent in ${r} parts`,{originalLength:i.message.length});const s={to:e,body:t};this.config.messagingServiceSid?s.messagingServiceSid=this.config.messagingServiceSid:s.from=i.from||this.config.fromNumber;const o=await this.client.messages.create(s);this.log("SMS sent successfully",{to:e,sid:o.sid,status:o.status,parts:r});return{success:!0,messageId:`twilio-${o.sid}`,externalId:o.sid,metadata:{status:o.status,parts:r,price:o.price,priceUnit:o.priceUnit}}}catch(i){this.logError("Failed to send SMS",i);return{success:!1,error:i.message||"Failed to send SMS via Twilio"}}}async getMessageStatus(i){try{if(!this.client)throw new Error("Twilio client not initialized");const e=await this.client.messages(i).fetch();return{sid:e.sid,status:e.status,to:e.to,from:e.from,body:e.body,errorCode:e.errorCode,errorMessage:e.errorMessage,dateCreated:e.dateCreated,dateSent:e.dateSent,dateUpdated:e.dateUpdated}}catch(i){this.logError("Failed to get message status",i);throw i}}async verifyPhoneNumber(i){try{if(!this.client)throw new Error("Twilio client not initialized");const e=this.formatPhoneNumber(i),t=await this.client.lookups.v1.phoneNumbers(e).fetch();return{valid:!0,phoneNumber:t.phoneNumber,countryCode:t.countryCode,nationalFormat:t.nationalFormat}}catch(i){this.logError("Phone number verification failed",i);return{valid:!1,error:i.message}}}}exports.TwilioProvider=TwilioProvider;