"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.SendGridProvider=void 0;const mail_1=__importDefault(require("@sendgrid/mail")),BaseEmailProvider_1=require("./BaseEmailProvider");class SendGridProvider extends BaseEmailProvider_1.BaseEmailProvider{constructor(e){super("SendGrid",e);this.validateConfig()&&mail_1.default.setApiKey(this.config.apiKey)}loadConfigFromEnv(){return{apiKey:process.env.APP_SENDGRID_API_KEY||"",from:process.env.APP_EMAIL_FROM||"noreply@example.com",fromName:process.env.APP_EMAIL_FROM_NAME||"Notification Service"}}validateConfig(){if(!this.config.apiKey){this.logError("Missing SendGrid API key",{});return!1}return!0}async send(e){try{if(!this.validateConfig())throw new Error("SendGrid configuration is invalid");const t={to:Array.isArray(e.to)?e.to:[e.to],from:e.from||this.formatEmail(this.config.from,this.config.fromName),subject:e.subject,html:e.html,text:e.text||this.stripHtml(e.html)};e.replyTo&&(t.replyTo=e.replyTo);e.cc&&e.cc.length>0&&(t.cc=e.cc);e.bcc&&e.bcc.length>0&&(t.bcc=e.bcc);e.attachments&&e.attachments.length>0&&(t.attachments=e.attachments.map(e=>({filename:e.filename,content:e.content,type:e.contentType})));const r=await mail_1.default.send(t);this.log("Email sent successfully",{to:e.to,subject:e.subject,messageId:r[0].headers["x-message-id"]});return{success:!0,externalId:r[0].headers["x-message-id"],messageId:`sendgrid-${r[0].headers["x-message-id"]}`}}catch(e){this.logError("Failed to send email",e);return{success:!1,error:e.message||"Failed to send email via SendGrid"}}}stripHtml(e){return e.replace(/<[^>]*>/g,"").replace(/&nbsp;/g," ").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">").trim()}}exports.SendGridProvider=SendGridProvider;