"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.NoContactMethodError=exports.TemplateRenderError=exports.RedisCacheError=exports.InvalidConfigError=exports.InvalidAmountError=exports.RateLimitError=exports.QuietHoursError=exports.DuplicateNotificationError=exports.UserNotFoundError=exports.ProviderError=exports.TemplateNotFoundError=exports.ChannelNotAvailableError=exports.NotificationError=void 0;class NotificationError extends Error{constructor(r){super(r);this.name="NotificationError";Error.captureStackTrace(this,this.constructor)}}exports.NotificationError=NotificationError;class ChannelNotAvailableError extends NotificationError{constructor(r){super(`Notification channel not available: ${r}`);this.name="ChannelNotAvailableError";this.channel=r}}exports.ChannelNotAvailableError=ChannelNotAvailableError;class TemplateNotFoundError extends NotificationError{constructor(r){super(`Notification template not found: ${r}`);this.name="TemplateNotFoundError";this.templateName=r}}exports.TemplateNotFoundError=TemplateNotFoundError;class ProviderError extends NotificationError{constructor(r,o){super(`Provider ${r} failed: ${o.message}`);this.name="ProviderError";this.provider=r;this.originalError=o}}exports.ProviderError=ProviderError;class UserNotFoundError extends NotificationError{constructor(r){super(`User not found: ${r}`);this.name="UserNotFoundError";this.userId=r}}exports.UserNotFoundError=UserNotFoundError;class DuplicateNotificationError extends NotificationError{constructor(r,o){super(`Duplicate notification detected: ${r} (existing: ${o})`);this.name="DuplicateNotificationError";this.idempotencyKey=r;this.existingNotificationId=o}}exports.DuplicateNotificationError=DuplicateNotificationError;class QuietHoursError extends NotificationError{constructor(r){super(`User ${r} is in quiet hours`);this.name="QuietHoursError";this.userId=r}}exports.QuietHoursError=QuietHoursError;class RateLimitError extends NotificationError{constructor(r,o){super(`Rate limit exceeded for ${r}. Retry after ${o} seconds`);this.name="RateLimitError";this.channel=r;this.retryAfter=o}}exports.RateLimitError=RateLimitError;class InvalidAmountError extends NotificationError{constructor(r,o){super(`Invalid amount ${r}: ${o}`);this.name="InvalidAmountError";this.amount=r}}exports.InvalidAmountError=InvalidAmountError;class InvalidConfigError extends NotificationError{constructor(r,o){super(`Invalid configuration for ${r}: ${o}`);this.name="InvalidConfigError";this.configKey=r}}exports.InvalidConfigError=InvalidConfigError;class RedisCacheError extends NotificationError{constructor(r,o){super(`Redis cache operation failed (${r}): ${o.message}`);this.name="RedisCacheError"}}exports.RedisCacheError=RedisCacheError;class TemplateRenderError extends NotificationError{constructor(r,o){super(`Template rendering failed for ${r}: ${o}`);this.name="TemplateRenderError";this.templateName=r}}exports.TemplateRenderError=TemplateRenderError;class NoContactMethodError extends NotificationError{constructor(r,o){super(`User ${r} has no valid contact method for channel ${o}`);this.name="NoContactMethodError";this.userId=r;this.channel=o}}exports.NoContactMethodError=NoContactMethodError;