"use strict";async function fetchFiatCurrencyPrices(){const e="fetchFiatCurrencyPrices",r=Date.now();(0,broadcast_1.broadcastStatus)(e,"running");(0,broadcast_1.broadcastLog)(e,"Starting fetch fiat currency prices");const a="USD",t=process.env.APP_FIAT_RATES_PROVIDER||"openexchangerates";(0,broadcast_1.broadcastLog)(e,`Using provider: ${t}, baseCurrency: ${a}`);try{switch(t.toLowerCase()){case"openexchangerates":(0,broadcast_1.broadcastLog)(e,"Fetching rates from OpenExchangeRates");await fetchOpenExchangeRates(a);break;case"exchangerate-api":(0,broadcast_1.broadcastLog)(e,"Fetching rates from ExchangeRate API");await fetchExchangeRateApi(a);break;default:throw(0,error_1.createError)({statusCode:500,message:`Unsupported fiat rates provider: ${t}`})}(0,broadcast_1.broadcastStatus)(e,"completed",{duration:Date.now()-r});(0,broadcast_1.broadcastLog)(e,"Fetch fiat currency prices completed","success")}catch(r){console_1.logger.error("CRON","fetchFiatCurrencyPrices failed",r);(0,broadcast_1.broadcastStatus)(e,"failed");(0,broadcast_1.broadcastLog)(e,`Fetch fiat currency prices failed: ${r.message}`,"error");console_1.logger.warn("CRON","Fiat currency prices update failed, but continuing normal operations")}}async function fetchOpenExchangeRates(e){const r="fetchOpenExchangeRates";(0,broadcast_1.broadcastLog)(r,`Starting OpenExchangeRates API call with baseCurrency: ${e}`);const a=`https://openexchangerates.org/api/latest.json?app_id=${process.env.APP_OPENEXCHANGERATES_APP_ID}&base=${e}`,t=`https://api.frankfurter.app/latest?from=${e}`;try{const e=await fetchWithTimeout(a,3e4);(0,broadcast_1.broadcastLog)(r,"Data fetched from OpenExchangeRates API");if(!e||!e.rates)throw(0,error_1.createError)({statusCode:500,message:"Invalid data format received from OpenExchangeRates API"});await updateRatesFromData(e.rates);(0,broadcast_1.broadcastLog)(r,"Rates updated from OpenExchangeRates data","success")}catch(e){console_1.logger.error("CRON","fetchOpenExchangeRates - OpenExchangeRates failed",e);(0,broadcast_1.broadcastLog)(r,`OpenExchangeRates API failed: ${e.message}`,"error");(0,broadcast_1.broadcastLog)(r,"Attempting fallback with Frankfurter API");try{const e=await fetchWithTimeout(t,3e4);(0,broadcast_1.broadcastLog)(r,"Data fetched from Frankfurter API");if(!e||!e.rates)throw(0,error_1.createError)({statusCode:500,message:"Invalid data format received from Frankfurter API"});await updateRatesFromData(e.rates);(0,broadcast_1.broadcastLog)(r,"Rates updated from Frankfurter API data","success")}catch(a){console_1.logger.error("CRON","fetchOpenExchangeRates - Frankfurter failed",a);(0,broadcast_1.broadcastLog)(r,`Fallback Frankfurter API failed: ${a.message}`,"error");console_1.logger.warn("CRON",`Both fiat API calls failed: ${e.message}, ${a.message}`);return}}}async function fetchExchangeRateApi(e){const r="fetchExchangeRateApi";(0,broadcast_1.broadcastLog)(r,`Starting ExchangeRate API call with baseCurrency: ${e}`);const a=process.env.APP_EXCHANGERATE_API_KEY;if(!a)throw(0,error_1.createError)({statusCode:500,message:"APP_EXCHANGERATE_API_KEY is not configured in environment variables"});const t=`https://v6.exchangerate-api.com/v6/${a}/latest/${e}`;try{const e=await fetchWithTimeout(t,3e4);(0,broadcast_1.broadcastLog)(r,"Data fetched from ExchangeRate API");if(!e||!e.conversion_rates)throw(0,error_1.createError)({statusCode:500,message:"Invalid data format received from ExchangeRate API"});await updateRatesFromData(e.conversion_rates);(0,broadcast_1.broadcastLog)(r,"Rates updated from ExchangeRate API data","success")}catch(e){console_1.logger.error("CRON","fetchExchangeRateApi failed",e);(0,broadcast_1.broadcastLog)(r,`ExchangeRate API call failed: ${e.message}`,"error");console_1.logger.warn("CRON",`ExchangeRate API failed: ${e.message}`);return}}async function fetchWithTimeout(e,r=5e3){const a=new AbortController,t=setTimeout(()=>a.abort(),r);try{const r=await fetch(e,{signal:a.signal});if(!r.ok)switch(r.status){case 401:throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Invalid API key."});case 403:throw(0,error_1.createError)({statusCode:403,message:"Forbidden: Access denied."});case 429:throw(0,error_1.createError)({statusCode:429,message:"Too Many Requests: Rate limit exceeded."});case 500:throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: The API is currently unavailable."});default:throw(0,error_1.createError)({statusCode:500,message:`Network response was not ok: ${r.statusText}`})}return await r.json()}finally{clearTimeout(t)}}async function updateRatesFromData(e){const r="updateRatesFromData";(0,broadcast_1.broadcastLog)(r,"Starting update of currency rates from fetched data");const a={},t=await redis.get("currencies");let s;if(t){try{s=JSON.parse(t)}catch(e){(0,broadcast_1.broadcastLog)(r,`Error parsing currencies data: ${e.message}`,"error");return}if(!Array.isArray(s)){(0,broadcast_1.broadcastLog)(r,"Currencies data is not an array","error");return}}else{(0,broadcast_1.broadcastLog)(r,"No currencies in Redis, fetching from database");try{const e=await db_1.models.currency.findAll({where:{status:!0},attributes:["id","code"]});if(!e||0===e.length){(0,broadcast_1.broadcastLog)(r,"No currencies found in database, skipping rate update","warning");return}s=e.map(e=>({id:e.code,code:e.code}));await redis.set("currencies",JSON.stringify(s),"EX",86400);(0,broadcast_1.broadcastLog)(r,`Cached ${s.length} currencies from database`)}catch(e){(0,broadcast_1.broadcastLog)(r,`Database fetch failed: ${e.message}`,"error");return}}for(const r of s)Object.prototype.hasOwnProperty.call(e,r.id)&&(a[r.id]=e[r.id]);(0,broadcast_1.broadcastLog)(r,`Updating rates for ${Object.keys(a).length} currencies`);await(0,utils_1.updateCurrencyRates)(a);(0,broadcast_1.broadcastLog)(r,"Currency rates updated in database","success");await(0,utils_1.cacheCurrencies)();(0,broadcast_1.broadcastLog)(r,"Currencies cached successfully","success")}async function cacheExchangeCurrencies(){const e="cacheExchangeCurrencies";(0,broadcast_1.broadcastLog)(e,"Caching exchange currencies");const r=await(0,index_get_1.getCurrencies)();await redis.set("exchangeCurrencies",JSON.stringify(r),"EX",1800);(0,broadcast_1.broadcastLog)(e,"Exchange currencies cached","success")}async function processCurrenciesPrices(){const e="processCurrenciesPrices";(0,broadcast_1.broadcastLog)(e,"Starting processCurrenciesPrices");let r=await(0,utils_2.loadBanStatus)();try{if(Date.now()<r){const a=r-Date.now();console_1.logger.info("CRON",`Waiting for ${(0,utils_2.formatWaitTime)(a)} until unblock time`);(0,broadcast_1.broadcastLog)(e,`Currently banned; waiting for ${(0,utils_2.formatWaitTime)(a)}`,"info");return}const a=await exchange_1.default.startExchange();if(!a){(0,broadcast_1.broadcastLog)(e,"Exchange instance not available; exiting","error");return}let t=[],s=[];try{t=await db_1.models.exchangeMarket.findAll({where:{status:!0},attributes:["currency","pair"]});(0,broadcast_1.broadcastLog)(e,`Fetched ${t.length} active market records`)}catch(r){console_1.logger.error("CRON","processCurrenciesPrices - fetch markets failed",r);(0,broadcast_1.broadcastLog)(e,`Error fetching market records: ${r.message}`,"error");throw r}try{s=await db_1.models.exchangeCurrency.findAll({attributes:["currency","id","price","status"]});(0,broadcast_1.broadcastLog)(e,`Fetched ${s.length} exchange currency records`)}catch(r){console_1.logger.error("CRON","processCurrenciesPrices - fetch currencies failed",r);(0,broadcast_1.broadcastLog)(e,`Error fetching currencies: ${r.message}`,"error");throw r}const c=t.map(e=>`${e.currency}/${e.pair}`);if(!c.length){const r=new Error("No market symbols found");console_1.logger.error("CRON","processCurrenciesPrices - market symbols",r);(0,broadcast_1.broadcastLog)(e,r.message,"error");throw r}(0,broadcast_1.broadcastLog)(e,`Market symbols: ${c.join(", ")}`);let o={};try{o=a.has.fetchLastPrices?await a.fetchLastPrices(c):await a.fetchTickers(c);(0,broadcast_1.broadcastLog)(e,"Fetched market data from exchange")}catch(a){const t=await(0,utils_2.handleExchangeError)(a,exchange_1.default);if("number"==typeof t){r=t;await(0,utils_2.saveBanStatus)(r);console_1.logger.warn("CRON",`Ban detected. Blocked until ${new Date(r).toLocaleString()}`);(0,broadcast_1.broadcastLog)(e,`Ban detected. Blocked until ${new Date(r).toLocaleString()}`,"error");return}console_1.logger.error("CRON","processCurrenciesPrices - fetch markets data failed",a);(0,broadcast_1.broadcastLog)(e,`Error fetching market data: ${a.message}`,"error");throw a}const n=Object.keys(o).filter(e=>e.endsWith("/USDT"));(0,broadcast_1.broadcastLog)(e,`Found ${n.length} USDT pairs in market data`);const i=n.map(r=>{const t=r.split("/")[0],c=o[r];let n;n=a.has.fetchLastPrices?c.price:c.last;if(!n||isNaN(parseFloat(String(n)))){console_1.logger.warn("CRON",`Invalid or missing price for symbol: ${r}, market data: ${JSON.stringify(c)}`);(0,broadcast_1.broadcastLog)(e,`Invalid or missing price for symbol: ${r}`,"warning");return null}const i=s.find(e=>e.currency===t);if(i){i.price=parseFloat(String(n));return i}return null}).filter(e=>null!==e),d=s.find(e=>"USDT"===e.currency);if(d){d.price=1;i.push(d)}(0,broadcast_1.broadcastLog)(e,`Prepared bulk update data for ${i.length} currencies`);try{await db_1.sequelize.transaction(async e=>{for(const r of i)await r.save({transaction:e})});(0,broadcast_1.broadcastLog)(e,"Bulk update of currency prices completed","success")}catch(r){console_1.logger.error("CRON","processCurrenciesPrices - update database failed",r);(0,broadcast_1.broadcastLog)(e,`Error updating database: ${r.message}`,"error");throw r}}catch(r){console_1.logger.error("CRON","processCurrenciesPrices failed",r);(0,broadcast_1.broadcastLog)(e,`processCurrenciesPrices failed: ${r.message}`,"error");throw r}}async function updateCurrencyPricesBulk(e){const r="updateCurrencyPricesBulk";(0,broadcast_1.broadcastLog)(r,`Starting bulk update for ${e.length} currency prices`);try{await db_1.sequelize.transaction(async r=>{for(const a of e)await db_1.models.exchangeCurrency.update({price:a.price},{where:{id:a.id},transaction:r})});(0,broadcast_1.broadcastLog)(r,"Bulk update of currency prices succeeded","success")}catch(e){console_1.logger.error("CRON","updateCurrencyPricesBulk failed",e);(0,broadcast_1.broadcastLog)(r,`Bulk update failed: ${e.message}`,"error");throw e}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.fetchFiatCurrencyPrices=fetchFiatCurrencyPrices;exports.cacheExchangeCurrencies=cacheExchangeCurrencies;exports.processCurrenciesPrices=processCurrenciesPrices;exports.updateCurrencyPricesBulk=updateCurrencyPricesBulk;const db_1=require("@b/db"),utils_1=require("@b/api/finance/currency/utils"),index_get_1=require("@b/api/exchange/currency/index.get"),exchange_1=__importDefault(require("@b/utils/exchange")),redis_1=require("@b/utils/redis"),utils_2=require("@b/api/exchange/utils"),broadcast_1=require("../broadcast"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),redis=redis_1.RedisSingleton.getInstance();