"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Creates a new support ticket",description:"Creates a new support ticket for the currently authenticated user",operationId:"createTicket",tags:["Support"],requiresAuth:!0,logModule:"USER",logTitle:"Create support ticket",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{subject:{type:"string",description:"Subject of the ticket"},message:{type:"string",description:"Content of the ticket"},importance:{type:"string",enum:["LOW","MEDIUM","HIGH"]},tags:{type:"array",items:{type:"string"},description:"Ticket tags (optional)"}},required:["subject","message","importance"]}}}},responses:(0,query_1.createRecordResponses)("Support Ticket")};exports.default=async e=>{const{body:t,user:r,ctx:s}=e;if(!(null==r?void 0:r.id)){null==s||s.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{subject:i,message:o,importance:a,tags:u}=t;null==s||s.step("Creating support ticket");const c=await db_1.models.supportTicket.create({userId:r.id,subject:i,messages:[{type:"client",text:o,time:(new Date).toISOString(),userId:r.id}],importance:a,status:"PENDING",type:"TICKET",tags:Array.isArray(u)?u:"string"==typeof u?u.split(",").map(e=>e.trim()):[]});null==s||s.success("Support ticket created successfully");return c.get({plain:!0})};