"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),Websocket_1=require("@b/handler/Websocket"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"End a live chat session",description:"Ends the live chat session and closes the ticket",operationId:"endLiveChat",tags:["Support"],requiresAuth:!0,logModule:"USER",logTitle:"End live chat",requestBody:{description:"Session to end",required:!0,content:{"application/json":{schema:{type:"object",properties:{sessionId:{type:"string"}},required:["sessionId"]}}}},responses:(0,query_1.updateRecordResponses)("Live Chat Session")};exports.default=async e=>{const{user:s,body:t,ctx:o}=e;if(!(null==s?void 0:s.id)){null==o||o.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{sessionId:r}=t;null==o||o.step("Finding live chat session");const i=await db_1.models.supportTicket.findOne({where:{id:r,userId:s.id,type:"LIVE"}});if(!i){null==o||o.fail("Live chat session not found");throw(0,error_1.createError)({statusCode:404,message:"Live chat session not found"})}null==o||o.step("Closing chat session");i.status="CLOSED";await i.save();null==o||o.step("Broadcasting session end via WebSocket");try{await(0,Websocket_1.handleBroadcastMessage)({type:"support-ticket",method:"update",id:r,data:i.get({plain:!0}),route:"/api/user/support/ticket"})}catch(e){console_1.logger.error("SUPPORT","Failed to broadcast session end",e)}null==o||o.success("Chat session ended successfully");return{success:!0,message:"Chat session ended successfully"}};