"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Registers a wallet address for the user",description:"Registers a wallet address for the authenticated user",operationId:"registerWallet",tags:["Auth"],requiresAuth:!0,logModule:"WALLET",logTitle:"Connect wallet",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{address:{type:"string",description:"Wallet address"},chainId:{type:"number",description:"Blockchain chain ID"}},required:["address","chainId"]}}}},responses:{200:{description:"Wallet address registered successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request (e.g., missing address or chainId)"},401:{description:"Unauthorized (e.g., user not authenticated)"},500:{description:"Internal server error"}}};exports.default=async e=>{const{body:r,user:s,ctx:t}=e,{address:a,chainId:d}=r;if(!(null==s?void 0:s.id)){null==t||t.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"})}if(!a||!d){null==t||t.fail("Address or chainId missing");throw(0,error_1.createError)({statusCode:400,message:"Address and chainId are required"})}try{null==t||t.step("Registering wallet address");const[e,r]=await db_1.models.providerUser.findOrCreate({where:{providerUserId:a,userId:s.id},defaults:{userId:s.id,providerUserId:a,provider:"WALLET"}});if(!r){null==t||t.warn("Wallet already registered");return{message:"Wallet already registered"}}null==t||t.success("Wallet connected successfully");return{message:"Wallet address registered successfully"}}catch(e){null==t||t.fail("Failed to connect wallet");throw(0,error_1.createError)({statusCode:500,message:"Internal server error"})}};