"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),utils_1=require("../../auth/utils"),console_1=require("@b/utils/console"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Resend Email Verification for Authenticated User",description:"Sends a verification email to the authenticated user's email address",operationId:"resendEmailVerificationAuth",tags:["User","Profile"],requiresAuth:!0,logModule:"USER",logTitle:"Resend email verification",responses:{200:{description:"Verification email sent successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Email already verified or invalid request"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:i,ctx:r}=e;if(!i){null==r||r.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"})}null==r||r.step("Retrieving user record");const t=await db_1.models.user.findByPk(i.id);if(!t){null==r||r.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}if(t.emailVerified){null==r||r.warn("Email already verified");return{message:"Email is already verified"}}null==r||r.step("Checking email verification configuration");const a=cache_1.CacheManager.getInstance();if(!("true"===await a.getSetting("verifyEmailStatus"))){null==r||r.fail("Email verification not enabled");throw(0,error_1.createError)({statusCode:400,message:"Email verification is not enabled on this platform"})}try{null==r||r.step("Sending verification email");await(0,utils_1.sendEmailVerificationToken)(t.id,t.email);null==r||r.success("Verification email sent successfully");return{message:"Verification email sent successfully. Please check your inbox."}}catch(e){console_1.logger.error("USER","Error sending verification email",e);null==r||r.fail("Failed to send verification email");throw(0,error_1.createError)({statusCode:500,message:"Failed to send verification email. Please try again later."})}};