"use strict";async function savePhoneQuery(e,t){await db_1.models.user.update({phone:t},{where:{id:e}});const r=await db_1.models.user.findOne({where:{id:e}});if(!r)throw(0,error_1.createError)({statusCode:404,message:"User not found"});return r.get({plain:!0})}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var o=Object.getOwnPropertyDescriptor(t,r);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,o)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),o=0;o<a.length;o++)"default"!==a[o]&&__createBinding(r,t,a[o]);__setModuleDefault(r,t);return r}}(),__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.savePhoneQuery=savePhoneQuery;const error_1=require("@b/utils/error"),db_1=require("@b/db"),otplib_1=require("otplib"),qrcode_1=__importDefault(require("qrcode")),query_1=require("@b/utils/query"),cache_1=require("@b/utils/cache"),APP_TWILIO_ACCOUNT_SID=process.env.APP_TWILIO_ACCOUNT_SID,APP_TWILIO_AUTH_TOKEN=process.env.APP_TWILIO_AUTH_TOKEN,APP_TWILIO_PHONE_NUMBER=process.env.APP_TWILIO_PHONE_NUMBER,NEXT_PUBLIC_SITE_NAME=process.env.NEXT_PUBLIC_SITE_NAME;exports.metadata={summary:"Generates an OTP secret and sends OTP via SMS or generates a QR code for OTP APP",description:"Generates an OTP secret and sends OTP via SMS or generates a QR code for OTP APP",operationId:"generateOTPSecret",tags:["Profile"],requiresAuth:!0,logModule:"USER",logTitle:"Generate OTP secret",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{type:{type:"string",description:"Type of OTP to generate",enum:["EMAIL","SMS","APP"]},phoneNumber:{type:"string",description:"Phone number to send the OTP to"},email:{type:"string",description:"Email to generate the QR code for OTP APP"}},required:["type"]}}}},responses:{200:{description:"OTP secret generated successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"boolean",description:"Indicates if the request was successful"},statusCode:{type:"number",description:"HTTP status code",example:200},data:{type:"object",properties:{secret:{type:"string",description:"OTP secret"},qrCode:{type:"string",description:"QR code for OTP APP"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("User"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!(null==t?void 0:t.id)){null==a||a.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{type:o,phoneNumber:s,email:n}=r;null==a||a.step("Generating OTP secret");const i=otplib_1.authenticator.generateSecret();try{const e=cache_1.CacheManager.getInstance();if("SMS"===o){null==a||a.step("Validating SMS 2FA configuration");if(!("true"===await e.getSetting("twoFactorSmsStatus"))){null==a||a.fail("SMS 2FA not enabled");throw(0,error_1.createError)({statusCode:400,message:"SMS 2FA is not enabled on this server"})}if(!APP_TWILIO_ACCOUNT_SID||!APP_TWILIO_AUTH_TOKEN||!APP_TWILIO_PHONE_NUMBER){null==a||a.fail("SMS service not configured");throw(0,error_1.createError)({statusCode:500,message:"SMS service is not properly configured"})}if(!s){null==a||a.fail("Phone number missing");throw(0,error_1.createError)({statusCode:400,message:"Phone number is required for SMS type"})}null==a||a.step("Saving phone number");await savePhoneQuery(t.id,s);null==a||a.step("Sending OTP via SMS");const r=otplib_1.authenticator.generate(i),o=(await Promise.resolve().then(()=>__importStar(require("twilio")))).default(APP_TWILIO_ACCOUNT_SID,APP_TWILIO_AUTH_TOKEN);await o.messages.create({body:`Your OTP is: ${r}`,from:APP_TWILIO_PHONE_NUMBER,to:s});null==a||a.success("OTP sent via SMS successfully");return{secret:i}}if("APP"===o){null==a||a.step("Validating APP 2FA configuration");if(!("true"===await e.getSetting("twoFactorAppStatus"))){null==a||a.fail("APP 2FA not enabled");throw(0,error_1.createError)({statusCode:400,message:"Authenticator app 2FA is not enabled on this server"})}null==a||a.step("Generating QR code");const r=otplib_1.authenticator.keyuri(n||t.email||"",NEXT_PUBLIC_SITE_NAME||"",i),o=await qrcode_1.default.toDataURL(r);null==a||a.success("QR code generated successfully");return{secret:i,qrCode:o}}if("EMAIL"===o){null==a||a.step("Validating EMAIL 2FA configuration");if(!("true"===await e.getSetting("twoFactorEmailStatus"))){null==a||a.fail("EMAIL 2FA not enabled");throw(0,error_1.createError)({statusCode:400,message:"Email 2FA is not enabled on this server"})}null==a||a.step("Generating QR code");const r=otplib_1.authenticator.keyuri(n||t.email||"",NEXT_PUBLIC_SITE_NAME||"",i),o=await qrcode_1.default.toDataURL(r);null==a||a.step("Sending OTP via email");const s=otplib_1.authenticator.generate(i),{emailQueue:u}=await Promise.resolve().then(()=>__importStar(require("@b/utils/emails")));await u.add({emailData:{TO:t.email,FIRSTNAME:t.firstName,TOKEN:s},emailType:"OTPTokenVerification"});null==a||a.success("OTP sent via email successfully");return{secret:i,qrCode:o}}null==a||a.fail("Invalid OTP type");throw(0,error_1.createError)({statusCode:400,message:"Invalid type. Must be EMAIL, SMS, or APP"})}catch(e){if(e.statusCode)throw e;null==a||a.fail(`Error generating OTP: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:e.message})}};