"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.updateUserQuery=exports.metadata=void 0;const error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),db_1=require("@b/db"),promises_1=require("fs/promises"),console_1=require("@b/utils/console");exports.metadata={summary:"Updates the profile of the current user",description:"Updates the profile of the currently authenticated user",operationId:"updateProfile",tags:["Auth"],requiresAuth:!0,logModule:"USER",logTitle:"Update profile",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{firstName:{type:"string",description:"First name of the user"},lastName:{type:"string",description:"Last name of the user"},metadata:{type:"object",description:"Metadata of the user"},avatar:{type:"string",description:"Avatar of the user",nullable:!0},phone:{type:"string",description:"Phone number of the user"},twoFactor:{type:"boolean",description:"Two-factor authentication status"},profile:{type:"object",nullable:!0,properties:{bio:{type:"string",description:"User bio",nullable:!0},location:{type:"object",nullable:!0,properties:{address:{type:"string",description:"User address",nullable:!0},city:{type:"string",description:"User city",nullable:!0},country:{type:"string",description:"User country",nullable:!0},zip:{type:"string",description:"User zip code",nullable:!0}}},social:{type:"object",nullable:!0,properties:{twitter:{type:"string",description:"Twitter profile",nullable:!0},dribbble:{type:"string",description:"Dribbble profile",nullable:!0},instagram:{type:"string",description:"Instagram profile",nullable:!0},github:{type:"string",description:"GitHub profile",nullable:!0},gitlab:{type:"string",description:"GitLab profile",nullable:!0},telegram:{type:"string",description:"Telegram username",nullable:!0}}}}},settings:{type:"object",description:"Notification settings for the user",properties:{email:{type:"boolean",description:"Email notifications enabled or disabled"},sms:{type:"boolean",description:"SMS notifications enabled or disabled"},push:{type:"boolean",description:"Push notifications enabled or disabled"}}}}}}}},responses:{200:{description:"User profile updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("User"),500:query_1.serverErrorResponse}};exports.default=async e=>{var t;const{user:r,body:s,ctx:i}=e;if(!r){null==i||i.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Authentication required to update profile"})}const{firstName:o,lastName:a,metadata:n,avatar:l,phone:p,twoFactor:u,profile:d,settings:c}=s;null==i||i.step("Updating user profile");const b=await(0,exports.updateUserQuery)(r.id,o,a,n,l,p,u,d,c,null!==(t=r.avatar)&&void 0!==t?t:void 0);null==i||i.success("Profile updated successfully");return b};const updateUserQuery=async(e,t,r,s,i,o,a,n,l,p)=>{const u={};void 0!==t&&(u.firstName=t);void 0!==r&&(u.lastName=r);void 0!==s&&(u.metadata=s);void 0!==i&&(u.avatar=i);void 0!==o&&(u.phone=o);void 0!==a&&(u.twoFactor=a);void 0!==n&&(u.profile=n);if(void 0!==l){const t="string"==typeof l?JSON.parse(l):l,r=await db_1.models.user.findByPk(e,{attributes:["settings"]}),s=(null==r?void 0:r.settings)||{};u.settings={...s,...t}}if(null===i&&p)try{await(0,promises_1.unlink)(p)}catch(e){console_1.logger.error("USER","Failed to unlink avatar",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to unlink avatar from server"})}await db_1.models.user.update(u,{where:{id:e}});return{message:"Profile updated successfully"}};exports.updateUserQuery=updateUserQuery;