"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.validateKycField=void 0;const validateKycField=(e,a)=>{if(e.required&&(null==a||""===a))return`${e.label} is required`;if(null==a||""===a)return null;if(e.validation){if("string"==typeof a){if(void 0!==e.validation.minLength&&a.length<e.validation.minLength)return`${e.label} must be at least ${e.validation.minLength} characters`;if(void 0!==e.validation.maxLength&&a.length>e.validation.maxLength)return`${e.label} must be at most ${e.validation.maxLength} characters`;if(e.validation.pattern){if(!new RegExp(e.validation.pattern).test(a))return e.validation.message||`${e.label} has an invalid format`}}if("number"==typeof a){if(void 0!==e.validation.min&&a<e.validation.min)return`${e.label} must be at least ${e.validation.min}`;if(void 0!==e.validation.max&&a>e.validation.max)return`${e.label} must be at most ${e.validation.max}`}}switch(e.type){case"TEXT":case"TEXTAREA":if("string"!=typeof a)return`${e.label} must be a string`;break;case"EMAIL":if("string"!=typeof a||!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(a))return`Please enter a valid email address for ${e.label}`;break;case"PHONE":if("string"!=typeof a||!/^\+?[0-9\s\-().]{7,}$/.test(a))return`Please enter a valid phone number for ${e.label}`;break;case"NUMBER":const t="string"==typeof a?parseFloat(a):a;if("number"!=typeof t||isNaN(t))return`${e.label} must be a valid number`;a=t;break;case"DATE":if("string"!=typeof a||isNaN(Date.parse(a)))return`${e.label} must be a valid date`;break;case"SELECT":case"RADIO":if("string"!=typeof a)return`${e.label} must be a string selection`;if(e.options&&!e.options.find(e=>e.value===a))return`${e.label} has an invalid selection`;break;case"CHECKBOX":if("boolean"!=typeof a)return`${e.label} must be a boolean`;break;case"IMAGE":case"FILE":if("string"!=typeof a)return`${e.label} must be a valid file URL`;break;case"ADDRESS":if("object"!=typeof a||Array.isArray(a))return`${e.label} must be an object with address details`;break;case"IDENTITY":if("object"!=typeof a||Array.isArray(a))return`${e.label} must be an object containing identity verification details`;if(!a.type)return`${e.label} must include a document type`;if(e.identityTypes&&Array.isArray(e.identityTypes)){const t=e.identityTypes.find(e=>e.value===a.type);if(!t)return`${e.label} has an invalid document type "${a.type}"`;for(const i of t.fields){if(i.required&&(void 0===a[i.id]||null===a[i.id]||""===a[i.id]))return`${e.label}: ${i.label} is required`;if("FILE"===i.type&&"string"!=typeof a[i.id])return`${e.label}: ${i.label} must be a valid file URL`}}}return null};exports.validateKycField=validateKycField;