"use strict";async function checkRateLimit(e){try{const t=redis_1.RedisSingleton.getInstance(),i=`kyc_rate_limit:${e}`,a=await t.get(i),r=3,o=60;if(a&&parseInt(a)>=r)throw(0,error_1.createError)({statusCode:429,message:`Too many KYC application attempts. Please wait ${o} minutes before trying again.`})}catch(e){if(429===e.statusCode)throw e;console_1.logger.error("KYC","Rate limiting check failed",e)}}async function updateRateLimit(e){try{const t=redis_1.RedisSingleton.getInstance(),i=`kyc_rate_limit:${e}`,a=60;await t.get(i)?await t.incr(i):await t.setex(i,60*a,1)}catch(e){console_1.logger.error("KYC","Rate limiting update failed",e)}}async function checkRejectionCooldown(e,t){const i=new Date(Date.now()-864e5),a=await db_1.models.kycApplication.findOne({where:{userId:e,levelId:t,status:"REJECTED",updatedAt:{[sequelize_1.Op.gte]:i}},order:[["updatedAt","DESC"]]});if(a){const e=Math.ceil((a.updatedAt.getTime()+864e5-Date.now())/36e5);throw(0,error_1.createError)({statusCode:429,message:`You must wait ${e} more hours before resubmitting after a rejection.`})}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),query_1=require("@b/utils/query"),utils_1=require("./utils"),redis_1=require("@b/utils/redis"),sequelize_1=require("sequelize");exports.metadata={summary:"Submit a KYC Application",description:"Submits a new KYC application for the authenticated user. Expects a JSON payload with a valid levelId and a 'fields' object containing key/value pairs for each field as defined in the KYC level configuration.",operationId:"submitKycApplication",tags:["KYC","Application"],requiresAuth:!0,logModule:"KYC",logTitle:"Submit KYC application",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{levelId:{type:"string",description:"ID of the KYC level for this application"},fields:{type:"object",description:"An object where keys are field IDs and values are the submitted data"}},required:["levelId","fields"]}}}},responses:{200:{description:"KYC application submitted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},application:{type:"object"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("KYC Level"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,body:i,ctx:a}=e;if(!t)throw(0,error_1.createError)({statusCode:401,message:"Authentication required"});null==a||a.step("Validating request parameters");const{levelId:r,fields:o}=i;if(!r||!o||"object"!=typeof o){null==a||a.fail("Invalid request parameters");throw(0,error_1.createError)({statusCode:400,message:"Missing or invalid required fields: levelId and fields"})}null==a||a.step("Checking rate limits");await checkRateLimit(t.id);null==a||a.step("Checking for existing KYC applications");const s=await db_1.models.kycApplication.findOne({where:{userId:t.id,levelId:r,status:{[sequelize_1.Op.in]:["PENDING","APPROVED","ADDITIONAL_INFO_REQUIRED"]}}});if(s){const e={PENDING:"You already have a pending application for this KYC level. Please wait for review.",APPROVED:"You already have an approved application for this KYC level.",ADDITIONAL_INFO_REQUIRED:"You have an existing application requiring additional information. Please update it instead of creating a new one."};null==a||a.fail(`Duplicate application detected with status: ${s.status}`);throw(0,error_1.createError)({statusCode:409,message:e[s.status]||"You already have an application for this KYC level."})}null==a||a.step("Checking rejection cooldown period");await checkRejectionCooldown(t.id,r);null==a||a.step("Retrieving KYC level configuration");const l=await db_1.models.kycLevel.findByPk(r);if(!l){null==a||a.fail("KYC level not found");throw(0,error_1.createError)({statusCode:404,message:"KYC level not found"})}null==a||a.step("Validating KYC level status");if("ACTIVE"!==l.status){null==a||a.fail("KYC level is not active");throw(0,error_1.createError)({statusCode:400,message:"This KYC level is not currently available for applications"})}null==a||a.step("Parsing KYC level field configuration");let n=l.fields;if("string"==typeof n)try{n=JSON.parse(n)}catch(e){null==a||a.fail("Failed to parse KYC level configuration");throw(0,error_1.createError)({statusCode:500,message:"Invalid KYC level configuration: unable to parse fields"})}if(!Array.isArray(n)){null==a||a.fail("Invalid KYC level configuration format");throw(0,error_1.createError)({statusCode:500,message:"Invalid KYC level configuration"})}null==a||a.step(`Validating ${n.length} submitted fields`);for(const e of n){const t=o[e.id],i=(0,utils_1.validateKycField)(e,t);if(i){null==a||a.fail(`Field validation failed for: ${e.id}`);throw(0,error_1.createError)({statusCode:400,message:`Validation error for field "${e.id}": ${i}`})}}try{null==a||a.step("Creating KYC application record");const e=await db_1.models.kycApplication.create({userId:t.id,levelId:r,data:o,status:"PENDING"});null==a||a.step("Updating rate limit counter");await updateRateLimit(t.id);null==a||a.success("KYC application submitted successfully");return{message:"KYC application submitted successfully.",application:e}}catch(e){null==a||a.fail(`Failed to create application: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:e.message||"Internal Server Error."})}};