"use strict";async function getKyc(e){const t=await db_1.models.kycApplication.findAll({where:{userId:e},include:[{model:db_1.models.kycLevel,as:"level",paranoid:!1},{model:db_1.models.kycVerificationResult,as:"verificationResult"}]});if(0===t.length)throw(0,error_1.createError)({statusCode:404,message:"KYC records not found"});return t.map(e=>e.get({plain:!0}))}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.getKyc=getKyc;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query");exports.metadata={summary:"Retrieves all KYC applications for the logged-in user",description:"Fetches all Know Your Customer (KYC) applications for the currently authenticated user. This endpoint requires user authentication and returns an array with the user's KYC application information, including the verification status and other details.",operationId:"getUserKycApplications",tags:["KYC"],logModule:"USER",logTitle:"List KYC applications",responses:{200:{description:"KYC applications retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"number",description:"KYC ID"},userId:{type:"number",description:"User ID associated with the KYC record"},templateId:{type:"number",description:"ID of the KYC template used"},data:{type:"object",description:"KYC data as a JSON object",nullable:!0},status:{type:"string",description:"Current status of the KYC verification",enum:["PENDING","APPROVED","REJECTED"]},level:{type:"number",description:"Verification level"},notes:{type:"string",description:"Administrative notes, if any",nullable:!0},createdAt:{type:"string",format:"date-time",description:"Timestamp when the KYC record was created"},updatedAt:{type:"string",format:"date-time",description:"Timestamp when the KYC record was last updated"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Kyc"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id)){null==r||r.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==r||r.step("Retrieving KYC applications");const i=await getKyc(t.id);null==r||r.success(`Retrieved ${i.length} KYC applications`);return i};