"use strict";function generateFileUrl(e){return`/uploads/${e}`}async function ensureDirExists(e){try{await promises_1.default.access(e)}catch(r){if("ENOENT"!==r.code)throw r;await promises_1.default.mkdir(e,{recursive:!0})}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),heic_convert_1=__importDefault(require("heic-convert")),promises_1=__importDefault(require("fs/promises")),path_1=__importDefault(require("path")),validation_1=require("@b/utils/validation"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"Converts a HEIC image to JPEG format",description:"Converts a HEIC image to JPEG format and returns the file URL",operationId:"convertHeicFile",tags:["Conversion"],logModule:"UPLOAD",logTitle:"Convert HEIC image",requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{dir:{type:"string",description:"Directory to save the converted file"},file:{type:"string",description:"Base64 encoded HEIC file data"},mimeType:{type:"string",description:"MIME type of the file"}},required:["dir","file","mimeType"]}}}},responses:{200:{description:"File converted successfully",content:{"application/json":{schema:{type:"object",properties:{url:{type:"string",description:"URL of the converted file"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Conversion"),500:query_1.serverErrorResponse}};const isProduction="production"===process.env.NODE_ENV,BASE_CONVERT_DIR=isProduction?path_1.default.join(process.cwd(),"frontend","public","uploads"):path_1.default.join(process.cwd(),"..","frontend","public","uploads");exports.default=async e=>{const{body:r,user:t,ctx:o}=e;if(!t)throw(0,error_1.createError)({statusCode:401,message:"User not found"});const{dir:i,file:s,mimeType:a}=r;null==o||o.step("Validating HEIC conversion request");if(!i||!s||!a)throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: dir, file, or mimeType"});if("string"!=typeof i||i.length>100)throw(0,error_1.createError)({statusCode:400,message:"Invalid directory path"});if(i.includes("\0")||i.includes("%00")||i.includes(".."))throw(0,error_1.createError)({statusCode:400,message:"Invalid directory path"});if("string"!=typeof s||!s.startsWith("data:"))throw(0,error_1.createError)({statusCode:400,message:"Invalid file format"});if("string"!=typeof a||!a.includes("heic")&&!a.includes("heif"))throw(0,error_1.createError)({statusCode:400,message:"Unsupported file format. Only HEIC or HEIF files are allowed."});const n=s.split(",")[1];if(!n)throw(0,error_1.createError)({statusCode:400,message:"Invalid file data"});if(3*n.length/4>10485760)throw(0,error_1.createError)({statusCode:400,message:"File size exceeds maximum limit of 10MB"});const l=Buffer.from(n,"base64");null==o||o.step("Preparing upload directory");const u=(0,validation_1.sanitizeUserPath)(i.replace(/-/g,"/")),c=path_1.default.join(BASE_CONVERT_DIR,u),d=path_1.default.resolve(c),p=path_1.default.resolve(BASE_CONVERT_DIR);if(!d.startsWith(p+path_1.default.sep)&&d!==p)throw(0,error_1.createError)({statusCode:400,message:"Invalid upload directory"});await ensureDirExists(c);const f=`${Date.now()}-${Math.round(1e9*Math.random())}.jpg`,_=path_1.default.join(c,f);null==o||o.step("Converting HEIC to JPEG");try{const e=await(0,heic_convert_1.default)({buffer:l,format:"JPEG",quality:.8});await promises_1.default.writeFile(_,e);null==o||o.success(`HEIC converted to JPEG: ${u}/${f}`);return{url:generateFileUrl(`${u}/${f}`)}}catch(e){console_1.logger.error("UPLOAD","Error converting HEIC to JPEG using heic-convert",e);null==o||o.fail("HEIC to JPEG conversion failed");throw(0,error_1.createError)({statusCode:500,message:"HEIC to JPEG conversion failed using `heic-convert`."})}};