"use strict";function getCachedPrice(e,t){const a=`${e}-${t}`,r=priceCache.get(a);if(!r)return null;if(Date.now()-r.timestamp>3e5){priceCache.delete(a);return null}return r.price}function setCachedPrice(e,t,a){const r=`${e}-${t}`;priceCache.set(r,{price:a,timestamp:Date.now()})}function isCurrencyFailureCached(e,t){const a=`${e}-${t}`,r=failedPriceCache.get(a);if(!r)return!1;if(Date.now()-r>36e5){failedPriceCache.delete(a);return!1}return!0}function cacheCurrencyFailure(e,t){const a=`${e}-${t}`;failedPriceCache.set(a,Date.now())}async function fetchPriceWithCache(e,t){const a=getCachedPrice(e,t);if(null!==a)return a;if(isCurrencyFailureCached(e,t))return 0;try{let a=0;"FIAT"===t?a=await(0,utils_1.getFiatPriceInUSD)(e):"SPOT"===t||"FUTURES"===t?a=await(0,utils_1.getSpotPriceInUSD)(e):"ECO"===t&&(a=await(0,utils_1.getEcoPriceInUSD)(e));setCachedPrice(e,t,a);return a}catch(a){cacheCurrencyFailure(e,t);console_1.logger.debug("WALLET",`Price unavailable for ${e}/${t} - using $0 (cached 1h)`);return 0}}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("@b/api/finance/currency/utils"),console_1=require("@b/utils/console"),priceCache=new Map,PRICE_CACHE_DURATION=3e5,failedPriceCache=new Map,FAILURE_CACHE_DURATION=36e5;exports.metadata={summary:"Get wallet statistics including total balance, changes, and counts",operationId:"getWalletStats",tags:["Finance","Wallets","Statistics"],responses:{200:{description:"Wallet statistics retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{totalBalance:{type:"number",description:"Total balance across all wallets in USD equivalent"},totalChange:{type:"number",description:"24h change in USD"},totalChangePercent:{type:"number",description:"24h change percentage"},totalWallets:{type:"number",description:"Total number of wallets"},activeWallets:{type:"number",description:"Number of wallets with balance > 0"},walletsByType:{type:"object",properties:{FIAT:{type:"object",properties:{count:{type:"number"},balance:{type:"number"},balanceUSD:{type:"number"}}},SPOT:{type:"object",properties:{count:{type:"number"},balance:{type:"number"},balanceUSD:{type:"number"}}},ECO:{type:"object",properties:{count:{type:"number"},balance:{type:"number"},balanceUSD:{type:"number"}}},FUTURES:{type:"object",properties:{count:{type:"number"},balance:{type:"number"},balanceUSD:{type:"number"}}}}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t,a,r,n;const{user:c,ctx:l}=e;if(!(null==c?void 0:c.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==l||l.step("Calculating wallet statistics");const[e,s]=await Promise.all([db_1.models.wallet.findAll({where:{userId:c.id},attributes:["id","type","currency","balance","inOrder","status","createdAt","updatedAt"]}),db_1.models.transaction.findAll({where:{userId:c.id,type:"DEPOSIT",status:"PENDING"},attributes:["walletId","amount","fee"]})]);let i=0;const o={FIAT:{count:0,balance:0,balanceUSD:0},SPOT:{count:0,balance:0,balanceUSD:0},ECO:{count:0,balance:0,balanceUSD:0},FUTURES:{count:0,balance:0,balanceUSD:0}};let u=0;const d=new Map;for(const e of s){const t=(parseFloat(e.amount)||0)-(parseFloat(e.fee)||0),a=d.get(e.walletId)||0;d.set(e.walletId,a+t)}const p=new Map;for(const t of e){const e=t.type||"SPOT",a=`${t.currency}-${e}`;p.has(a)||p.set(a,{currency:t.currency,type:e})}const b=Array.from(p.values()).map(async({currency:e,type:t})=>({key:`${e}-${t}`,price:await fetchPriceWithCache(e,t)})),y=await Promise.all(b),f=new Map;for(const{key:e,price:t}of y)f.set(e,t);for(const t of e){const e=parseFloat(t.balance)||0,a=parseFloat(t.inOrder)||0,r=e+a+(d.get(t.id)||0),n=t.type||"SPOT";r>0&&u++;o[n]||(o[n]={count:0,balance:0,balanceUSD:0});o[n].count++;o[n].balance+=r;const c=r*(f.get(`${t.currency}-${n}`)||0);o[n].balanceUSD+=c;i+=c}const h=(0,date_fns_1.subDays)(new Date,1);h.setHours(0,0,0,0);const m=await db_1.models.walletPnl.findOne({where:{userId:c.id,createdAt:{[sequelize_1.Op.gte]:h,[sequelize_1.Op.lt]:new Date(h.getTime()+864e5)}},order:[["createdAt","DESC"]]});let w=0,S=0;if(m&&m.balances){const e=Object.values(m.balances).reduce((e,t)=>e+("number"==typeof t?t:parseFloat(String(t))||0),0);if(e>0){w=i-e;S=w/e*100}}const C=new Date;C.setHours(0,0,0,0);const g={FIAT:(null===(t=o.FIAT)||void 0===t?void 0:t.balanceUSD)||0,SPOT:(null===(a=o.SPOT)||void 0===a?void 0:a.balanceUSD)||0,ECO:(null===(r=o.ECO)||void 0===r?void 0:r.balanceUSD)||0,FUTURES:(null===(n=o.FUTURES)||void 0===n?void 0:n.balanceUSD)||0},U=await db_1.models.walletPnl.findOne({where:{userId:c.id,createdAt:{[sequelize_1.Op.gte]:C}}});U?await U.update({balances:g}):await db_1.models.walletPnl.create({userId:c.id,balances:g,createdAt:C});null==l||l.success("Wallet statistics calculated successfully");return{totalBalance:parseFloat(i.toFixed(2)),totalChange:parseFloat(w.toFixed(2)),totalChangePercent:parseFloat(S.toFixed(2)),totalWallets:e.length,activeWallets:u,walletsByType:Object.fromEntries(Object.entries(o).map(([e,t])=>[e,{count:t.count,balance:parseFloat(t.balance.toFixed(8)),balanceUSD:parseFloat(t.balanceUSD.toFixed(2))}]))}}catch(e){console_1.logger.error("WALLET","Error calculating wallet stats",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to calculate wallet statistics"})}};