"use strict";async function getMatchingEngine(){try{return(await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/ecosystem/utils/matchingEngine")))).MatchingEngine.getInstance()}catch(e){return{getTickers:async()=>({})}}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,a,r){void 0===r&&(r=a);var n=Object.getOwnPropertyDescriptor(t,a);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[a]}});Object.defineProperty(e,r,n)}:function(e,t,a,r){void 0===r&&(r=a);e[r]=t[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[t.length]=a);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var a={};if(null!=t)for(var r=e(t),n=0;n<r.length;n++)"default"!==r[n]&&__createBinding(a,t,r[n]);__setModuleDefault(a,t);return a}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("@b/api/admin/finance/wallet/utils"),error_1=require("@b/utils/error"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Lists all wallets with optional filters",operationId:"listWallets",tags:["Finance","Wallets"],parameters:[...constants_1.crudParameters,{name:"pnl",in:"query",description:"Fetch PnL data for the last 28 days",schema:{type:"boolean"}}],responses:{200:{description:"List of wallets with pagination metadata",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.walletSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Wallets"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{query:t,user:a,ctx:r}=e;if(!(null==a?void 0:a.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{walletType:n,sortOrder:s,...i}=t,{pnl:l}=t;if(l){null==r||r.step("Calculating wallet PnL");const e=await handlePnl(a);null==r||r.success("Wallet PnL calculated successfully");return e}null==r||r.step("Fetching user wallets");const c=cache_1.CacheManager.getInstance(),d=await c.getSetting("spotWallets"),o=!0===d||"true"===d,u={userId:a.id};n?u.type=n:o||(u.type={[sequelize_1.Op.ne]:"SPOT"});const{items:y,pagination:_}=await(0,query_1.getFiltered)({model:db_1.models.wallet,query:{...i,sortOrder:s||"asc"},where:u,sortField:i.sortField||"currency",numericFields:["balance","inOrder"],paranoid:!1}),p=y.filter(e=>"ECO"===e.type),f=Array.from(new Set(p.map(e=>e.currency)));if(f.length>0){const e=await db_1.models.ecosystemToken.findAll({where:{currency:f}}),t=new Map(e.map(e=>[e.currency,e.icon]));p.forEach(e=>{e.icon=t.get(e.currency)||null})}null==r||r.success(`Retrieved ${y.length} wallets`);return{items:y,pagination:_}};const handlePnl=async e=>{const t=await db_1.models.wallet.findAll({where:{userId:e.id}}),a=new Date;a.setHours(0,0,0,0);const[r,n]=await Promise.all([db_1.models.currency.findAll({where:{id:Array.from(new Set(t.map(e=>e.currency)))}}),db_1.models.exchangeCurrency.findAll({where:{currency:Array.from(new Set(t.map(e=>e.currency)))}})]),s=new Map(r.map(e=>[e.id,e.price])),i=new Map(n.map(e=>[e.currency,e.price])),l=await getMatchingEngine(),c=await l.getTickers(),d={FIAT:0,SPOT:0,ECO:0};t.forEach(e=>{var t;let a;"FIAT"===e.type?a=s.get(e.currency)||1:"SPOT"!==e.type&&"ECO"!==e.type||(a=i.get(e.currency)||(null===(t=c[e.currency])||void 0===t?void 0:t.last)||0);a&&(d[e.type]+=a*e.balance)});const o=await db_1.models.walletPnl.findOne({where:{userId:e.id,createdAt:{[sequelize_1.Op.gte]:a}}});o?await o.update({balances:d}):await db_1.models.walletPnl.create({userId:e.id,balances:d,createdAt:a});const u=(0,date_fns_1.add)(a,{days:-28}),y=await db_1.models.walletPnl.findAll({where:{userId:e.id,createdAt:{[sequelize_1.Op.between]:[u,a]}},attributes:["balances","createdAt"],order:[["createdAt","ASC"]]}),_=y.reduce((e,t)=>{const a=(0,date_fns_1.format)(t.createdAt,"yyyy-MM-dd");e[a]||(e[a]={FIAT:0,SPOT:0,FUNDING:0});e[a].FIAT+=t.balances.FIAT||0;e[a].SPOT+=t.balances.SPOT||0;e[a].FUNDING+=t.balances.ECO||0;return e},{}),p=[];for(let e=(0,date_fns_1.add)(u,{days:-u.getDay()});e<a;e=(0,date_fns_1.add)(e,{weeks:1})){const t=(0,date_fns_1.add)(e,{days:6});let a=0,r=0,n=0;for(let s=e;s<=t;s=(0,date_fns_1.add)(s,{days:1})){const e=(0,date_fns_1.format)(s,"yyyy-MM-dd");if(_[e]){a+=_[e].FIAT;r+=_[e].SPOT;n+=_[e].FUNDING}}p.push({date:(0,date_fns_1.format)(e,"yyyy-MM-dd"),FIAT:a,SPOT:r,FUNDING:n})}const f=(0,date_fns_1.add)(a,{days:-1}),m=y.find(e=>(0,date_fns_1.format)(e.createdAt,"yyyy-MM-dd")===(0,date_fns_1.format)(f,"yyyy-MM-dd")),w=sumBalances(d),h=m?sumBalances(m.balances):0;return{today:w,yesterday:h,pnl:((e,t)=>e-t-0-0)(w,h),chart:p}},sumBalances=e=>Object.values(e).reduce((e,t)=>e+t,0);