"use strict";async function updatePrivateLedger(e,r,t,a,n,o){await wallet_1.ledgerService.updateLedger({walletId:e,index:r,currency:t,chain:a,amount:n,transaction:o})}async function getCurrencyData(e,r){switch(e){case"FIAT":return await db_1.models.currency.findOne({where:{id:r}});case"SPOT":return await db_1.models.exchangeCurrency.findOne({where:{currency:r}});case"ECO":case"FUTURES":return await db_1.models.ecosystemToken.findOne({where:{currency:r}})}}function calculateTransferFee(e,r){return e*r/100}function requiresPrivateLedgerUpdate(e,r,t){return"client"===e&&("ECO"===r||"ECO"===t)||"ECO"===r&&"FUTURES"===t||"FUTURES"===r&&"ECO"===t}async function updateWalletBalances(e,r,t,a,n,o,s){const c=await wallet_1.walletService.debit({idempotencyKey:`${s}_from`,userId:e.userId,walletId:e.id,walletType:e.type,currency:e.currency,amount:t,operationType:"OUTGOING_TRANSFER",description:`Transfer to wallet ${r.id}`,relatedWalletId:r.id,metadata:{targetWalletId:r.id,targetUserId:r.userId,targetAmount:a},transaction:o}),i=await wallet_1.walletService.credit({idempotencyKey:`${s}_to`,userId:r.userId,walletId:r.id,walletType:r.type,currency:r.currency,amount:a,operationType:"INCOMING_TRANSFER",description:`Transfer from wallet ${e.id}`,relatedWalletId:e.id,metadata:{sourceWalletId:e.id,sourceUserId:e.userId,sourceAmount:t},transaction:o});return{fromTransactionId:c.transactionId,toTransactionId:i.transactionId}}function calculateNewBalance(e,r,t){const a=isNaN(e)?0:e,n=isNaN(r)?0:r;let o,s=8;"number"==typeof t&&t>=0&&t<=18?s=Math.floor(t):t&&"object"==typeof t&&"number"==typeof t.precision&&(s=Math.floor(t.precision));o=n>=0?(0,wallet_1.safeAdd)(a,n,"DEFAULT"):(0,wallet_1.safeSubtract)(a,Math.abs(n),"DEFAULT");const c=Math.max(0,o);return parseFloat(c.toFixed(s))}function getSortedChainBalances(e){return Object.entries(e).filter(([e,r])=>r.balance>0).sort(([,e],[,r])=>r.balance-e.balance)}async function recordAdminProfit({userId:e,transferFeeAmount:r,fromCurrency:t,fromType:a,toType:n,transactionId:o,t:s}){await db_1.models.adminProfit.create({amount:r,currency:t,type:"TRANSFER",transactionId:o,description:`Transfer fee for user (${e}) of ${r} ${t} from ${a} to ${n}`},{transaction:s})}async function createTransferTransaction(e,r,t,a,n,o,s,c,i,l,d,u){return await db_1.models.transaction.create({userId:e,walletId:r,type:t,amount:a,fee:n,status:d,metadata:JSON.stringify({fromWallet:c,toWallet:i,fromCurrency:o,toCurrency:s}),description:l},{transaction:u})}async function sendTransferEmails(e,r,t,a,n,o){try{await(0,emails_1.sendOutgoingTransferEmail)(e,r,t,n,o.fromTransfer.id);await(0,emails_1.sendIncomingTransferEmail)(r,e,a,n,o.toTransfer.id)}catch(e){console_1.logger.error("FINANCE","Error sending transfer email",e)}}async function performTransfer(e,r,t,a,n,o,s=0,c,i){const l=await wallet_1.walletService.transfer({idempotencyKey:i,fromUserId:e,toUserId:r,fromWalletType:t,toWalletType:a,fromCurrency:n,toCurrency:n,amount:o,feePercentage:s,description:c});return{fromWallet:{id:l.fromResult.walletId,balance:l.fromResult.newBalance,inOrder:l.fromResult.newInOrder},toWallet:{id:l.toResult.walletId,balance:l.toResult.newBalance,inOrder:l.toResult.newInOrder},fee:l.fee,fromTransactionId:l.fromResult.transactionId,toTransactionId:l.toResult.transactionId}}Object.defineProperty(exports,"__esModule",{value:!0});exports.updatePrivateLedger=updatePrivateLedger;exports.getCurrencyData=getCurrencyData;exports.calculateTransferFee=calculateTransferFee;exports.requiresPrivateLedgerUpdate=requiresPrivateLedgerUpdate;exports.updateWalletBalances=updateWalletBalances;exports.calculateNewBalance=calculateNewBalance;exports.getSortedChainBalances=getSortedChainBalances;exports.recordAdminProfit=recordAdminProfit;exports.createTransferTransaction=createTransferTransaction;exports.sendTransferEmails=sendTransferEmails;exports.performTransfer=performTransfer;const db_1=require("@b/db"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet");