"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet"),utils_1=require("./utils");exports.metadata={summary:"Verifies a Paytm payment",description:"Handles return URL verification after payment completion and updates transaction status",operationId:"verifyPaytmPayment",tags:["Finance","Deposit","Paytm"],requiresAuth:!0,logModule:"PAYTM_DEPOSIT",logTitle:"Verify Paytm payment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{orderId:{type:"string",description:"Paytm order ID"},txnId:{type:"string",description:"Paytm transaction ID"},checksumHash:{type:"string",description:"Checksum hash for verification"},status:{type:"string",description:"Transaction status from Paytm"}},required:["orderId"]}}}},responses:{200:{description:"Payment verification completed",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},order_id:{type:"string"},txn_id:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},payment_mode:{type:"string"},bank_name:{type:"string"},verified_at:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters or verification failed"},401:{description:"Unauthorized"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,body:a}=e,{orderId:r,txnId:n,checksumHash:s,status:i}=a;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!r)throw(0,error_1.createError)({statusCode:400,message:"Order ID is required"});try{(0,utils_1.validatePaytmConfig)();const e=await db_1.models.transaction.findOne({where:{uuid:r,userId:t.id,type:"DEPOSIT"}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const n=JSON.parse(e.metadata||"{}");if("paytm"!==n.gateway)throw(0,error_1.createError)({statusCode:400,message:"Invalid gateway for this transaction"});if("COMPLETED"===e.status)return{success:!0,data:{transaction_id:e.uuid,order_id:r,txn_id:n.txnId||"",status:"COMPLETED",amount:e.amount,currency:n.currency||"INR",gateway:"paytm",payment_mode:n.paymentMode||"",bank_name:n.bankName||"",verified_at:e.updatedAt}};if(s){const{checksumHash:e,...t}=a;if(!(0,utils_1.verifyChecksumHash)(t,s,utils_1.PAYTM_CONFIG.MERCHANT_KEY))throw(0,error_1.createError)({statusCode:400,message:"Invalid checksum verification"})}const i={body:{mid:utils_1.PAYTM_CONFIG.MID,orderId:r}},o=(0,utils_1.verifyChecksumHash)(i.body,"",utils_1.PAYTM_CONFIG.MERCHANT_KEY);i.body.checksumHash=o;const d=await(0,utils_1.makePaytmRequest)("/merchant-status/api/v1/getPaymentStatus",{method:"POST",body:i,headers:{"Content-Type":"application/json"}}),y=d.body.resultInfo.resultStatus,c=(0,utils_1.mapPaytmStatus)(y),u=(0,utils_1.parsePaytmAmount)(d.body.txnAmount||"0",n.currency||"INR");await e.update({status:c,referenceId:d.body.txnId||e.referenceId,metadata:JSON.stringify({...n,txnId:d.body.txnId,bankTxnId:d.body.bankTxnId,paymentMode:d.body.paymentMode,bankName:d.body.bankName,gatewayName:d.body.gatewayName,paytmVerifyResponse:d.body,verifiedAt:(new Date).toISOString()})});if("COMPLETED"===c){const a=n.currency||"INR",s=await wallet_1.walletCreationService.getOrCreateWallet(t.id,"FIAT",a),i=`paytm_deposit_${r}`,o=await wallet_1.walletService.credit({idempotencyKey:i,userId:t.id,walletId:s.id,walletType:"FIAT",currency:a,amount:u,operationType:"DEPOSIT",referenceId:e.uuid,description:`Paytm deposit - ${d.body.txnId||r}`,metadata:{gateway:"paytm",txnId:d.body.txnId,bankTxnId:d.body.bankTxnId,paymentMode:d.body.paymentMode,bankName:d.body.bankName}});try{await(0,emails_1.sendFiatTransactionEmail)(t,e,a,o.newBalance)}catch(e){console_1.logger.error("PAYTM","Failed to send confirmation email",e)}}return{success:!0,data:{transaction_id:e.uuid,order_id:r,txn_id:d.body.txnId||"",status:c,amount:u,currency:n.currency||"INR",gateway:"paytm",payment_mode:d.body.paymentMode||"",bank_name:d.body.bankName||"",gateway_name:d.body.gatewayName||"",bank_txn_id:d.body.bankTxnId||"",verified_at:(new Date).toISOString()}}}catch(e){if(e instanceof utils_1.PaytmError)throw(0,error_1.createError)({statusCode:e.status,message:e.message});throw(0,error_1.createError)({statusCode:500,message:"Failed to verify Paytm payment"})}};