"use strict";function validatePaytmConfig(){if(!exports.PAYTM_CONFIG.MID)throw new PaytmError("Paytm MID is not configured","CONFIG_ERROR",500);if(!exports.PAYTM_CONFIG.MERCHANT_KEY)throw new PaytmError("Paytm Merchant Key is not configured","CONFIG_ERROR",500)}function isCurrencySupported(e){return Object.keys(exports.PAYTM_CURRENCY_REGIONS).includes(e.toUpperCase())}function getCurrencyInfo(e){const t=e.toUpperCase();return exports.PAYTM_CURRENCY_REGIONS[t]||null}function getAvailablePaymentMethods(e){const t=getCurrencyInfo(e);return t?t.methods:[]}function formatPaytmAmount(e,t){const r=exports.PAYTM_CURRENCY_DECIMALS[t.toUpperCase()]||2;return e.toFixed(r)}function parsePaytmAmount(e){return parseFloat(e)}function mapPaytmStatus(e){return exports.PAYTM_STATUS_MAPPING[e]||"PENDING"}function generatePaytmOrderId(){return`PAYTM_${Date.now().toString()}_${Math.random().toString(36).substring(2,8).toUpperCase()}`}function generateChecksumHash(e,t){const r=Object.keys(e).sort().reduce((t,r)=>{null!==e[r]&&void 0!==e[r]&&""!==e[r]&&(t[r]=e[r]);return t},{}),n=Object.keys(r).map(e=>`${e}=${r[e]}`).join("&"),a=crypto_1.default.createHash("md5").update(t).digest(),i=Buffer.alloc(16),o=crypto_1.default.createCipheriv("aes-128-cbc",a,i);let c=o.update(n,"utf8","base64");c+=o.final("base64");const s=crypto_1.default.createHash("sha256");s.update(c+t);return s.digest("hex")}function verifyChecksumHash(e,t,r){const{checksumhash:n,...a}=e;return generateChecksumHash(a,r)===t}async function makePaytmRequest(e,t={}){var r,n;const{method:a="POST",body:i,headers:o={}}=t;try{const t=`${exports.PAYTM_CONFIG.API_BASE_URL}${e}`,c={method:a,headers:{"Content-Type":"application/json",Accept:"application/json",...o}};!i||"POST"!==a&&"PUT"!==a&&"PATCH"!==a||(c.body=JSON.stringify(i));const s=await fetch(t,c);if(!s.ok){const e=await s.text();throw new PaytmError(`Paytm API request failed: ${s.status} ${s.statusText}`,"API_ERROR",s.status,{response:e,url:t,method:a})}const d=await s.json();if("F"===(null===(n=null===(r=d.body)||void 0===r?void 0:r.resultInfo)||void 0===n?void 0:n.resultStatus))throw new PaytmError(d.body.resultInfo.resultMsg||"Paytm API error",d.body.resultInfo.resultCode||"PAYTM_API_ERROR",400,d);return d}catch(t){if(t instanceof PaytmError)throw t;throw new PaytmError(`Paytm API request failed: ${t.message}`,"NETWORK_ERROR",500,{originalError:t,endpoint:e,method:a})}}function buildCallbackUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYTM_CONFIG.CALLBACK_URL}`}function buildWebhookUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYTM_CONFIG.WEBHOOK_ENDPOINT}`}function isTestMode(){return exports.PAYTM_CONFIG.SANDBOX}function getPaymentMethodDisplayName(e){return{upi:"UPI",card:"Credit/Debit Card",netbanking:"Net Banking",wallet:"Paytm Wallet",emi:"EMI",bank_transfer:"Bank Transfer"}[e]||e.toUpperCase()}function calculatePaytmFees(e,t,r="credit_cards"){const n=getCurrencyInfo(t);if(!n)return{fees:0,netAmount:e,grossAmount:e};const a=n.fees[r]||n.fees.credit_cards,i=e*a.percentage/100+a.fixed;return{fees:Math.round(100*i)/100,netAmount:Math.round(100*(e-i))/100,grossAmount:e}}function getRegionFromCurrency(e){const t=getCurrencyInfo(e);return t?t.region:"Unknown"}function getCountryFromCurrency(e){const t=getCurrencyInfo(e);return t?t.country:"Unknown"}function getSupportedChannels(e){const t=getCurrencyInfo(e);return t?t.methods:[]}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.PaytmError=exports.PAYTM_WEBHOOK_EVENTS=exports.PAYTM_STATUS_MAPPING=exports.PAYTM_CURRENCY_DECIMALS=exports.PAYTM_CURRENCY_REGIONS=exports.PAYTM_CONFIG=void 0;exports.validatePaytmConfig=validatePaytmConfig;exports.isCurrencySupported=isCurrencySupported;exports.getCurrencyInfo=getCurrencyInfo;exports.getAvailablePaymentMethods=getAvailablePaymentMethods;exports.formatPaytmAmount=formatPaytmAmount;exports.parsePaytmAmount=parsePaytmAmount;exports.mapPaytmStatus=mapPaytmStatus;exports.generatePaytmOrderId=generatePaytmOrderId;exports.generateChecksumHash=generateChecksumHash;exports.verifyChecksumHash=verifyChecksumHash;exports.makePaytmRequest=makePaytmRequest;exports.buildCallbackUrl=buildCallbackUrl;exports.buildWebhookUrl=buildWebhookUrl;exports.isTestMode=isTestMode;exports.getPaymentMethodDisplayName=getPaymentMethodDisplayName;exports.calculatePaytmFees=calculatePaytmFees;exports.getRegionFromCurrency=getRegionFromCurrency;exports.getCountryFromCurrency=getCountryFromCurrency;exports.getSupportedChannels=getSupportedChannels;const crypto_1=__importDefault(require("crypto"));exports.PAYTM_CONFIG={API_BASE_URL:"true"===process.env.APP_PAYTM_SANDBOX?"https://securegw-stage.paytm.in":"https://securegw.paytm.in",MID:process.env.APP_PAYTM_MID||"",MERCHANT_KEY:process.env.APP_PAYTM_MERCHANT_KEY||"",WEBSITE:process.env.APP_PAYTM_WEBSITE||"WEBSTAGING",INDUSTRY_TYPE:process.env.APP_PAYTM_INDUSTRY_TYPE||"Retail",SANDBOX:"true"===process.env.APP_PAYTM_SANDBOX,CALLBACK_URL:process.env.APP_PAYTM_CALLBACK_URL||"/user/wallet/deposit/paytm/verify",WEBHOOK_ENDPOINT:process.env.APP_PAYTM_WEBHOOK_ENDPOINT||"/api/finance/deposit/fiat/paytm/webhook",TIMEOUT:3e4,VERSION:"v1"};exports.PAYTM_CURRENCY_REGIONS={INR:{region:"India",country:"IN",methods:["upi","card","netbanking","wallet","emi","bank_transfer"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:.4,fixed:0},credit_cards:{percentage:1.4,fixed:0},net_banking:{percentage:1.2,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},USD:{region:"International",country:"US",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},EUR:{region:"Europe",country:"EU",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},GBP:{region:"United Kingdom",country:"GB",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},AUD:{region:"Australia",country:"AU",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},CAD:{region:"Canada",country:"CA",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},SGD:{region:"Singapore",country:"SG",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},AED:{region:"United Arab Emirates",country:"AE",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},JPY:{region:"Japan",country:"JP",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},CNY:{region:"China",country:"CN",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},CHF:{region:"Switzerland",country:"CH",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},QAR:{region:"Qatar",country:"QA",methods:["card"],fees:{upi:{percentage:0,fixed:0},rupay_debit:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}}};exports.PAYTM_CURRENCY_DECIMALS={INR:2,USD:2,EUR:2,GBP:2,AUD:2,CAD:2,SGD:2,AED:2,JPY:0,CNY:2,CHF:2,QAR:2};exports.PAYTM_STATUS_MAPPING={TXN_SUCCESS:"COMPLETED",TXN_FAILURE:"FAILED",PENDING:"PENDING",OPEN:"PENDING",REFUND:"REFUNDED",CANCELLED:"CANCELLED"};exports.PAYTM_WEBHOOK_EVENTS={PAYMENT_SUCCESS:"payment.success",PAYMENT_FAILED:"payment.failed",PAYMENT_PENDING:"payment.pending",REFUND_SUCCESS:"refund.success",REFUND_FAILED:"refund.failed"};class PaytmError extends Error{constructor(e,t="PAYTM_ERROR",r=500,n){super(e);this.name="PaytmError";this.code=t;this.status=r;this.details=n}}exports.PaytmError=PaytmError;