"use strict";function validatePaysafeConfig(){if(!exports.PAYSAFE_CONFIG.API_KEY)throw(0,error_1.createError)({statusCode:500,message:"Paysafe API key is not configured"});if(!exports.PAYSAFE_CONFIG.API_SECRET)throw(0,error_1.createError)({statusCode:500,message:"Paysafe API secret is not configured"});if(!exports.PAYSAFE_CONFIG.ACCOUNT_ID)throw(0,error_1.createError)({statusCode:500,message:"Paysafe Account ID is not configured"})}function isCurrencySupported(e){return Object.keys(exports.PAYSAFE_CURRENCY_METHODS).includes(e.toUpperCase())}function getAvailablePaymentMethods(e){return exports.PAYSAFE_CURRENCY_METHODS[e.toUpperCase()]||["creditcard"]}function formatPaysafeAmount(e,r){const a=exports.PAYSAFE_CURRENCY_DECIMALS[r.toUpperCase()]||2;return Math.round(e*Math.pow(10,a))}function parsePaysafeAmount(e,r){const a=exports.PAYSAFE_CURRENCY_DECIMALS[r.toUpperCase()]||2;return e/Math.pow(10,a)}function mapPaysafeStatus(e){return exports.PAYSAFE_STATUS_MAPPING[e.toUpperCase()]||"PENDING"}function generatePaysafeReference(){return`PAYSAFE_${Date.now().toString()}_${Math.random().toString(36).substring(2,8)}`.toUpperCase()}async function makeApiRequest(e,r={}){var a,t,l;validatePaysafeConfig();const{method:p="GET",body:o,headers:s={}}=r,i=`${exports.PAYSAFE_CONFIG.API_BASE_URL}/paymenthub/${exports.PAYSAFE_CONFIG.VERSION}/${e}`,n={method:p,headers:{Authorization:`Basic ${Buffer.from(`${exports.PAYSAFE_CONFIG.API_KEY}:${exports.PAYSAFE_CONFIG.API_SECRET}`).toString("base64")}`,"Content-Type":"application/json",Accept:"application/json",...s},body:o?JSON.stringify(o):void 0,signal:AbortSignal.timeout(exports.PAYSAFE_CONFIG.TIMEOUT)};try{const e=await fetch(i,n),r=await e.json();if(!e.ok){const p=(null===(a=null==r?void 0:r.error)||void 0===a?void 0:a.message)||`HTTP ${e.status}: ${e.statusText}`,o=(null===(t=null==r?void 0:r.error)||void 0===t?void 0:t.code)||"API_ERROR";throw new PaysafeError(p,o,e.status,null===(l=null==r?void 0:r.error)||void 0===l?void 0:l.details)}return r}catch(e){if(e instanceof PaysafeError)throw e;if("AbortError"===e.name)throw new PaysafeError("Request timeout","TIMEOUT_ERROR",408);throw new PaysafeError(e.message||"Unknown error occurred","NETWORK_ERROR",500)}}function buildWebhookUrl(){return`${process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000"}${exports.PAYSAFE_CONFIG.WEBHOOK_ENDPOINT}`}function buildReturnUrl(){return`${process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000"}${exports.PAYSAFE_CONFIG.RETURN_URL}`}function buildCancelUrl(){return`${process.env.NEXT_PUBLIC_SITE_URL||"http://localhost:3000"}/user/wallet/deposit/paysafe/cancel`}function isTestMode(){return exports.PAYSAFE_CONFIG.SANDBOX}function getPaymentMethodDisplayName(e){return{creditcard:"Credit/Debit Cards",paypal:"PayPal",venmo:"Venmo",skrill:"Skrill",neteller:"NETELLER",applepay:"Apple Pay",googlepay:"Google Pay",ach:"ACH Bank Transfer",eft:"EFT Bank Transfer",paybybank:"Pay by Bank",sepadirectdebit:"SEPA Direct Debit",banktransfer:"Bank Transfer",paysafecard:"paysafecard",paysafecash:"paysafecash",vippreferred:"VIP Preferred",playsightline:"Play+ by Sightline",pix:"PIX",boleto:"Boleto Bancario",pagoefectivo:"PagoEfectivo"}[e]||e.charAt(0).toUpperCase()+e.slice(1)}function validateWebhookSignature(e,r){if(!r||!exports.PAYSAFE_CONFIG.API_SECRET)return!1;try{const a=crypto_1.default.createHmac("sha256",exports.PAYSAFE_CONFIG.API_SECRET).update(e).digest("hex");return crypto_1.default.timingSafeEqual(Buffer.from(r,"hex"),Buffer.from(a,"hex"))}catch(e){return!1}}function getRegionFromCurrency(e){return{USD:"US",CAD:"CA",EUR:"EU",GBP:"UK",AUD:"AU",NZD:"NZ",JPY:"JP",CNY:"CN",HKD:"HK",SGD:"SG",MYR:"MY",THB:"TH",PHP:"PH",IDR:"ID",VND:"VN",KRW:"KR",TWD:"TW",INR:"IN",BRL:"BR",MXN:"MX",ZAR:"ZA"}[e.toUpperCase()]||"GLOBAL"}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.PAYSAFE_PAYMENT_TYPES=exports.PaysafeError=exports.PAYSAFE_STATUS_MAPPING=exports.PAYSAFE_CURRENCY_DECIMALS=exports.PAYSAFE_CURRENCY_METHODS=exports.PAYSAFE_CONFIG=void 0;exports.validatePaysafeConfig=validatePaysafeConfig;exports.isCurrencySupported=isCurrencySupported;exports.getAvailablePaymentMethods=getAvailablePaymentMethods;exports.formatPaysafeAmount=formatPaysafeAmount;exports.parsePaysafeAmount=parsePaysafeAmount;exports.mapPaysafeStatus=mapPaysafeStatus;exports.generatePaysafeReference=generatePaysafeReference;exports.makeApiRequest=makeApiRequest;exports.buildWebhookUrl=buildWebhookUrl;exports.buildReturnUrl=buildReturnUrl;exports.buildCancelUrl=buildCancelUrl;exports.isTestMode=isTestMode;exports.getPaymentMethodDisplayName=getPaymentMethodDisplayName;exports.validateWebhookSignature=validateWebhookSignature;exports.getRegionFromCurrency=getRegionFromCurrency;const error_1=require("@b/utils/error"),crypto_1=__importDefault(require("crypto"));exports.PAYSAFE_CONFIG={API_BASE_URL:"true"===process.env.APP_PAYSAFE_SANDBOX?"https://api.test.paysafe.com":"https://api.paysafe.com",API_KEY:process.env.APP_PAYSAFE_API_KEY||"",API_SECRET:process.env.APP_PAYSAFE_API_SECRET||"",ACCOUNT_ID:process.env.APP_PAYSAFE_ACCOUNT_ID||"",SANDBOX:"true"===process.env.APP_PAYSAFE_SANDBOX,WEBHOOK_ENDPOINT:process.env.APP_PAYSAFE_WEBHOOK_ENDPOINT||"/api/finance/deposit/fiat/paysafe/webhook",RETURN_URL:process.env.APP_PAYSAFE_RETURN_URL||"/user/wallet/deposit/paysafe/verify",TIMEOUT:3e4,VERSION:"v1"};exports.PAYSAFE_CURRENCY_METHODS={USD:["creditcard","paypal","venmo","applepay","googlepay","ach","paybybank","vippreferred","playsightline"],EUR:["creditcard","paypal","skrill","neteller","applepay","googlepay","sepadirectdebit","banktransfer","paysafecard","paysafecash"],GBP:["creditcard","paypal","skrill","neteller","applepay","googlepay","banktransfer","paysafecard","paysafecash"],CAD:["creditcard","paypal","skrill","neteller","applepay","googlepay","eft","banktransfer","paysafecard"],CHF:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],SEK:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],NOK:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],DKK:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],PLN:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],CZK:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],HUF:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],BGN:["creditcard","skrill","neteller","applepay","googlepay","paysafecard"],RON:["creditcard","skrill","neteller","applepay","googlepay","paysafecard"],HRK:["creditcard","skrill","neteller","applepay","googlepay"],ISK:["creditcard","skrill","neteller","applepay","googlepay"],AUD:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],NZD:["creditcard","paypal","skrill","neteller","applepay","googlepay"],JPY:["creditcard","paypal","skrill","neteller","applepay","googlepay","paysafecard"],CNY:["creditcard","skrill","neteller","applepay","googlepay"],HKD:["creditcard","paypal","skrill","neteller","applepay","googlepay"],SGD:["creditcard","paypal","skrill","neteller","applepay","googlepay"],MYR:["creditcard","paypal","skrill","neteller","applepay","googlepay"],THB:["creditcard","paypal","skrill","neteller","applepay","googlepay"],PHP:["creditcard","paypal","skrill","neteller","applepay","googlepay"],IDR:["creditcard","skrill","neteller","applepay","googlepay"],VND:["creditcard","skrill","neteller"],KRW:["creditcard","skrill","neteller","applepay","googlepay"],TWD:["creditcard","paypal","skrill","neteller"],INR:["creditcard","paypal","skrill","neteller","applepay","googlepay"],ILS:["creditcard","paypal","skrill","neteller","applepay","googlepay"],TRY:["creditcard","skrill","neteller","applepay","googlepay"],ZAR:["creditcard","skrill","neteller","applepay","googlepay"],BRL:["creditcard","paypal","skrill","neteller","applepay","googlepay","pix","boleto"],MXN:["creditcard","paypal","skrill","neteller","applepay","googlepay"],CLP:["creditcard","skrill","neteller"],COP:["creditcard","skrill","neteller"],PEN:["creditcard","skrill","neteller","pagoefectivo"],ARS:["creditcard","skrill","neteller"],UYU:["creditcard","skrill","neteller"],BOB:["creditcard","skrill","neteller"],PYG:["creditcard","skrill","neteller"],FJD:["creditcard"],WST:["creditcard"],TOP:["creditcard"],VUV:["creditcard"],SBD:["creditcard"],PGK:["creditcard"]};exports.PAYSAFE_CURRENCY_DECIMALS={USD:2,EUR:2,GBP:2,CAD:2,AUD:2,CHF:2,SEK:2,NOK:2,DKK:2,PLN:2,CZK:2,HUF:2,BGN:2,RON:2,HRK:2,ISK:2,NZD:2,HKD:2,SGD:2,MYR:2,THB:2,PHP:2,TWD:2,INR:2,ILS:2,TRY:2,ZAR:2,BRL:2,MXN:2,CLP:2,COP:2,PEN:2,ARS:2,UYU:2,BOB:2,PYG:0,FJD:2,WST:2,TOP:2,VUV:0,SBD:2,PGK:2,JPY:0,KRW:0,IDR:0,VND:0,CNY:2};exports.PAYSAFE_STATUS_MAPPING={INITIATED:"PENDING",PENDING:"PENDING",PROCESSING:"PENDING",PAYABLE:"PENDING",COMPLETED:"COMPLETED",FAILED:"FAILED",CANCELLED:"CANCELLED",EXPIRED:"EXPIRED",REFUNDED:"REFUNDED",CHARGED_BACK:"CHARGEBACK",DECLINED:"FAILED",ERROR:"FAILED"};class PaysafeError extends Error{constructor(e,r="PAYSAFE_ERROR",a=500,t){super(e);this.name="PaysafeError";this.code=r;this.status=a;this.details=t}}exports.PaysafeError=PaysafeError;exports.PAYSAFE_PAYMENT_TYPES={CARDS:"CARD",PAYPAL:"PAYPAL",VENMO:"VENMO",SKRILL:"SKRILL",NETELLER:"NETELLER",APPLE_PAY:"APPLEPAY",GOOGLE_PAY:"GOOGLEPAY",ACH:"ACH",EFT:"EFT",PAYSAFECARD:"PAYSAFECARD",PAYSAFECASH:"PAYSAFECASH"};