"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("./utils"),query_1=require("@b/utils/query");exports.metadata={summary:"Fetches PayPal order details",description:"Retrieves details for a specific PayPal order by its ID.",operationId:"getPayPalOrderDetails",tags:["Finance","Deposit"],parameters:[{name:"orderId",in:"query",description:"PayPal order ID",required:!0,schema:{type:"string"}}],responses:{200:{description:"PayPal order details fetched successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"Order ID"},status:{type:"string",description:"Order status"},purchase_units:{type:"array",items:{type:"object",properties:{amount:{type:"object",properties:{currency_code:{type:"string"},value:{type:"string"}}}}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Paypal"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,query:t}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{orderId:s}=t;if(!s)throw(0,error_1.createError)({statusCode:400,message:"Order ID is required"});const a=(0,utils_1.paypalOrdersController)();try{const{result:e}=await a.getOrder({id:s});return e}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error getting PayPal order details: ${e.message}`})}};