"use strict";function validatePayFastConfig(){if(!exports.PAYFAST_CONFIG.MERCHANT_ID)throw(0,error_1.createError)(500,"PayFast merchant ID is not configured");if(!exports.PAYFAST_CONFIG.MERCHANT_KEY)throw(0,error_1.createError)(500,"PayFast merchant key is not configured")}function isCurrencySupported(a){return exports.PAYFAST_SUPPORTED_CURRENCIES.includes(a.toUpperCase())}function getAvailablePaymentMethods(a){return exports.PAYFAST_PAYMENT_METHODS[a.toUpperCase()]||[]}function formatPayFastAmount(a){return a.toFixed(2)}function parsePayFastAmount(a){return parseFloat(a)||0}function mapPayFastStatus(a){return exports.PAYFAST_STATUS_MAPPING[a.toUpperCase()]||"PENDING"}function generatePayFastReference(){return`PF_${Date.now()}_${Math.random().toString(36).substring(2,8)}`.toUpperCase()}function generateSignature(a,e){const{signature:t,...r}=a,s=Object.keys(r).filter(a=>""!==r[a]&&null!==r[a]&&void 0!==r[a]).sort().map(a=>`${a}=${encodeURIComponent(r[a]).replace(/%20/g,"+")}`).join("&"),p=e?`${s}&passphrase=${e}`:s;return crypto_1.default.createHash("md5").update(p).digest("hex")}function validateSignature(a,e){const t=a.signature;if(!t)return!1;const r=generateSignature(a,e);return t.toLowerCase()===r.toLowerCase()}function getPayFastHost(){return exports.PAYFAST_CONFIG.SANDBOX?exports.PAYFAST_CONFIG.SANDBOX_HOST:exports.PAYFAST_CONFIG.LIVE_HOST}function buildPaymentUrl(){return`https://${getPayFastHost()}/eng/process`}function buildNotifyUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYFAST_CONFIG.NOTIFY_URL}`}function buildReturnUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYFAST_CONFIG.RETURN_URL}`}function buildCancelUrl(){return`${process.env.APP_PUBLIC_URL||"http://localhost:3000"}${exports.PAYFAST_CONFIG.CANCEL_URL}`}function isTestMode(){return exports.PAYFAST_CONFIG.SANDBOX}async function validateITN(a){try{const{signature:e,...t}=a,r=Object.keys(t).filter(a=>""!==t[a]&&null!==t[a]&&void 0!==t[a]).sort().map(a=>`${a}=${encodeURIComponent(t[a]).replace(/%20/g,"+")}`).join("&"),s=await fetch(`https://${getPayFastHost()}/eng/query/validate`,{method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded"},body:r});return"VALID"===await s.text()?{valid:!0}:{valid:!1,error:"PayFast ITN validation failed"}}catch(a){return{valid:!1,error:`ITN validation error: ${a.message}`}}}function getPaymentMethodDisplayName(a){return{creditcard:"Credit Card",instanteft:"Instant EFT",capitecpay:"Capitec Pay",applepay:"Apple Pay",samsungpay:"Samsung Pay",snapcan:"SnapScan",zapper:"Zapper",mobicred:"Mobicred",moretyme:"MoreTyme",mukurupay:"MukuruPay",scode:"SCode",storecards:"Store Cards",debitcard:"Debit Card",masterpass:"Masterpass"}[a]||a}function validateAmount(a,e){return a>=("ZAR"===e?1:.5)&&a<=1e5}function generatePaymentForm(a){return`\n<form id="payfast-form" action="https://${getPayFastHost()}/eng/process" method="post">\n    ${Object.entries(a).map(([a,e])=>`<input type="hidden" name="${a}" value="${e}">`).join("\n    ")}\n    <input type="submit" value="Pay with PayFast">\n</form>\n<script>\n    document.getElementById('payfast-form').submit();\n<\/script>\n  `.trim()}var __importDefault=this&&this.__importDefault||function(a){return a&&a.__esModule?a:{default:a}};Object.defineProperty(exports,"__esModule",{value:!0});exports.PayFastError=exports.PAYFAST_TRANSACTION_TYPES=exports.PAYFAST_STATUS_MAPPING=exports.PAYFAST_PAYMENT_METHODS=exports.PAYFAST_SUPPORTED_CURRENCIES=exports.PAYFAST_CONFIG=void 0;exports.validatePayFastConfig=validatePayFastConfig;exports.isCurrencySupported=isCurrencySupported;exports.getAvailablePaymentMethods=getAvailablePaymentMethods;exports.formatPayFastAmount=formatPayFastAmount;exports.parsePayFastAmount=parsePayFastAmount;exports.mapPayFastStatus=mapPayFastStatus;exports.generatePayFastReference=generatePayFastReference;exports.generateSignature=generateSignature;exports.validateSignature=validateSignature;exports.getPayFastHost=getPayFastHost;exports.buildPaymentUrl=buildPaymentUrl;exports.buildNotifyUrl=buildNotifyUrl;exports.buildReturnUrl=buildReturnUrl;exports.buildCancelUrl=buildCancelUrl;exports.isTestMode=isTestMode;exports.validateITN=validateITN;exports.getPaymentMethodDisplayName=getPaymentMethodDisplayName;exports.validateAmount=validateAmount;exports.generatePaymentForm=generatePaymentForm;const error_1=require("@b/utils/error"),crypto_1=__importDefault(require("crypto"));exports.PAYFAST_CONFIG={SANDBOX_HOST:"sandbox.payfast.co.za",LIVE_HOST:"www.payfast.co.za",MERCHANT_ID:process.env.APP_PAYFAST_MERCHANT_ID||"",MERCHANT_KEY:process.env.APP_PAYFAST_MERCHANT_KEY||"",PASSPHRASE:process.env.APP_PAYFAST_PASSPHRASE||"",SANDBOX:"true"===process.env.APP_PAYFAST_SANDBOX,NOTIFY_URL:process.env.APP_PAYFAST_NOTIFY_URL||"/api/finance/deposit/fiat/payfast/webhook",RETURN_URL:process.env.APP_PAYFAST_RETURN_URL||"/user/wallet/deposit/payfast/verify",CANCEL_URL:process.env.APP_PAYFAST_CANCEL_URL||"/user/wallet/deposit/payfast/cancel",TIMEOUT:3e4};exports.PAYFAST_SUPPORTED_CURRENCIES=["ZAR","USD","EUR","GBP","AUD","CAD","CHF","SEK","NOK","DKK","PLN","CZK","HUF","BGN","RON","HRK","ISK","JPY","CNY","HKD","SGD","MYR","THB","PHP","IDR","VND","KRW","TWD","INR","ILS","TRY"];exports.PAYFAST_PAYMENT_METHODS={ZAR:["creditcard","instanteft","capitecpay","applepay","samsungpay","snapcan","zapper","mobicred","moretyme","mukurupay","scode","storecards","debitcard","masterpass"],USD:["creditcard","applepay","samsungpay"],EUR:["creditcard","applepay","samsungpay"],GBP:["creditcard","applepay","samsungpay"],AUD:["creditcard","applepay","samsungpay"],CAD:["creditcard","applepay","samsungpay"],CHF:["creditcard","applepay","samsungpay"],SEK:["creditcard","applepay","samsungpay"],NOK:["creditcard","applepay","samsungpay"],DKK:["creditcard","applepay","samsungpay"],PLN:["creditcard","applepay","samsungpay"],CZK:["creditcard","applepay","samsungpay"],HUF:["creditcard","applepay","samsungpay"],BGN:["creditcard","applepay","samsungpay"],RON:["creditcard","applepay","samsungpay"],HRK:["creditcard","applepay","samsungpay"],ISK:["creditcard","applepay","samsungpay"],JPY:["creditcard","applepay","samsungpay"],CNY:["creditcard","applepay","samsungpay"],HKD:["creditcard","applepay","samsungpay"],SGD:["creditcard","applepay","samsungpay"],MYR:["creditcard","applepay","samsungpay"],THB:["creditcard","applepay","samsungpay"],PHP:["creditcard","applepay","samsungpay"],IDR:["creditcard","applepay","samsungpay"],VND:["creditcard","applepay","samsungpay"],KRW:["creditcard","applepay","samsungpay"],TWD:["creditcard","applepay","samsungpay"],INR:["creditcard","applepay","samsungpay"],ILS:["creditcard","applepay","samsungpay"],TRY:["creditcard","applepay","samsungpay"]};exports.PAYFAST_STATUS_MAPPING={COMPLETE:"COMPLETED",FAILED:"FAILED",CANCELLED:"CANCELLED",PENDING:"PENDING"};exports.PAYFAST_TRANSACTION_TYPES={PAYMENT:"payment",SUBSCRIPTION:"subscription",ADHOC:"adhoc"};class PayFastError extends Error{constructor(a,e=500,t){super(a);this.name="PayFastError";this.status=e;this.type=t}}exports.PayFastError=PayFastError;