"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),emails_1=require("@b/utils/emails"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verifies and creates a Klarna order",description:"Handles the return URL from Klarna checkout, verifies the authorization token, and creates an order to complete the payment process.",operationId:"verifyKlarnaPayment",tags:["Finance","Deposit"],logModule:"KLARNA_DEPOSIT",logTitle:"Verify Klarna payment",requestBody:{description:"Authorization token from Klarna checkout",content:{"application/json":{schema:{type:"object",properties:{authorization_token:{type:"string",description:"Authorization token from Klarna checkout"},session_id:{type:"string",description:"Klarna session ID",nullable:!0}},required:["authorization_token"]}}}},responses:{200:{description:"Klarna payment verified and order created successfully. Returns order details and payment status.",content:{"application/json":{schema:{type:"object",properties:{order_id:{type:"string",description:"Klarna order ID"},status:{type:"string",description:"Order status"},fraud_status:{type:"string",description:"Fraud check status"},klarna_reference:{type:"string",description:"Klarna reference number"},order_amount:{type:"number",description:"Order amount in minor units"},purchase_currency:{type:"string",description:"Purchase currency"},payment_method:{type:"object",description:"Selected payment method details"},transaction_id:{type:"string",description:"Local transaction ID"}}}}}},400:{description:"Invalid authorization token or payment failed",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Klarna"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!t)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{authorization_token:s,session_id:n}=r;if(!s)throw(0,error_1.createError)({statusCode:400,message:"Authorization token is required"});try{const e=await(0,utils_1.makeKlarnaRequest)(`/payments/v1/authorizations/${s}`,"GET");if(!e)throw(0,error_1.createError)({statusCode:400,message:"Failed to retrieve authorization details"});const r=await db_1.models.transaction.findOne({where:{userId:t.id,referenceId:n||s,status:"PENDING",type:"DEPOSIT"},order:[["createdAt","DESC"]]});if(!r)throw(0,error_1.createError)({statusCode:404,message:"No pending transaction found for this authorization"});const o=JSON.parse(r.metadata||"{}"),i={purchase_country:o.purchase_country,purchase_currency:o.purchase_currency,locale:o.locale||"en-US",order_amount:Math.round(100*r.amount),order_lines:[{type:"physical",reference:"deposit",name:"Account Deposit",quantity:1,unit_price:Math.round(100*(r.amount-r.fee)),tax_rate:0,total_amount:Math.round(100*(r.amount-r.fee)),total_tax_amount:0}],merchant_reference1:o.merchant_reference,merchant_reference2:t.id};r.fee>0&&i.order_lines.push({type:"fee",reference:"processing_fee",name:"Processing Fee",quantity:1,unit_price:Math.round(100*r.fee),tax_rate:0,total_amount:Math.round(100*r.fee),total_tax_amount:0});const d=await(0,utils_1.makeKlarnaRequest)(`/payments/v1/authorizations/${s}/order`,"POST",i);if(!d||!d.order_id)throw(0,error_1.createError)({statusCode:500,message:"Failed to create Klarna order"});const u=d.status&&utils_1.KLARNA_STATUS_MAPPING[d.status]||"PENDING";if("COMPLETED"===u||"AUTHORIZED"===d.status){const s=o.purchase_currency,n=r.amount-r.fee;await db_1.models.transaction.update({status:"COMPLETED",metadata:JSON.stringify({...o,order_id:d.order_id,klarna_reference:d.klarna_reference,fraud_status:d.fraud_status,payment_method:e.authorized_payment_method,completed_at:(new Date).toISOString()}),description:`Klarna deposit of ${n} ${s} completed by ${t.firstName} ${t.lastName}`},{where:{id:r.id}});null==a||a.step("Processing deposit via wallet service");const i=await(0,utils_2.processFiatDeposit)({userId:t.id,currency:s,amount:r.amount,fee:r.fee,referenceId:d.order_id,method:"KLARNA",description:`Klarna deposit of ${n} ${s}`,metadata:{order_id:d.order_id,klarna_reference:d.klarna_reference,fraud_status:d.fraud_status},idempotencyKey:`klarna_deposit_${d.order_id}`,ctx:a});null==a||a.success("Klarna deposit completed successfully");try{null==a||a.step("Sending notification email");await(0,emails_1.sendFiatTransactionEmail)(t,{...r.dataValues,type:"DEPOSIT",amount:n,status:"COMPLETED",description:`Klarna deposit of ${n} ${s} completed`},s,i.newBalance)}catch(e){console_1.logger.error("KLARNA","Failed to send confirmation email",e)}return{order_id:d.order_id,status:d.status,fraud_status:d.fraud_status,klarna_reference:d.klarna_reference,order_amount:d.order_amount,purchase_currency:d.purchase_currency,payment_method:e.authorized_payment_method,transaction_id:r.id,wallet_balance:i.newBalance}}if("FAILED"===u||"CANCELLED"===d.status){await db_1.models.transaction.update({status:"FAILED",metadata:JSON.stringify({...o,order_id:d.order_id,klarna_reference:d.klarna_reference,fraud_status:d.fraud_status,failure_reason:`Order status: ${d.status}`,failed_at:(new Date).toISOString()})},{where:{id:r.id}});throw(0,error_1.createError)({statusCode:400,message:`Payment failed with status: ${d.status}`})}await db_1.models.transaction.update({metadata:JSON.stringify({...o,order_id:d.order_id,klarna_reference:d.klarna_reference,fraud_status:d.fraud_status,current_status:d.status,updated_at:(new Date).toISOString()})},{where:{id:r.id}});return{order_id:d.order_id,status:d.status,fraud_status:d.fraud_status,klarna_reference:d.klarna_reference,order_amount:d.order_amount,purchase_currency:d.purchase_currency,payment_method:e.authorized_payment_method,transaction_id:r.id,message:"Payment is being processed. You will be notified when completed."}}catch(e){if(e instanceof utils_1.KlarnaError)throw(0,error_1.createError)({statusCode:400,message:`Klarna verification failed: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Payment verification failed: ${e.message}`})}};