"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),publicUrl=process.env.NEXT_PUBLIC_SITE_URL,isProduction="production"===process.env.NODE_ENV;exports.metadata={summary:"Creates an iPay88 payment",description:"Initiates an iPay88 payment process for Southeast Asian markets. Supports multiple payment methods including credit cards, e-wallets, and online banking across Malaysia, Singapore, Thailand, Philippines, Indonesia, and Vietnam.",operationId:"createIpay88Payment",tags:["Finance","Payment"],logModule:"IPAY88_DEPOSIT",logTitle:"Create iPay88 payment",requestBody:{description:"Payment information for iPay88 payment creation",content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount in base currency units"},currency:{type:"string",description:"Currency code (e.g., MYR, SGD, THB, PHP, IDR, VND, USD, EUR, GBP, AUD)"},paymentMethod:{type:"string",description:"iPay88 payment method code (optional, defaults to show all available methods)",nullable:!0},description:{type:"string",description:"Payment description",nullable:!0},customerName:{type:"string",description:"Customer name",nullable:!0},customerEmail:{type:"string",description:"Customer email address",nullable:!0},customerPhone:{type:"string",description:"Customer phone number",nullable:!0},lang:{type:"string",description:"Payment page language (ISO-2 format: EN, CN, MY, TH, ID, VN)",nullable:!0}},required:["amount","currency"]}}}},responses:{200:{description:"iPay88 payment created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},payment_url:{type:"string"},payment_id:{type:"string"},reference:{type:"string"},status:{type:"string"},gateway:{type:"string"},amount:{type:"number"},currency:{type:"string"},signature:{type:"string"},merchant_code:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Payment gateway not found"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!t){null==a||a.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"User not found"})}try{const{amount:e,currency:n,paymentMethod:s,description:o="Payment",customerName:i,customerEmail:p,customerPhone:c,lang:u="EN"}=r;if(!e||e<=0)throw(0,error_1.createError)({statusCode:400,message:"Valid amount is required"});if(!n)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});if(!(0,utils_1.validateCurrency)(n))throw(0,error_1.createError)({statusCode:400,message:`Currency ${n} is not supported by iPay88`});const y=(0,utils_1.getIpay88Config)();null==a||a.step("Creating transaction record");const m=await db_1.models.transaction.create({uuid:require("crypto").randomUUID(),userId:t.id,type:"DEPOSIT",status:"PENDING",amount:e,fee:0,description:o,metadata:JSON.stringify({gateway:"ipay88",currency:n.toUpperCase(),payment_method:s,customer_name:i||`${t.firstName} ${t.lastName}`,customer_email:p||t.email,customer_phone:c,language:u})}),d=`TXN-${m.uuid.replace(/-/g,"").substring(0,16).toUpperCase()}`,l=(0,utils_1.convertToIpay88Amount)(e),g=(0,utils_1.generateIpay88Signature)(y.merchantKey,y.merchantCode,d,l,n.toUpperCase()),_={MerchantCode:y.merchantCode,PaymentId:"1",RefNo:d,Amount:l,Currency:n.toUpperCase(),ProdDesc:o,UserName:i||`${t.firstName} ${t.lastName}`,UserEmail:p||t.email,UserContact:c||"",Remark:`Payment for ${o}`,Lang:u,Signature:g,ResponseURL:`${publicUrl}/api/finance/deposit/fiat/ipay88/verify`,BackendURL:`${publicUrl}/api/finance/deposit/fiat/ipay88/webhook`,SignatureType:"SHA256"};s&&utils_1.IPAY88_PAYMENT_METHODS[s]&&(_.PaymentMethod=utils_1.IPAY88_PAYMENT_METHODS[s]);await m.update({metadata:{...m.metadata,ipay88_reference:d,ipay88_payment_id:"1",ipay88_signature:g,ipay88_request:_}});const h=new URL("/payment.htm",y.baseUrl);Object.entries(_).forEach(([e,t])=>{t&&h.searchParams.append(e,t.toString())});return{success:!0,data:{transaction_id:m.id,payment_url:h.toString(),payment_id:"1",reference:d,status:"PENDING",gateway:"ipay88",amount:e,currency:n.toUpperCase(),signature:g,merchant_code:y.merchantCode,payment_methods:{credit_card:"Credit/Debit Cards",fpx:"FPX Online Banking",boost:"Boost eWallet",grabpay:"GrabPay",shopee_pay:"ShopeePay",touch_n_go:"Touch 'n Go eWallet",maybank_qr:"Maybank QR",alipay:"Alipay",wechat_pay:"WeChat Pay"}}}}catch(e){console_1.logger.error("IPAY88","Payment creation error",e);if(e instanceof utils_1.Ipay88Error)throw(0,error_1.createError)({statusCode:400,message:`iPay88 Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create iPay88 payment"})}};