"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.EwayError=exports.EWAY_METHODS=exports.EWAY_TRANSACTION_TYPES=exports.EWAY_STATUS_MAPPING=exports.validateCurrency=exports.makeEwayRequest=exports.getEwayConfig=void 0;const error_1=require("@b/utils/error"),getEwayConfig=()=>{const e=process.env.APP_EWAY_API_KEY,r=process.env.APP_EWAY_API_PASSWORD,t="production"===process.env.NODE_ENV;if(!e||!r)throw(0,error_1.createError)({statusCode:500,message:"eWAY credentials are not properly configured in environment variables"});return{apiKey:e,apiPassword:r,baseUrl:t?"https://api.ewaypayments.com":"https://api.sandbox.ewaypayments.com",version:"47"}};exports.getEwayConfig=getEwayConfig;const makeEwayRequest=async(e,r="POST",t)=>{const s=(0,exports.getEwayConfig)(),o=`${s.baseUrl}${e}`,a={method:r,headers:{"Content-Type":"application/json","X-EWAY-APIVERSION":s.version,Authorization:`Basic ${Buffer.from(`${s.apiKey}:${s.apiPassword}`).toString("base64")}`}};!t||"POST"!==r&&"PUT"!==r||(a.body=JSON.stringify(t));try{const e=await fetch(o,a),r=await e.json();if(!e.ok)throw new EwayError(`eWAY API Error: ${e.status}`,e.status,r);return r}catch(e){if(e instanceof EwayError)throw e;throw new EwayError("Network error occurred",500,{message:e.message})}};exports.makeEwayRequest=makeEwayRequest;const validateCurrency=e=>["AUD","NZD","SGD","USD","EUR","GBP","CAD","JPY","HKD","MYR","THB","PHP","IDR","VND","KRW","CNY","TWD","INR","CHF","SEK","NOK","DKK"].includes(e.toUpperCase());exports.validateCurrency=validateCurrency;exports.EWAY_STATUS_MAPPING={true:"COMPLETED",false:"FAILED"};exports.EWAY_TRANSACTION_TYPES={PURCHASE:"Purchase",MOTO:"MOTO",RECURRING:"Recurring"};exports.EWAY_METHODS={DIRECT:"Direct",TRANSPARENT_REDIRECT:"TransparentRedirect",RESPONSIVE_SHARED_PAGE:"ResponsiveSharedPage",IFRAME:"Iframe",SECURE_FIELDS:"SecureFields"};class EwayError extends Error{constructor(e,r=500,t={}){super(e);this.name="EwayError";this.statusCode=r;this.details=t}}exports.EwayError=EwayError;