"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db");exports.metadata={summary:"Get eWAY payment status",description:"Retrieve current payment status from eWAY API without updating local database",operationId:"getEwayPaymentStatus",tags:["Finance","Status"],parameters:[{name:"access_code",in:"query",description:"eWAY access code to check",schema:{type:"string"}},{name:"transaction_id",in:"query",description:"eWAY transaction ID to check",schema:{type:"string"}},{name:"reference",in:"query",description:"Internal reference ID to check",schema:{type:"string"}}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},transaction_status:{type:"boolean"},transaction_type:{type:"string"},authorisation_code:{type:"string"},response_code:{type:"string"},response_message:{type:"string"},amount:{type:"number"},currency:{type:"string"},customer:{type:"object"},beagle_score:{type:"number"}}}}}}}},400:{description:"Invalid request parameters"},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction")},requiresAuth:!0};exports.default=async e=>{var t,r,s,a;const{user:o,query:n}=e;if(!(null==o?void 0:o.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});try{const{access_code:e,transaction_id:i,reference:c}=n;if(!e&&!i&&!c)throw(0,error_1.createError)({statusCode:400,message:"Access code, transaction ID, or reference is required"});let u;if(e)u=await(0,utils_1.makeEwayRequest)(`/GetAccessCodeResult/${e}`,"GET");else if(i)u=await(0,utils_1.makeEwayRequest)(`/Transaction/${i}`,"GET");else{const e=await db_1.models.transaction.findOne({where:{referenceId:c,userId:o.id}});if(!e||!(null===(t=e.metadata)||void 0===t?void 0:t.eway_transaction_id))throw(0,error_1.createError)({statusCode:404,message:"Transaction not found or does not have eWAY transaction ID"});u=await(0,utils_1.makeEwayRequest)(`/Transaction/${e.metadata.eway_transaction_id}`,"GET")}if(u.Errors)throw new utils_1.EwayError("eWAY API Error",400,{errors:u.Errors});return{success:!0,data:{transaction_id:null===(r=u.TransactionID)||void 0===r?void 0:r.toString(),transaction_status:u.TransactionStatus,transaction_type:u.TransactionType,authorisation_code:u.AuthorisationCode,response_code:u.ResponseCode,response_message:u.ResponseMessage,amount:null===(s=u.Payment)||void 0===s?void 0:s.TotalAmount,currency:null===(a=u.Payment)||void 0===a?void 0:a.CurrencyCode,customer:u.Customer,beagle_score:u.BeagleScore,transaction_datetime:u.TransactionDateTime,max_refund:u.MaxRefund,original_transaction_id:u.OriginalTransactionId,source:u.Source}}}catch(e){console_1.logger.error("EWAY","Status check error",e);if(e instanceof utils_1.EwayError)throw(0,error_1.createError)({statusCode:400,message:`eWAY Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to check eWAY payment status"})}};