"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),publicUrl=process.env.NEXT_PUBLIC_SITE_URL,isProduction="production"===process.env.NODE_ENV;exports.metadata={summary:"Creates an eWAY payment",description:"Initiates an eWAY payment process for Asia-Pacific region. Supports multiple connection methods including Transparent Redirect, Direct Connection, and Responsive Shared Page.",operationId:"createEwayPayment",tags:["Finance","Payment"],logModule:"EWAY_DEPOSIT",logTitle:"Create eWAY payment",requestBody:{description:"eWAY payment creation request",content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount in smallest currency unit",example:1e4},currency:{type:"string",description:"Currency code (ISO 4217)",example:"AUD"},method:{type:"string",description:"eWAY connection method",enum:["TransparentRedirect","ResponsiveSharedPage","Direct"],default:"TransparentRedirect"},transaction_type:{type:"string",description:"Transaction type",enum:["Purchase","MOTO","Recurring"],default:"Purchase"},customer:{type:"object",description:"Customer information",properties:{first_name:{type:"string"},last_name:{type:"string"},email:{type:"string"},phone:{type:"string"},address:{type:"object",properties:{street1:{type:"string"},street2:{type:"string"},city:{type:"string"},state:{type:"string"},postal_code:{type:"string"},country:{type:"string",description:"2-letter country code"}}}}},invoice_number:{type:"string",description:"Invoice number for reference"},description:{type:"string",description:"Payment description"},return_url:{type:"string",description:"URL to redirect after successful payment"},cancel_url:{type:"string",description:"URL to redirect after cancelled payment"}},required:["amount","currency"]}}}},responses:{200:{description:"eWAY payment created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},payment_url:{type:"string"},access_code:{type:"string"},status:{type:"string"},gateway:{type:"string"},amount:{type:"number"},currency:{type:"string"},reference:{type:"string"}}}}}}}},400:{description:"Invalid request parameters"},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:{description:"Internal server error",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Error message"}}}}}}},requiresAuth:!0};exports.default=async e=>{var t,r,s,a,o,n,i;const{user:c,body:d,ctx:u}=e;if(!(null==c?void 0:c.id)){null==u||u.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"})}try{const{amount:e,currency:p,method:y="TransparentRedirect",transaction_type:l="Purchase",customer:m={},invoice_number:_,description:g,return_url:f,cancel_url:w}=d;if(!e||e<=0)throw(0,error_1.createError)({statusCode:400,message:"Valid amount is required"});if(!p)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});if(!(0,utils_1.validateCurrency)(p))throw(0,error_1.createError)({statusCode:400,message:`Currency ${p} is not supported by eWAY`});const C=await db_1.models.wallet.findOne({where:{userId:c.id,currency:p.toUpperCase()}});if(!C)throw(0,error_1.createError)({statusCode:404,message:`Wallet not found for currency ${p}`});null==u||u.step("Fetching payment gateway configuration");const h=await db_1.models.depositGateway.findOne({where:{alias:"eway",status:!0}});if(!h){null==u||u.fail("Payment gateway not found");throw(0,error_1.createError)({statusCode:404,message:"eWAY gateway is not available"})}if(!h.currencies.includes(p.toUpperCase()))throw(0,error_1.createError)({statusCode:400,message:`Currency ${p} is not supported by eWAY gateway`});const E=.029;null==u||u.step("Calculating fees");const A="AUD"===p.toUpperCase()?30:0,v=Math.round(e*E)+A,P=e+v,b=`EWAY_${Date.now()}_${c.id}`;null==u||u.step("Creating transaction record");const I=await db_1.models.transaction.create({userId:c.id,walletId:C.id,type:"DEPOSIT",status:"PENDING",amount:e,fee:v,description:g||"eWAY deposit",metadata:JSON.stringify({gateway:"eway",method:y,transaction_type:l,currency:p.toUpperCase(),reference:b,invoice_number:_,customer:m}),referenceId:b}),U={Customer:{Reference:b,FirstName:m.first_name||"",LastName:m.last_name||"",Email:m.email||c.email||"",Phone:m.phone||"",Street1:(null===(t=m.address)||void 0===t?void 0:t.street1)||"",Street2:(null===(r=m.address)||void 0===r?void 0:r.street2)||"",City:(null===(s=m.address)||void 0===s?void 0:s.city)||"",State:(null===(a=m.address)||void 0===a?void 0:a.state)||"",PostalCode:(null===(o=m.address)||void 0===o?void 0:o.postal_code)||"",Country:(null===(i=null===(n=m.address)||void 0===n?void 0:n.country)||void 0===i?void 0:i.toLowerCase())||"au"},Payment:{TotalAmount:P,InvoiceNumber:_||b,InvoiceDescription:g||"Payment via eWAY",InvoiceReference:b,CurrencyCode:p.toUpperCase()},RedirectUrl:f||`${publicUrl}/finance/deposit/eway/success?ref=${b}`,CancelUrl:w||`${publicUrl}/finance/deposit/eway/cancel?ref=${b}`,Method:"ProcessPayment",TransactionType:utils_1.EWAY_TRANSACTION_TYPES[l.toUpperCase()]||"Purchase",DeviceID:"v5-platform",CustomerIP:"127.0.0.1"};if("ResponsiveSharedPage"===y){const t=await(0,utils_1.makeEwayRequest)("/CreateAccessCode","POST",U);if(t.Errors)throw new utils_1.EwayError("eWAY API Error",400,{errors:t.Errors});await I.update({metadata:JSON.stringify({...I.metadata,eway_access_code:t.AccessCode,eway_form_url:t.FormActionURL})});return{success:!0,data:{transaction_id:I.id,payment_url:t.FormActionURL,access_code:t.AccessCode,status:"PENDING",gateway:"eway",amount:e,currency:p.toUpperCase(),reference:b,method:y}}}{const t=await(0,utils_1.makeEwayRequest)("/CreateAccessCodeShared","POST",U);if(t.Errors)throw new utils_1.EwayError("eWAY API Error",400,{errors:t.Errors});await I.update({metadata:JSON.stringify({...I.metadata,eway_access_code:t.AccessCode,eway_form_url:t.FormActionURL})});return{success:!0,data:{transaction_id:I.id,payment_url:t.FormActionURL,access_code:t.AccessCode,status:"PENDING",gateway:"eway",amount:e,currency:p.toUpperCase(),reference:b,method:y}}}}catch(e){console_1.logger.error("EWAY","Payment creation error",e);if(e instanceof utils_1.EwayError)throw(0,error_1.createError)({statusCode:400,message:`eWAY Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to create eWAY payment"})}};