"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("./utils"),db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),wallet_1=require("@b/services/wallet"),notification_1=require("@b/services/notification");exports.metadata={summary:"dLocal webhook handler",description:"Handles payment notifications from dLocal with HMAC signature verification",operationId:"dLocalWebhook",tags:["Finance","Webhook"],logModule:"WEBHOOK",logTitle:"dLocal webhook",requestBody:{description:"dLocal webhook payload",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string"},amount:{type:"number"},currency:{type:"string"},payment_method_id:{type:"string"},payment_method_type:{type:"string"},country:{type:"string"},status:{type:"string"},status_code:{type:"number"},status_detail:{type:"string"},order_id:{type:"string"},created_date:{type:"string"},approved_date:{type:"string",nullable:!0},live:{type:"boolean"}},required:["id","amount","currency","status","order_id"]}}}},responses:{200:{description:"Webhook processed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},status:{type:"string"}}}}}},400:{description:"Bad request or invalid signature"},404:{description:"Transaction not found"},500:{description:"Internal server error"}},requiresAuth:!1};exports.default=async e=>{var t,o;const{body:a,headers:i,ctx:r}=e;try{const e=(0,utils_1.getDLocalConfig)(),s=i["x-date"],n=i.authorization;if(!s||!n)throw(0,error_1.createError)({statusCode:400,message:"Missing required headers for signature verification"});const d=JSON.stringify(a);if(!(0,utils_1.verifyWebhookSignature)(n,e.xLogin,s,d,e.secretKey)){console_1.logger.error("DLOCAL","Webhook signature verification failed");throw(0,error_1.createError)({statusCode:400,message:"Invalid webhook signature"})}const l=a;console_1.logger.info("DLOCAL",`Webhook received for payment ${l.id}, order ${l.order_id}, status: ${l.status}`);const c=await db_1.models.transaction.findOne({where:{uuid:l.order_id},include:[{model:db_1.models.user,as:"user",include:[{model:db_1.models.wallet,as:"wallets"}]}]});if(!c){console_1.logger.error("DLOCAL",`Transaction not found for order ID: ${l.order_id}`);throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"})}const u=utils_1.DLOCAL_STATUS_MAPPING[l.status]||"pending",p=c.status;await c.update({status:u.toUpperCase(),metadata:JSON.stringify({...c.metadata,dlocal_payment_id:l.id,dlocal_status:l.status,dlocal_status_code:l.status_code,dlocal_status_detail:l.status_detail,payment_method_type:l.payment_method_type,approved_date:l.approved_date,webhook_received_at:(new Date).toISOString(),live:l.live})});if("PAID"===l.status&&"COMPLETED"!==p){const e=c.user,t=l.currency,o=c.amount;await db_1.sequelize.transaction(async a=>{let i=await db_1.models.wallet.findOne({where:{userId:e.id,currency:t,type:"FIAT"},transaction:a});if(!i){null==r||r.step("Creating new wallet");i=await wallet_1.walletCreationService.getOrCreateWallet(e.id,"FIAT",t,a)}const s=`dlocal_webhook_${l.id}`;await wallet_1.walletService.credit({idempotencyKey:s,userId:e.id,walletId:i.id,walletType:"FIAT",currency:t,amount:o,operationType:"DEPOSIT",referenceId:l.id,description:`dLocal deposit - ${o} ${t}`,metadata:{method:"DLOCAL",dlocalPaymentId:l.id,paymentMethodType:l.payment_method_type},transaction:a})});console_1.logger.success("DLOCAL",`Wallet updated for user ${e.id}: +${c.amount} ${t}`);try{await notification_1.notificationService.send({userId:e.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_deposit_success_${l.id}`,data:{title:"Deposit Successful",message:`Your deposit of ${o} ${t} via dLocal has been approved and credited to your wallet.`,link:"/wallet"},priority:"NORMAL"});console_1.logger.info("DLOCAL",`Email notification queued for ${e.email} - successful deposit of ${o} ${t}`)}catch(e){console_1.logger.error("DLOCAL","Failed to send email notification",e)}console_1.logger.success("DLOCAL",`Deposit completed: ${l.id}, amount: ${o} ${t}, user: ${e.id}`)}if(["REJECTED","CANCELLED","EXPIRED"].includes(l.status)){console_1.logger.warn("DLOCAL",`Payment failed: ${l.id}, status: ${l.status}, detail: ${l.status_detail}`);try{await notification_1.notificationService.send({userId:c.user.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_deposit_failed_${l.id}`,data:{title:"Deposit Failed",message:`Your dLocal deposit has failed. Status: ${l.status}. ${l.status_detail||"Please contact support for assistance."}`,link:"/wallet"},priority:"NORMAL"});console_1.logger.info("DLOCAL",`Failure notification queued for ${c.user.email} - deposit ${l.id} failed`)}catch(e){console_1.logger.error("DLOCAL","Failed to send failure notification",e)}}if(["REFUNDED","PARTIALLY_REFUNDED"].includes(l.status)&&"COMPLETED"===p){console_1.logger.info("DLOCAL",`Payment refunded: ${l.id}, status: ${l.status}`);const e=c.user,o=l.currency,a=l.amount,i=null===(t=e.wallets)||void 0===t?void 0:t.find(e=>e.currency===o);if(i){const t=Number(i.balance)-Number(a);await i.update({balance:Math.max(0,t)});console_1.logger.info("DLOCAL",`Wallet updated for user ${e.id}: -${a} ${o} (refund)`);try{await notification_1.notificationService.send({userId:e.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_refund_user_${l.id}`,data:{title:"REFUNDED"===l.status?"Deposit Refunded":"Deposit Partially Refunded",message:`Your dLocal deposit of ${a} ${o} has been ${"REFUNDED"===l.status?"fully":"partially"} refunded and deducted from your wallet. ${l.status_detail||""}`,link:"/wallet"},priority:"HIGH"})}catch(e){console_1.logger.error("DLOCAL","Failed to send refund notification",e)}try{const t=await db_1.models.user.findAll({include:[{model:db_1.models.role,as:"role",where:{name:["Admin","Super Admin"]}}],attributes:["id"]});for(const i of t)await notification_1.notificationService.send({userId:i.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_refund_admin_${l.id}_${i.id}`,data:{title:"Deposit Refund Processed",message:`dLocal deposit refund processed: ${a} ${o} for user ${e.id}. Payment ID: ${l.id}`,link:"/admin/finance/transactions"},priority:"NORMAL"})}catch(e){console_1.logger.error("DLOCAL","Failed to send admin refund notification",e)}}else console_1.logger.error("DLOCAL",`Wallet not found for refund: user ${e.id}, currency ${o}`)}if("CHARGEBACK"===l.status&&"COMPLETED"===p){console_1.logger.warn("DLOCAL",`Payment chargeback: ${l.id}`);const e=c.user,t=l.currency,a=l.amount,i=null===(o=e.wallets)||void 0===o?void 0:o.find(e=>e.currency===t);if(i){const o=Number(i.balance)-Number(a);await i.update({balance:Math.max(0,o)});console_1.logger.warn("DLOCAL",`Wallet updated for user ${e.id}: -${a} ${t} (chargeback)`);try{await notification_1.notificationService.send({userId:e.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_chargeback_user_${l.id}`,data:{title:"Deposit Chargeback",message:`Your dLocal deposit of ${a} ${t} has been charged back and deducted from your wallet. ${l.status_detail||"Please contact support if you have questions."}`,link:"/wallet"},priority:"HIGH"})}catch(e){console_1.logger.error("DLOCAL","Failed to send chargeback notification",e)}try{const o=await db_1.models.user.findAll({include:[{model:db_1.models.role,as:"role",where:{name:["Admin","Super Admin"]}}],attributes:["id","email"]});for(const i of o)await notification_1.notificationService.send({userId:i.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_chargeback_admin_${l.id}_${i.id}`,data:{title:"CRITICAL: Deposit Chargeback",message:`dLocal deposit chargeback detected: ${a} ${t} for user ${e.id} (${e.email}). Payment ID: ${l.id}. Immediate review required.`,link:"/admin/finance/transactions"},priority:"HIGH"});console_1.logger.warn("DLOCAL",`Admin chargeback notifications sent for payment ${l.id}`)}catch(e){console_1.logger.error("DLOCAL","Failed to send admin chargeback notification",e)}}else{console_1.logger.error("DLOCAL",`Wallet not found for chargeback: user ${e.id}, currency ${t}`);try{const o=await db_1.models.user.findAll({include:[{model:db_1.models.role,as:"role",where:{name:["Admin","Super Admin"]}}],attributes:["id"]});for(const a of o)await notification_1.notificationService.send({userId:a.id,type:"ALERT",channels:["IN_APP"],idempotencyKey:`dlocal_chargeback_nowallet_${l.id}_${a.id}`,data:{title:"CRITICAL: Chargeback Wallet Not Found",message:`Cannot process chargeback: wallet not found for user ${e.id}, currency ${t}. Payment ID: ${l.id}. Manual intervention required.`,link:"/admin/finance/transactions"},priority:"HIGH"})}catch(e){console_1.logger.error("DLOCAL","Failed to send critical admin notification",e)}}}return{message:"Webhook processed successfully",status:"ok"}}catch(e){console_1.logger.error("DLOCAL","Webhook processing error",e);throw(0,error_1.createError)({statusCode:500,message:e.message||"Webhook processing failed"})}};