"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),console_1=require("@b/utils/console"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verify dLocal payment status",description:"Manually verify a dLocal payment status and update transaction accordingly",operationId:"verifyDLocalPayment",tags:["Finance","Verification"],logModule:"DLOCAL_DEPOSIT",logTitle:"Verify dLocal payment",requestBody:{description:"Payment verification request",content:{"application/json":{schema:{type:"object",properties:{payment_id:{type:"string",description:"dLocal payment ID to verify"},order_id:{type:"string",description:"Internal order ID to verify"}}}}}},responses:{200:{description:"Payment verification completed successfully",content:{"application/json":{schema:{type:"object",properties:{payment_id:{type:"string"},order_id:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},updated:{type:"boolean"},wallet_updated:{type:"boolean"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Payment"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,body:a,ctx:s}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{payment_id:o,order_id:i}=a;if(!o&&!i)throw(0,error_1.createError)({statusCode:400,message:"Either payment_id or order_id is required"});try{let e;i?e=await db_1.models.transaction.findOne({where:{uuid:i},include:[{model:db_1.models.user,as:"user",include:[{model:db_1.models.wallet,as:"wallets"}]}]}):o&&(e=await db_1.models.transaction.findOne({where:{referenceId:o},include:[{model:db_1.models.user,as:"user",include:[{model:db_1.models.wallet,as:"wallets"}]}]}));if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const a=o||(null===(t=e.metadata)||void 0===t?void 0:t.dlocal_payment_id);if(!a)throw(0,error_1.createError)({statusCode:400,message:"dLocal payment ID not found in transaction"});const d=await(0,utils_1.makeDLocalRequest)(`/payments/${a}`,"GET");console_1.logger.info("DLOCAL",`Payment verification: ${a}, status: ${d.status}`);const n=utils_1.DLOCAL_STATUS_MAPPING[d.status]||"pending",c=e.status;let l=!1;await e.update({status:n.toUpperCase(),referenceId:d.id,metadata:JSON.stringify({...e.metadata,dlocal_payment_id:d.id,dlocal_status:d.status,dlocal_status_code:d.status_code,dlocal_status_detail:d.status_detail,payment_method_type:d.payment_method_type,verification_date:(new Date).toISOString(),verified_by:r.id})});if("PAID"===d.status&&"COMPLETED"!==c){const t=e.user,r=d.currency,a=e.amount,o=e.fee||0;null==s||s.step("Processing deposit via wallet service");await(0,utils_2.processFiatDeposit)({userId:t.id,currency:r,amount:a,fee:o,referenceId:d.id,method:"DLOCAL",description:`dLocal deposit - ${a} ${r}`,metadata:{dlocal_payment_id:d.id,payment_method_type:d.payment_method_type},idempotencyKey:`dlocal_deposit_${d.id}`,ctx:s});l=!0;console_1.logger.success("DLOCAL",`Wallet updated for user ${t.id}: +${a} ${r}`);console_1.logger.success("DLOCAL",`Deposit verified and completed: ${d.id}, amount: ${a} ${r}`)}null==s||s.success("Dlocal deposit completed successfully");return{payment_id:d.id,order_id:e.uuid,status:d.status,amount:d.amount,currency:d.currency,updated:!0,wallet_updated:l}}catch(e){console_1.logger.error("DLOCAL","Payment verification error",e);if(e instanceof utils_1.DLocalError)throw(0,error_1.createError)({statusCode:400,message:`dLocal API Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Payment verification failed: ${e.message}`})}};