"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),console_1=require("@b/utils/console");exports.metadata={summary:"Get dLocal payment status",description:"Retrieve current payment status from dLocal API without updating local database",operationId:"getDLocalPaymentStatus",tags:["Finance","Status"],parameters:[{name:"payment_id",in:"query",description:"dLocal payment ID to check",schema:{type:"string"}},{name:"order_id",in:"query",description:"Internal order ID to check",schema:{type:"string"}}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string"},order_id:{type:"string"},amount:{type:"number"},currency:{type:"string"},country:{type:"string"},status:{type:"string"},status_code:{type:"number"},status_detail:{type:"string"},payment_method_id:{type:"string"},payment_method_type:{type:"string"},payment_method_flow:{type:"string"},created_date:{type:"string"},approved_date:{type:"string",nullable:!0},live:{type:"boolean"},payer:{type:"object",properties:{name:{type:"string"},email:{type:"string"},document:{type:"string"},phone:{type:"string"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Payment"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,query:a}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{payment_id:s,order_id:o}=a;if(!s&&!o)throw(0,error_1.createError)({statusCode:400,message:"Either payment_id or order_id is required"});try{let e=s;if(!e&&o){const r=await db_1.models.transaction.findOne({where:{uuid:o}});if(!r)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});e=(null===(t=r.metadata)||void 0===t?void 0:t.dlocal_payment_id)||r.referenceId;if(!e)throw(0,error_1.createError)({statusCode:400,message:"dLocal payment ID not found in transaction"})}const r=await(0,utils_1.makeDLocalRequest)(`/payments/${e}`,"GET");console_1.logger.info("DLOCAL",`Payment status check: ${e}, status: ${r.status}`);return{id:r.id,order_id:r.order_id,amount:r.amount,currency:r.currency,country:r.country,status:r.status,status_code:r.status_code,status_detail:r.status_detail,payment_method_id:r.payment_method_id,payment_method_type:r.payment_method_type,payment_method_flow:r.payment_method_flow,created_date:r.created_date,approved_date:r.approved_date,live:r.live,payer:r.payer}}catch(e){console_1.logger.error("DLOCAL","Payment status check error",e);if(e instanceof utils_1.DLocalError)throw(0,error_1.createError)({statusCode:400,message:`dLocal API Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:`Payment status check failed: ${e.message}`})}};