"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),db_1=require("@b/db");exports.metadata={summary:"Get Authorize.Net transaction status",description:"Retrieves the current status of an Authorize.Net transaction by its reference ID.",operationId:"getAuthorizeNetTransactionStatus",tags:["Finance","Deposit"],requiresAuth:!0,parameters:[{name:"referenceId",in:"query",description:"The transaction reference ID",required:!0,schema:{type:"string"}}],responses:{200:{description:"Transaction status retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{status:{type:"boolean",description:"Indicates if the request was successful"},statusCode:{type:"number",description:"HTTP status code",example:200},data:{type:"object",properties:{transactionId:{type:"string",description:"Transaction ID"},referenceId:{type:"string",description:"Transaction reference ID"},status:{type:"string",description:"Transaction status",enum:["PENDING","COMPLETED","FAILED","CANCELLED","REFUNDED"]},amount:{type:"number",description:"Transaction amount"},currency:{type:"string",description:"Currency code"},fee:{type:"number",description:"Transaction fee"},createdAt:{type:"string",format:"date-time",description:"Transaction creation timestamp"},updatedAt:{type:"string",format:"date-time",description:"Transaction last update timestamp"}}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{referenceId:s}=r;if(!s)throw(0,error_1.createError)({statusCode:400,message:"Reference ID is required"});try{const e=await db_1.models.transaction.findOne({where:{referenceId:s,userId:t.id}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const r=JSON.parse(e.metadata||"{}");return{status:!0,statusCode:200,data:{transactionId:e.id,referenceId:e.referenceId,status:e.status,amount:e.amount,currency:r.currency,fee:e.fee,description:e.description,createdAt:e.createdAt,updatedAt:e.updatedAt,metadata:{method:r.method,totalAmount:r.totalAmount,authorizationId:r.authorizationId,captureId:r.captureId,responseCode:r.responseCode,fraudStatus:r.fraudStatus}}}}catch(e){console_1.logger.error("AUTHORIZENET","Status check error",e);throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to get transaction status"})}};