"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),utils_1=require("./utils"),query_1=require("@b/utils/query"),db_1=require("@b/db");exports.metadata={summary:"Lists all currencies with their current rates",description:"This endpoint retrieves all available currencies along with their current rates.",operationId:"getCurrencies",tags:["Finance","Currency"],logModule:"FINANCE",logTitle:"Get valid currencies",responses:{200:{description:"Currencies retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{...utils_1.baseResponseSchema,data:{type:"array",items:{type:"object",properties:utils_1.baseCurrencySchema}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Currency"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:r}=e,t={status:!0};try{null==r||r.step("Fetching currencies from all wallet types");const[e,s,n]=await Promise.all([db_1.models.currency.findAll({where:t}),db_1.models.exchangeCurrency.findAll({where:t}),db_1.models.ecosystemToken.findAll({where:t})]);null==r||r.step("Formatting currency data");const c={FIAT:e.map(e=>({value:e.id,label:`${e.id} - ${e.name}`})),SPOT:s.map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`})),FUNDING:n.filter((e,r,t)=>t.findIndex(r=>r.currency===e.currency)===r).map(e=>({value:e.currency,label:`${e.currency} - ${e.name}`}))};null==r||r.success(`Retrieved ${e.length} FIAT, ${s.length} SPOT, ${n.length} ECO currencies`);return c}catch(e){null==r||r.fail("Failed to fetch currencies");throw(0,error_1.createError)(500,"An error occurred while fetching currencies")}};