"use strict";async function createOrder(e,r,t){const a=mapOrderData(r);return(await db_1.models.exchangeOrder.create({...a,userId:e},{transaction:t})).get({plain:!0})}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;exports.createOrder=createOrder;const db_1=require("@b/db"),console_1=require("@b/utils/console"),utils_1=require("../utils"),exchange_1=__importDefault(require("@b/utils/exchange")),index_ws_1=require("./index.ws"),query_1=require("@b/utils/query"),utils_2=require("./utils"),wallet_1=require("@b/services/wallet"),error_1=require("@b/utils/error"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Create Order",operationId:"createOrder",tags:["Exchange","Orders"],description:"Creates a new order for the authenticated user.",requestBody:{description:"Order creation data.",content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string",description:"Currency symbol (e.g., BTC)"},pair:{type:"string",description:"Pair symbol (e.g., USDT)"},type:{type:"string",description:"Order type (e.g., limit, market)"},side:{type:"string",description:"Order side (buy or sell)"},amount:{type:"number",description:"Order amount"},price:{type:"number",description:"Order price, required for limit orders"}},required:["currency","pair","type","side","amount"]}}},required:!0},responses:(0,query_1.createRecordResponses)("Order"),requiresAuth:!0,logModule:"EXCHANGE",logTitle:"Create exchange order"};exports.default=async e=>{var r,t,a,i,o,s,d,n,l,u,c,m,p,g,y;const{user:w,body:f,ctx:_}=e;if(!w)throw(0,error_1.createError)({statusCode:401,message:"User not found"});const b=cache_1.CacheManager.getInstance();if(!("true"===await b.getSetting("spotStatus")))throw(0,error_1.createError)({statusCode:403,message:"Spot trading is currently disabled"});try{null==_||_.step("Checking service availability");const e=await(0,utils_1.loadBanStatus)();if(await(0,utils_1.handleBanStatus)(e)){const r=e-Date.now();throw(0,error_1.createError)({statusCode:503,message:`Service temporarily unavailable. Please try again in ${(0,utils_1.formatWaitTime)(r)}.`})}null==_||_.step("Validating order parameters");const{currency:b,pair:h,amount:v,price:C,type:E}=f,$=null===(r=f.side)||void 0===r?void 0:r.toUpperCase();if(!(b&&h&&E&&$&&null!=v))throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters"});if(!["BUY","SELL"].includes($))throw(0,error_1.createError)({statusCode:400,message:"Invalid order side. Must be 'buy' or 'sell'"});if(v<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be greater than zero"});if("limit"===E.toLowerCase()&&(null==C||C<=0))throw(0,error_1.createError)({statusCode:400,message:"Price must be greater than zero for limit orders"});null==_||_.step(`Fetching market data for ${b}/${h}`);const x=`${b}/${h}`,O=await db_1.models.exchangeMarket.findOne({where:{currency:b,pair:h}});if(!O||!O.metadata)throw(0,error_1.createError)({statusCode:404,message:"Market data not found"});const N="string"==typeof O.metadata?JSON.parse(O.metadata):O.metadata,I=Number((null===(a=null===(t=null==N?void 0:N.limits)||void 0===t?void 0:t.amount)||void 0===a?void 0:a.min)||0),S=Number((null===(o=null===(i=null==N?void 0:N.limits)||void 0===i?void 0:i.amount)||void 0===o?void 0:o.max)||0),F=Number((null===(d=null===(s=null==N?void 0:N.limits)||void 0===s?void 0:s.price)||void 0===d?void 0:d.min)||0),T=Number((null===(l=null===(n=null==N?void 0:N.limits)||void 0===n?void 0:n.price)||void 0===l?void 0:l.max)||0),q=Number((null===(c=null===(u=null==N?void 0:N.limits)||void 0===u?void 0:u.cost)||void 0===c?void 0:c.min)||0),L=Number((null===(p=null===(m=null==N?void 0:N.limits)||void 0===m?void 0:m.cost)||void 0===p?void 0:p.max)||0),U=Number(null===(g=N.precision)||void 0===g?void 0:g.amount)||8,k=Number(null===(y=N.precision)||void 0===y?void 0:y.price)||8;null==_||_.step("Validating order limits and precision");if("SELL"===$&&v<I)throw(0,error_1.createError)({statusCode:400,message:`Amount is too low, you need at least ${I.toFixed(U)} ${b}`});if("SELL"===$&&S>0&&v>S)throw(0,error_1.createError)({statusCode:400,message:`Amount is too high, maximum is ${S.toFixed(U)} ${b}`});if(C&&C<F)throw(0,error_1.createError)({statusCode:400,message:`Price is too low, you need at least ${F.toFixed(k)} ${h}`});if(T>0&&C>T)throw(0,error_1.createError)({statusCode:400,message:`Price is too high, maximum is ${T.toFixed(k)} ${h}`});null==_||_.step("Initializing exchange connection");const B=await exchange_1.default.startExchange(_),P=await exchange_1.default.getProvider();if(!B)throw(0,error_1.createError)({statusCode:503,message:"Exchange service is currently unavailable"});let D=C;if("market"===E.toLowerCase()){null==_||_.step("Fetching current market price");const e=await B.fetchTicker(x);if(!e||!e.last)throw(0,error_1.createError)({statusCode:500,message:"Unable to fetch current market price"});D=e.last}null==_||_.step("Calculating order cost");const A=parseFloat(v.toFixed(U)),M=parseFloat(D.toFixed(k)),R=parseFloat((A*M).toFixed(k));if("BUY"===$&&R<q)throw(0,error_1.createError)({statusCode:400,message:`Cost is too low, you need at least ${q.toFixed(k)} ${h}`});if("BUY"===$&&L>0&&R>L)throw(0,error_1.createError)({statusCode:400,message:`Cost is too high, maximum is ${L.toFixed(k)} ${h}`});null==_||_.step(`Checking wallet balances for ${b} and ${h}`);const Y=await wallet_1.walletCreationService.getOrCreateWallet(w.id,"SPOT",b),z=await wallet_1.walletCreationService.getOrCreateWallet(w.id,"SPOT",h);if("BUY"===$&&z.balance<R)throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need at least ${R.toFixed(k)} ${h}`});if("SELL"===$&&Y.balance<v)throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You need at least ${v.toFixed(U)} ${b}`});const G=Number("BUY"===$?N.taker:N.maker),H="BUY"===$?b:h;null==_||_.step(`Creating ${E.toLowerCase()} ${$.toLowerCase()} order on exchange`);let X;try{X=await B.createOrder(x,E.toLowerCase(),$.toLowerCase(),A,"limit"===E.toLowerCase()?M:void 0)}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Unable to process order: ${(0,utils_1.sanitizeErrorMessage)(e.message)}`})}if(!X||!X.id)throw(0,error_1.createError)({statusCode:500,message:"Unable to process order"});null==_||_.step("Fetching and adjusting order data");let j=await B.fetchOrder(X.id,x);if(!j)throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch order"});j=(0,utils_2.adjustOrderData)(j,P,G);null==_||_.step("Updating wallet balances and storing order");const K=`exchange_order_${X.id}`,W=await db_1.sequelize.transaction(async e=>{if("BUY"===$){await wallet_1.walletService.debit({idempotencyKey:`${K}_debit`,userId:w.id,walletId:z.id,walletType:"SPOT",currency:h,amount:R,operationType:"EXCHANGE_ORDER",description:`Buy order: ${A} ${b} @ ${M} ${h}`,metadata:{orderId:X.id,symbol:x,side:$,type:E},transaction:e});if(["closed","filled"].includes(j.status)){const r=Number(j.amount)-Number(j.fee||0);await wallet_1.walletService.credit({idempotencyKey:`${K}_credit`,userId:w.id,walletId:Y.id,walletType:"SPOT",currency:b,amount:r,operationType:"EXCHANGE_ORDER_FILL",fee:Number(j.fee||0),description:`Buy order filled: ${r} ${b}`,metadata:{orderId:X.id,symbol:x,side:$,type:E},transaction:e})}}else{await wallet_1.walletService.debit({idempotencyKey:`${K}_debit`,userId:w.id,walletId:Y.id,walletType:"SPOT",currency:b,amount:A,operationType:"EXCHANGE_ORDER",description:`Sell order: ${A} ${b} @ ${M} ${h}`,metadata:{orderId:X.id,symbol:x,side:$,type:E},transaction:e});if(["closed","filled"].includes(j.status)){const r=Number(j.amount)*Number(j.price)-Number(j.fee||0);await wallet_1.walletService.credit({idempotencyKey:`${K}_credit`,userId:w.id,walletId:z.id,walletType:"SPOT",currency:h,amount:r,operationType:"EXCHANGE_ORDER_FILL",fee:Number(j.fee||0),description:`Sell order filled: ${r} ${h}`,metadata:{orderId:X.id,symbol:x,side:$,type:E},transaction:e})}}return await createOrder(w.id,{...j,referenceId:X.id,fee:Number(j.fee||0),feeCurrency:H},e)});null==_||_.step("Adding order to tracking system");(0,index_ws_1.addOrderToTrackedOrders)(w.id,{id:W.id,status:W.status,price:j.price,amount:j.amount,filled:j.filled,remaining:j.remaining,timestamp:j.timestamp,cost:j.cost});(0,index_ws_1.addUserToWatchlist)(w.id);null==_||_.success(`Order created successfully: ${$} ${A} ${b} @ ${"market"===E.toLowerCase()?"market price":M+" "+h}`);return{message:"Order created successfully"}}catch(e){console_1.logger.error("EXCHANGE","Error creating order",e);throw(0,error_1.createError)({statusCode:e.statusCode||500,message:(0,utils_1.sanitizeErrorMessage)(e.message)})}};const mapOrderData=e=>({referenceId:e.referenceId,status:e.status?e.status.toUpperCase():void 0,symbol:e.symbol,type:e.type?e.type.toUpperCase():void 0,timeInForce:e.timeInForce?e.timeInForce.toUpperCase():void 0,side:e.side?e.side.toUpperCase():void 0,price:Number(e.price),average:null!=e.average?Number(e.average):void 0,amount:Number(e.amount),filled:Number(e.filled),remaining:Number(e.remaining),cost:Number(e.cost),trades:JSON.stringify(e.trades),fee:Number(e.fee||0),feeCurrency:e.feeCurrency});