"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),utils_1=require("./utils"),sequelize_1=require("sequelize"),error_1=require("@b/utils/error");exports.metadata={summary:"List Orders",operationId:"listOrders",tags:["Exchange","Orders"],description:"Retrieves a list of orders for the authenticated user.",logModule:"EXCHANGE",logTitle:"List Orders",parameters:[{name:"type",in:"query",description:"Type of order to retrieve.",schema:{type:"string"}},{name:"currency",in:"query",description:"currency of the order to retrieve.",schema:{type:"string"}},{name:"pair",in:"query",description:"pair of the order to retrieve.",schema:{type:"string"}}],responses:{200:{description:"A list of orders",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseOrderSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,query:t,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{currency:i,pair:o,type:u}=t;null==s||s.step(`Fetching ${u} orders for ${i}/${o}`);const n=await db_1.models.exchangeOrder.findAll({where:{userId:r.id,status:"OPEN"===u?"OPEN":{[sequelize_1.Op.not]:"OPEN"},symbol:`${i}/${o}`}});null==s||s.success(`Retrieved ${n.length} orders`);return n};