"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const exchange_1=__importDefault(require("@b/utils/exchange")),Websocket_1=require("@b/handler/Websocket"),utils_1=require("@b/api/exchange/utils"),db_1=require("@b/db"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={};class UnifiedMarketDataHandler{constructor(){this.accumulatedBuffer={};this.bufferInterval=null;this.unblockTime=0;this.activeSubscriptions=new Map;this.subscriptionParams=new Map;this.exchange=null;this.symbolToStreamKeys={}}getSubscriptionKey(e,t){return"ohlcv"===e&&t?`ohlcv:${t}`:e}static getInstance(){UnifiedMarketDataHandler.instance||(UnifiedMarketDataHandler.instance=new UnifiedMarketDataHandler);return UnifiedMarketDataHandler.instance}flushBuffer(){Object.entries(this.accumulatedBuffer).forEach(([e,t])=>{if(Object.keys(t).length>0){const r="/api/exchange/market",s={...t.payload,symbol:t.symbol};Websocket_1.messageBroker.broadcastToSubscribedClients(r,s,{stream:e,data:t.msg});delete this.accumulatedBuffer[e]}})}ensureCurrentCandleData(e,t){if(!Array.isArray(e)||0===e.length)return e;const r=this.getCurrentCandleTimestamp(t);if(!e.some(e=>{if(Array.isArray(e)&&e.length>=6){const t=Number(e[0]);return Math.abs(t-r)<5e3}return!1})&&e.length>0){const t=e[e.length-1];if(Array.isArray(t)&&t.length>=6){const s=[r,t[4],t[4],t[4],t[4],0],a=[...e,s];a.sort((e,t)=>e[0]-t[0]);return a}}return e}getCurrentCandleTimestamp(e){const t=Date.now(),r=this.getIntervalInMs(e);return Math.floor(t/r)*r}getIntervalInMs(e){return{"1m":6e4,"3m":18e4,"5m":3e5,"15m":9e5,"30m":18e5,"1h":36e5,"2h":72e5,"4h":144e5,"6h":216e5,"8h":288e5,"12h":432e5,"1d":864e5,"3d":2592e5,"1w":6048e5,"1M":2592e6}[e]||36e5}async fetchDataWithRetries(e){for(let t=0;t<3;t++)try{return await e()}catch(e){if(2===t)throw e;await new Promise(e=>setTimeout(e,1e3))}}async handleUnifiedSubscription(e){const t=(t,r)=>{switch(t.split(":")[0]){case"ticker":return async()=>({msg:await this.exchange.watchTicker(e),payload:{type:"ticker",symbol:e},streamKey:"ticker"});case"ohlcv":return async()=>{const t=r.interval||"1h",s=r.limit||1e3;return{msg:await this.exchange.watchOHLCV(e,t,void 0,Number(s)),payload:{type:"ohlcv",interval:t,symbol:e},streamKey:`ohlcv:${t}`}};case"trades":return async()=>{const t=r.limit||20;return{msg:await this.exchange.watchTrades(e,void 0,Number(t)),payload:{type:"trades",symbol:e},streamKey:"trades"}};case"orderbook":return async()=>{const t=r.limit||50;let s=t;const a=await exchange_1.default.getProvider();if("kucoin"===a){const e=[5,20,50,100];s&&!e.includes(s)&&(s=e.reduce((e,t)=>Math.abs(t-s)<Math.abs(e-s)?t:e))}try{const r=await this.exchange.watchOrderBook(e,s?Number(s):void 0);if(r&&r.asks&&r.bids){return{msg:{...r,asks:r.asks.slice(0,t),bids:r.bids.slice(0,t)},payload:{type:"orderbook",...t?{limit:t}:{},symbol:e},streamKey:t?`orderbook:${t}`:"orderbook"}}console_1.logger.warn("EXCHANGE",`Invalid orderbook data structure for ${e}`);return{msg:{asks:[],bids:[],timestamp:Date.now(),symbol:e},payload:{type:"orderbook",...t?{limit:t}:{},symbol:e},streamKey:t?`orderbook:${t}`:"orderbook"}}catch(t){console_1.logger.error("EXCHANGE",`watchOrderBook failed for ${e} (provider: ${a}): ${t.message}`);console_1.logger.debug("EXCHANGE",`Full error: ${JSON.stringify(t)}`);throw t}};default:return null}};for(;this.activeSubscriptions.has(e)&&(0,Websocket_1.hasClients)("/api/exchange/market");)try{if(Date.now()<this.unblockTime){await new Promise(e=>setTimeout(e,1e3));continue}const r=this.activeSubscriptions.get(e);if(!r||0===r.size)break;const s=Array.from(r.entries()).map(async([r,s])=>{const a=t(r,s);if(a)try{return await this.fetchDataWithRetries(a)}catch(t){console_1.logger.error("EXCHANGE",`Error fetching ${r} data for ${e}`,t);return null}return null});(await Promise.allSettled(s)).forEach(t=>{if("fulfilled"===t.status&&t.value){const{msg:r,payload:s,streamKey:a}=t.value;this.accumulatedBuffer[a]={symbol:e,msg:r,payload:s}}else"rejected"===t.status&&console_1.logger.error("EXCHANGE",`Failed to fetch data for ${e}: ${t.reason}`)});await new Promise(e=>setTimeout(e,250))}catch(e){console_1.logger.error("EXCHANGE","Error in unified subscription loop",e);const t=await(0,utils_1.handleExchangeError)(e,exchange_1.default);if("number"==typeof t){this.unblockTime=t;await(0,utils_1.saveBanStatus)(this.unblockTime)}else this.exchange=t;await new Promise(e=>setTimeout(e,5e3))}console_1.logger.info("EXCHANGE",`Subscription loop ended for ${e}`);this.activeSubscriptions.delete(e)}async addSubscription(e){try{this.unblockTime=await(0,utils_1.loadBanStatus)();"string"==typeof e&&(e=JSON.parse(e));const{symbol:t,type:r,interval:s,limit:a}=e.payload;if(!t){console_1.logger.warn("EXCHANGE","No symbol provided in subscription request");return}const[i,o]=t.split("/");if(!i||!o){console_1.logger.warn("EXCHANGE",`Invalid symbol format: ${t}. Expected format: CURRENCY/PAIR`);return}if(!await db_1.models.exchangeMarket.findOne({where:{currency:i,pair:o,status:!0}})){console_1.logger.warn("EXCHANGE",`Market ${t} not found in database or is disabled. Skipping subscription.`);return}this.bufferInterval||(this.bufferInterval=setInterval(()=>this.flushBuffer(),300));if(!this.exchange){this.exchange=await exchange_1.default.startExchange();if(!this.exchange)throw(0,error_1.createError)({statusCode:503,message:"Failed to start exchange"})}const n=await exchange_1.default.getProvider(),c={ticker:"watchTicker",ohlcv:"watchOHLCV",trades:"watchTrades",orderbook:"watchOrderBook"};if(!this.exchange.has[c[r]]){console_1.logger.info("EXCHANGE",`Endpoint ${r} is not available`);return}if("orderbook"===r&&"kucoin"===n&&!this.exchange.has.watchOrderBook){console_1.logger.warn("EXCHANGE",`KuCoin watchOrderBook not supported, skipping orderbook subscription for ${t}`);return}const l=this.getSubscriptionKey(r,s);this.subscriptionParams.set(`${t}:${r}`,{interval:s,limit:a});const u={type:r,symbol:t,interval:s,limit:a};if(this.activeSubscriptions.has(t))this.activeSubscriptions.get(t).set(l,u);else{const e=new Map;e.set(l,u);this.activeSubscriptions.set(t,e);this.handleUnifiedSubscription(t)}}catch(e){console_1.logger.error("EXCHANGE","Failed to add subscription to market data handler",e)}}async removeSubscription(e,t,r){if(this.activeSubscriptions.has(e)){const s=this.getSubscriptionKey(t,r);this.activeSubscriptions.get(e).delete(s);this.subscriptionParams.delete(`${e}:${t}`);if(0===this.activeSubscriptions.get(e).size){this.activeSubscriptions.delete(e);console_1.logger.debug("EXCHANGE",`Removed all subscriptions for ${e}`)}else console_1.logger.debug("EXCHANGE",`Removed ${s} subscription for ${e}. Remaining: ${Array.from(this.activeSubscriptions.get(e).keys())}`)}}async stop(){this.activeSubscriptions.clear();this.subscriptionParams.clear();if(this.bufferInterval){clearInterval(this.bufferInterval);this.bufferInterval=null}if(this.exchange){await exchange_1.default.stopExchange();this.exchange=null}}}exports.default=async(e,t)=>{let r;if("string"==typeof t)try{r=JSON.parse(t)}catch(e){console_1.logger.error("EXCHANGE","Invalid JSON message",e);return}else r=t;if(!r||!r.payload){console_1.logger.error("EXCHANGE","Invalid message structure: payload is missing",new Error("Missing payload"));return}const{action:s}=r,{type:a,symbol:i}=r.payload;if(!a){console_1.logger.error("EXCHANGE","Invalid message structure: type is missing",new Error("Missing type field"));return}const o=UnifiedMarketDataHandler.getInstance();if("UNSUBSCRIBE"===s){if(!i){console_1.logger.error("EXCHANGE","Invalid unsubscribe message: symbol is missing",new Error("Missing symbol"));return}const e=r.payload.interval;await o.removeSubscription(i,a,e)}else await o.addSubscription(r)};