"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),date_fns_1=require("date-fns"),error_1=require("@b/utils/error");exports.metadata={summary:"List Binary Orders from Last 30 Days",operationId:"listBinaryOrdersLast30Days",tags:["Binary","Orders"],description:"Retrieves the non-pending binary orders for practice and non-practice accounts from the last 30 days and compares them with the previous month.",logModule:"EXCHANGE",logTitle:"Get Last 30 Days Binary Orders",responses:{200:{description:"A list of binary orders from the last 30 days",content:{"application/json":{schema:{type:"object",properties:{practiceOrders:{type:"array",items:{type:"object",properties:{}}},nonPracticeOrders:{type:"array",items:{type:"object",properties:{}}},livePercentageChange:{type:"number"},practicePercentageChange:{type:"number"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==t||t.step("Fetching binary orders for last 30 days");const e=(0,date_fns_1.subDays)(new Date,30),s=(0,date_fns_1.subDays)(new Date,60),a=await db_1.models.binaryOrder.findAll({where:{userId:r.id,status:{[sequelize_1.Op.not]:"PENDING"},createdAt:{[sequelize_1.Op.gte]:e}},order:[["createdAt","DESC"]]}),n=await db_1.models.binaryOrder.findAll({where:{userId:r.id,status:{[sequelize_1.Op.not]:"PENDING"},createdAt:{[sequelize_1.Op.between]:[s,e]}},order:[["createdAt","DESC"]]}),i=a.filter(e=>e.isDemo),o=a.filter(e=>!e.isDemo),d=n.filter(e=>e.isDemo),c=n.filter(e=>!e.isDemo),l=(e,r)=>0===r?e>0?100:0:(e-r)/r*100,u=l(o.length,c.length),p=l(i.length,d.length);null==t||t.success(`Retrieved ${a.length} orders (${i.length} practice, ${o.length} live)`);return{practiceOrders:i,nonPracticeOrders:o,livePercentageChange:u,practicePercentageChange:p}}catch(e){console.error("Error :",e);return{status:500,body:{message:"Internal Server Error",error:e.message}}}};