"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console");exports.metadata={summary:"Get Top Blog Authors",description:"Retrieves top authors based on post counts.",operationId:"getAdminTopBlogAuthors",tags:["Blog","Admin","Authors"],requiresAuth:!0,responses:{200:{description:"Top authors retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string"},userId:{type:"string"},status:{type:"string"},postCount:{type:"number"},user:{type:"object",properties:{id:{type:"string"},firstName:{type:"string"},lastName:{type:"string"},email:{type:"string"},avatar:{type:"string"},profile:{type:"object"},role:{type:"object",properties:{name:{type:"string"}}}}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{return(await db_1.models.author.findAll({attributes:["id","userId","status",[(0,sequelize_1.literal)("(\n            SELECT COUNT(*)\n            FROM post\n            WHERE post.authorId = author.id\n            AND post.status = 'PUBLISHED'\n            AND post.deletedAt IS NULL\n          )"),"postCount"]],include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar","profile"],include:[{model:db_1.models.role,as:"role",attributes:["name"]}]}],order:[[(0,sequelize_1.literal)("postCount"),"DESC"]],limit:5})).map(e=>{const t=e.get({plain:!0});return{...t,postCount:parseInt(t.postCount)||0}})}catch(e){console_1.logger.error("BLOG","Error fetching top authors",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch top authors"})}};